/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.legacy.conditions.SCondition;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.conditions.InvalidCondition;
import io.lumine.xikage.mythicmobs.skills.mechanics.DelaySkill;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;

public class Skill
extends AbstractSkill {
    protected final String internalName;
    protected final MythicConfig config;
    protected LinkedList<SkillMechanic> skills = new LinkedList();
    protected List<SkillCondition> conditions = new ArrayList<SkillCondition>();
    protected List<SkillCondition> conditionsTarget = new ArrayList<SkillCondition>();
    protected List<SkillCondition> conditionsTrigger = new ArrayList<SkillCondition>();
    protected List<String> conditionsLegacy = new ArrayList<String>();
    protected List<String> killMessages;

    public Skill(String name, MythicConfig mc) {
        SkillCondition sc;
        String ns;
        int i;
        String[] split;
        this.internalName = name;
        this.config = mc;
        this.cooldown = (float)mc.getDouble("Cooldown", 0.0);
        this.conditionsLegacy = mc.getStringList("LegacyConditions");
        List<String> nTConditions = mc.getStringList("Conditions");
        for (String s : nTConditions) {
            if (s.contains("\"")) {
                split = s.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s = ns;
            }
            if ((sc = SkillCondition.getCondition(s)) instanceof InvalidCondition) continue;
            this.conditions.add(sc);
        }
        nTConditions = mc.getStringList("TargetConditions");
        for (String s : nTConditions) {
            if (s.contains("\"")) {
                split = s.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s = ns;
            }
            if ((sc = SkillCondition.getCondition(s)) instanceof InvalidCondition) continue;
            this.conditionsTarget.add(sc);
        }
        nTConditions = mc.getStringList("TriggerConditions");
        for (String s : nTConditions) {
            if (s.contains("\"")) {
                split = s.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s = ns;
            }
            if ((sc = SkillCondition.getCondition(s)) instanceof InvalidCondition) continue;
            this.conditionsTrigger.add(sc);
        }
        List<String> nSkills = mc.getStringList("Skills");
        for (String s : nSkills) {
            SkillMechanic ms;
            if (s.contains("\"")) {
                String[] split2 = s.split("\"");
                int i2 = 0;
                String ns2 = "";
                for (String ss : split2) {
                    ns2 = i2 % 2 == 1 ? ns2.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns2.concat(ss);
                    ++i2;
                }
                s = ns2;
                s = SkillString.convertLegacyVariables(s);
            }
            if ((ms = MythicMobs.inst().getSkillManager().getSkillMechanic(s)) == null) continue;
            this.skills.add(ms);
        }
    }

    public String getInternalName() {
        return this.internalName;
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public boolean usable(SkillMetadata meta, SkillTrigger trigger) {
        SkillCaster skillCaster = meta.getCaster();
        if (this.onCooldown(skillCaster) || !this.rollChance() || !this.checkHealth(skillCaster) || !this.checkLegacyConditions(skillCaster)) {
            return false;
        }
        for (SkillCondition mc : this.conditionsTarget) {
            if (mc.evaluateTargets(meta)) continue;
            return false;
        }
        for (SkillCondition mc : this.conditionsTrigger) {
            if (mc.evaluateTrigger(meta)) continue;
            return false;
        }
        for (SkillCondition mc : this.conditions) {
            if (mc.evaluateCaster(meta)) continue;
            return false;
        }
        return true;
    }

    public void execute(SkillTrigger basetrigger, SkillCaster caster, AbstractEntity trigger, AbstractLocation origin, HashSet<AbstractEntity> eTargets, HashSet<AbstractLocation> lTargets, float power) {
        SkillMetadata data = new SkillMetadata(basetrigger, caster, trigger, origin, eTargets, lTargets, power);
        this.execute(data);
    }

    public void execute(SkillMetadata data) {
        LinkedList skillqueue = (LinkedList)this.skills.clone();
        Skill.execute(data, skillqueue);
        this.setCooldown(data.getCaster(), this.cooldown);
    }

    public static void execute(SkillMetadata data, Queue<SkillMechanic> skillqueue) {
        while (skillqueue.size() > 0) {
            SkillMechanic mbs = skillqueue.poll();
            if (mbs instanceof DelaySkill) {
                AbstractSkill.DelayedSkill ds = new AbstractSkill.DelayedSkill(data, skillqueue);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.inst(), (Runnable)ds, (long)((DelaySkill)mbs).getTicks());
                break;
            }
            if (!mbs.usable(data.getCaster(), null)) continue;
            mbs.execute(data.deepClone());
        }
    }

    public boolean isUsable(SkillMetadata data) {
        return this.usable(data, null);
    }

    public boolean checkLegacyConditions(SkillCaster skillCaster) {
        if (this.conditionsLegacy.size() > 0) {
            for (String strCondition : this.conditionsLegacy) {
                String[] split = strCondition.split(" ");
                String conditionData = null;
                if (split.length > 1) {
                    conditionData = split[1];
                }
                if (SCondition.getSpawningConditionByName(split[0]).check(BukkitAdapter.adapt(skillCaster.getEntity().getLocation()), (LivingEntity)skillCaster.getEntity().getBukkitEntity(), conditionData)) continue;
                return false;
            }
        }
        return true;
    }
}

