/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.TaskManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public abstract class BuffMechanic
extends SkillMechanic {
    protected Optional<String> buffName = Optional.empty();
    protected int charges;
    protected int interval;
    protected int duration;
    protected boolean cancelOnGiveDamage;
    protected boolean cancelOnTakeDamage;
    protected boolean cancelOnDeath;
    protected boolean cancelOnTeleport;
    protected boolean cancelOnChangeWorld;
    protected boolean cancelOnSkillCast;
    protected boolean cancelOnQuit;
    protected Optional<Skill> onStartSkill = Optional.empty();
    protected Optional<Skill> onTickSkill = Optional.empty();
    protected Optional<Skill> onEndSkill = Optional.empty();
    protected String onStartSkillName;
    protected String onTickSkillName;
    protected String onEndSkillName;

    public BuffMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        String buffName = mlc.getString(new String[]{"buffname"}, null, new String[0]);
        if (buffName != null) {
            this.buffName = Optional.of(buffName);
        }
        this.charges = mlc.getInteger(new String[]{"charges", "c"}, 0);
        this.interval = mlc.getInteger(new String[]{"interval", "i"}, 20);
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 200);
        this.cancelOnGiveDamage = mlc.getBoolean(new String[]{"cancelongivedamage", "cogd"}, false);
        this.cancelOnTakeDamage = mlc.getBoolean(new String[]{"cancelontakedamage", "cotd"}, false);
        this.cancelOnDeath = mlc.getBoolean(new String[]{"cancelondeath", "cod"}, true);
        this.cancelOnTeleport = mlc.getBoolean(new String[]{"cancelonteleport", "cot"}, false);
        this.cancelOnChangeWorld = mlc.getBoolean(new String[]{"cancelonchangeworld", "cocw"}, false);
        this.cancelOnSkillCast = mlc.getBoolean(new String[]{"cancelonskilluse", "cosu"}, false);
        this.cancelOnQuit = mlc.getBoolean(new String[]{"cancelonquit", "coq"}, false);
        this.onStartSkillName = mlc.getString(new String[]{"onstartskill", "onstart", "os"});
        this.onTickSkillName = mlc.getString(new String[]{"ontickskill", "ontick", "ot"});
        this.onEndSkillName = mlc.getString(new String[]{"onendskill", "onend", "oe"});
        MythicMobs.inst().getSkillManager().queueSecondPass(() -> {
            if (this.onStartSkillName != null) {
                this.onStartSkill = MythicMobs.inst().getSkillManager().getSkill(this.onStartSkillName);
            }
            if (this.onTickSkillName != null) {
                this.onTickSkill = MythicMobs.inst().getSkillManager().getSkill(this.onTickSkillName);
            }
            if (this.onEndSkillName != null) {
                this.onEndSkill = MythicMobs.inst().getSkillManager().getSkill(this.onEndSkillName);
            }
        });
    }

    public boolean executeStartSkills(SkillMetadata data) {
        if (this.onStartSkillName == null) {
            return false;
        }
        if (!this.onStartSkill.isPresent()) {
            return false;
        }
        if (this.onStartSkill.get().isUsable(data)) {
            this.onStartSkill.get().execute(data);
            return true;
        }
        return false;
    }

    public boolean executeTickSkills(SkillMetadata data) {
        if (this.onTickSkillName == null) {
            return false;
        }
        if (!this.onTickSkill.isPresent()) {
            return false;
        }
        if (this.onTickSkill.get().isUsable(data)) {
            this.onTickSkill.get().execute(data);
            return true;
        }
        return false;
    }

    public boolean executeEndSkills(SkillMetadata data) {
        if (this.onEndSkillName == null) {
            return false;
        }
        if (!this.onEndSkill.isPresent()) {
            return false;
        }
        if (this.onEndSkill.get().isUsable(data)) {
            this.onEndSkill.get().execute(data);
            return true;
        }
        return false;
    }

    public abstract class BuffTracker
    implements Runnable {
        private int taskId;
        protected SkillMetadata data;
        private int chargesRemaining;
        private long startTime;
        private int timer = 0;
        private boolean hasEnded = false;

        public BuffTracker(SkillMetadata data) {
            this.data = data;
            this.chargesRemaining = BuffMechanic.this.charges;
            this.startTime = System.currentTimeMillis();
            MythicMobs.debug(3, "++ BuffTracker Activated for " + data.getCaster().getEntity().getName() + ": skill = " + BuffMechanic.this.line);
            BuffMechanic.this.executeStartSkills(data);
            this.taskId = TaskManager.get().scheduleTask(this, 0, BuffMechanic.this.interval);
            this.start();
        }

        public boolean isValid() {
            if (this.chargesRemaining <= 0) {
                return false;
            }
            double d = (long)BuffMechanic.this.duration - TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.startTime);
            return !(d <= 0.0);
        }

        @Override
        public void run() {
            this.timer += BuffMechanic.this.interval;
            if (!this.hasEnded && this.timer > BuffMechanic.this.duration) {
                this.cancel();
            }
            BuffMechanic.this.executeTickSkills(this.data.deepClone().setOrigin(this.data.getCaster().getLocation().clone()).setLocationTarget(this.data.getCaster().getLocation().clone()));
        }

        public void consumeCharge() {
            if (BuffMechanic.this.charges <= 0) {
                return;
            }
            --this.chargesRemaining;
            if (this.chargesRemaining <= 0) {
                this.cancel();
            }
        }

        public abstract void start();

        public abstract void stop();

        public void cancel() {
            MythicMobs.debug(3, "++ BuffTracker cancelled for " + this.data.getCaster().getEntity().getName() + ": skill = " + BuffMechanic.this.line);
            if (!this.hasEnded) {
                BuffMechanic.this.executeEndSkills(this.data.deepClone().setOrigin(this.data.getCaster().getLocation().clone()).setLocationTarget(this.data.getCaster().getLocation().clone()));
                this.hasEnded = true;
            }
            this.stop();
            TaskManager.get().cancelTask(this.taskId);
        }
    }
}

