/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.mobs.entities;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.MythicEntity;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Zombie;

public class MythicZombie
extends MythicEntity {
    private static final int height = 2;
    private double reinforcementChance = -1.0;

    @Override
    public void instantiate(MythicConfig mc) {
        this.reinforcementChance = mc.getDouble("Options.ReinforcementsChance", -1.0);
    }

    @Override
    public Entity spawn(MythicMob mm, Location location) {
        Zombie e = (Zombie)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
        e.setBaby(false);
        if (MythicMobs.inst().getMinecraftVersion() < 11) {
            if (MythicMobs.inst().getMinecraftVersion() >= 9) {
                e.setVillagerProfession(null);
            } else {
                e.setVillager(false);
            }
        }
        e = (Zombie)this.applyOptions((Entity)e);
        return e;
    }

    @Override
    public Entity spawn(Location location) {
        Zombie e = (Zombie)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
        e.setBaby(false);
        if (MythicMobs.inst().getMinecraftVersion() < 11) {
            if (MythicMobs.inst().getMinecraftVersion() >= 9) {
                e.setVillagerProfession(null);
            } else {
                e.setVillager(false);
            }
        }
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Zombie e = (Zombie)entity;
        if (this.reinforcementChance >= 0.0) {
            if (MythicMobs.inst().getMinecraftVersion() >= 9) {
                e.getAttribute(Attribute.ZOMBIE_SPAWN_REINFORCEMENTS).setBaseValue(this.reinforcementChance);
            } else {
                MythicMobs.inst().getVolatileCodeHandler().setZombieSpawnReinforcements(e, this.reinforcementChance);
            }
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return MythicZombie.isInstanceOf(e);
    }

    public static boolean isInstanceOf(Entity e) {
        if (e instanceof Zombie) {
            if (MythicMobs.inst().getMinecraftVersion() >= 11) {
                if (!((Zombie)e).isBaby()) {
                    return true;
                }
            } else if (MythicMobs.inst().getMinecraftVersion() >= 10) {
                if (((Zombie)e).getVillagerProfession() != null && ((Zombie)e).getVillagerProfession() == Villager.Profession.HUSK) {
                    return false;
                }
                return !((Zombie)e).isBaby() && !((Zombie)e).isVillager();
            }
        }
        return false;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

