/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.mobs.entities;

import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.MythicEntity;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;

public class MythicWolf
extends MythicEntity {
    private static final int height = 1;
    private int age = 10;
    private boolean agelock = false;
    private boolean angry = false;
    private DyeColor color;
    private boolean tameable = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.age = mc.getInt("Options.Age");
        this.agelock = mc.getBoolean("Options.AgeLock", false);
        this.angry = mc.getBoolean("Options.Angry", false);
        this.tameable = mc.getBoolean("Options.Tameable", false);
        String strColor = mc.getString("Options.Color");
        if (strColor != null) {
            this.color = strColor.matches("[0-9]*") ? DyeColor.getByWoolData((byte)Byte.parseByte(strColor)) : DyeColor.valueOf((String)strColor.toUpperCase());
        }
    }

    @Override
    public Entity spawn(MythicMob mm, Location location) {
        Entity e = location.getWorld().spawnEntity(location, EntityType.WOLF);
        e = this.applyOptions(e);
        return e;
    }

    @Override
    public Entity spawn(Location location) {
        Entity e = location.getWorld().spawnEntity(location, EntityType.WOLF);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Wolf e = (Wolf)entity;
        e.setAge(this.age);
        e.setAgeLock(this.agelock);
        e.setAngry(this.angry);
        if (this.color != null) {
            e.setCollarColor(this.color);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Wolf;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    public boolean isTameable() {
        return this.tameable;
    }

    public AbstractPlayer getOwner(ActiveMob am) {
        Wolf w;
        Entity e = BukkitAdapter.adapt(am.getEntity());
        if (e instanceof Wolf && (w = (Wolf)e).getOwner() instanceof Player) {
            return BukkitAdapter.adapt((Player)w.getOwner());
        }
        return null;
    }
}

