/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.mobs.entities;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.MythicEntity;
import io.lumine.xikage.mythicmobs.util.types.RandomDouble;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.util.EulerAngle;

public class MythicArmorStand
extends MythicEntity {
    private static final int height = 2;
    private boolean isMarker = false;
    private boolean has_arms = true;
    private boolean has_gravity = true;
    private boolean invisible = false;
    private boolean small = false;
    private String item_head = null;
    private String item_body = null;
    private String item_legs = null;
    private String item_feet = null;
    private String item_hand = null;
    private Optional<RandomDouble> headPoseP = Optional.empty();
    private Optional<RandomDouble> headPoseY = Optional.empty();
    private Optional<RandomDouble> headPoseA = Optional.empty();
    private Optional<RandomDouble> bodyPoseP = Optional.empty();
    private Optional<RandomDouble> bodyPoseY = Optional.empty();
    private Optional<RandomDouble> bodyPoseA = Optional.empty();
    private Optional<RandomDouble> lArmPoseP = Optional.empty();
    private Optional<RandomDouble> lArmPoseY = Optional.empty();
    private Optional<RandomDouble> lArmPoseA = Optional.empty();
    private Optional<RandomDouble> rArmPoseP = Optional.empty();
    private Optional<RandomDouble> rArmPoseY = Optional.empty();
    private Optional<RandomDouble> rArmPoseA = Optional.empty();
    private Optional<RandomDouble> lLegPoseP = Optional.empty();
    private Optional<RandomDouble> lLegPoseY = Optional.empty();
    private Optional<RandomDouble> lLegPoseA = Optional.empty();
    private Optional<RandomDouble> rLegPoseP = Optional.empty();
    private Optional<RandomDouble> rLegPoseY = Optional.empty();
    private Optional<RandomDouble> rLegPoseA = Optional.empty();

    @Override
    public void instantiate(MythicConfig mc) {
        block23: {
            String rLegPose;
            block22: {
                String lLegPose;
                block21: {
                    String rArmPose;
                    block20: {
                        String lArmPose;
                        block19: {
                            String bodyPose;
                            block18: {
                                this.has_arms = mc.getBoolean("Options.HasArms", false);
                                this.has_gravity = mc.getBoolean("Options.HasGravity", true);
                                this.small = mc.getBoolean("Options.Small", false);
                                this.invisible = mc.getBoolean("Options.Invisible", false);
                                this.isMarker = mc.getBoolean("Options.Marker", false);
                                this.item_head = mc.getString("Options.ItemHead", null);
                                this.item_body = mc.getString("Options.ItemBody", null);
                                this.item_legs = mc.getString("Options.ItemLegs", null);
                                this.item_feet = mc.getString("Options.ItemFeet", null);
                                this.item_hand = mc.getString("Options.ItemHand", null);
                                String headPose = mc.getString("Pose.Head", null);
                                if (headPose != null) {
                                    try {
                                        String[] split = headPose.split(",");
                                        this.headPoseP = Optional.of(new RandomDouble(split[0]));
                                        this.headPoseY = Optional.of(new RandomDouble(split[1]));
                                        this.headPoseA = Optional.of(new RandomDouble(split[2]));
                                    }
                                    catch (Exception ex) {
                                        MythicMobs.error("ArmorStand Pose is configured incorrectly: must be in format: pitch,yaw,angle");
                                        if (ConfigManager.debugLevel <= 0) break block18;
                                        ex.printStackTrace();
                                    }
                                }
                            }
                            if ((bodyPose = mc.getString("Pose.Body", null)) != null) {
                                try {
                                    String[] split = bodyPose.split(",");
                                    this.bodyPoseP = Optional.of(new RandomDouble(split[0]));
                                    this.bodyPoseY = Optional.of(new RandomDouble(split[1]));
                                    this.bodyPoseA = Optional.of(new RandomDouble(split[2]));
                                }
                                catch (Exception ex) {
                                    MythicMobs.error("ArmorStand Pose is configured incorrectly: must be in format: pitch,yaw,angle");
                                    if (ConfigManager.debugLevel <= 0) break block19;
                                    ex.printStackTrace();
                                }
                            }
                        }
                        if ((lArmPose = mc.getString("Pose.LeftArm", null)) != null) {
                            try {
                                String[] split = lArmPose.split(",");
                                this.lArmPoseP = Optional.of(new RandomDouble(split[0]));
                                this.lArmPoseY = Optional.of(new RandomDouble(split[1]));
                                this.lArmPoseA = Optional.of(new RandomDouble(split[2]));
                            }
                            catch (Exception ex) {
                                MythicMobs.error("ArmorStand Pose is configured incorrectly: must be in format: pitch,yaw,angle");
                                if (ConfigManager.debugLevel <= 0) break block20;
                                ex.printStackTrace();
                            }
                        }
                    }
                    if ((rArmPose = mc.getString("Pose.RightArm", null)) != null) {
                        try {
                            String[] split = rArmPose.split(",");
                            this.rArmPoseP = Optional.of(new RandomDouble(split[0]));
                            this.rArmPoseY = Optional.of(new RandomDouble(split[1]));
                            this.rArmPoseA = Optional.of(new RandomDouble(split[2]));
                        }
                        catch (Exception ex) {
                            MythicMobs.error("ArmorStand Pose is configured incorrectly: must be in format: pitch,yaw,angle");
                            if (ConfigManager.debugLevel <= 0) break block21;
                            ex.printStackTrace();
                        }
                    }
                }
                if ((lLegPose = mc.getString("Pose.LeftLeg", null)) != null) {
                    try {
                        String[] split = lLegPose.split(",");
                        this.lLegPoseP = Optional.of(new RandomDouble(split[0]));
                        this.lLegPoseY = Optional.of(new RandomDouble(split[1]));
                        this.lLegPoseA = Optional.of(new RandomDouble(split[2]));
                    }
                    catch (Exception ex) {
                        MythicMobs.error("ArmorStand Pose is configured incorrectly: must be in format: pitch,yaw,angle");
                        if (ConfigManager.debugLevel <= 0) break block22;
                        ex.printStackTrace();
                    }
                }
            }
            if ((rLegPose = mc.getString("Pose.RightLeg", null)) != null) {
                try {
                    String[] split = rLegPose.split(",");
                    this.rLegPoseP = Optional.of(new RandomDouble(split[0]));
                    this.rLegPoseY = Optional.of(new RandomDouble(split[1]));
                    this.rLegPoseA = Optional.of(new RandomDouble(split[2]));
                }
                catch (Exception ex) {
                    MythicMobs.error("ArmorStand Pose is configured incorrectly: must be in format: pitch,yaw,angle");
                    if (ConfigManager.debugLevel <= 0) break block23;
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public Entity spawn(MythicMob mm, Location location) {
        ArmorStand e = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        e = this.applyOptions((Entity)e);
        return e;
    }

    @Override
    public Entity spawn(Location location) {
        ArmorStand e = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        e = this.applyOptions((Entity)e);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        EulerAngle a;
        MythicItem mi;
        Optional<MythicItem> maybeItem;
        ArmorStand e = (ArmorStand)entity;
        if (this.has_arms) {
            e.setArms(true);
        }
        if (!this.has_gravity) {
            e.setGravity(false);
        }
        if (this.invisible) {
            e.setVisible(false);
        }
        if (this.small) {
            e.setSmall(true);
        }
        if (this.isMarker) {
            e.setMarker(true);
        }
        if (this.item_head != null && (maybeItem = MythicMobs.inst().getItemManager().getItem(this.item_head)).isPresent()) {
            mi = maybeItem.get();
            e.setHelmet(BukkitAdapter.adapt(mi.generateItemStack(1)));
        }
        if (this.item_body != null && (maybeItem = MythicMobs.inst().getItemManager().getItem(this.item_body)).isPresent()) {
            mi = maybeItem.get();
            e.setChestplate(BukkitAdapter.adapt(mi.generateItemStack(1)));
        }
        if (this.item_legs != null && (maybeItem = MythicMobs.inst().getItemManager().getItem(this.item_legs)).isPresent()) {
            mi = maybeItem.get();
            e.setLeggings(BukkitAdapter.adapt(mi.generateItemStack(1)));
        }
        if (this.item_feet != null && (maybeItem = MythicMobs.inst().getItemManager().getItem(this.item_feet)).isPresent()) {
            mi = maybeItem.get();
            e.setBoots(BukkitAdapter.adapt(mi.generateItemStack(1)));
        }
        if (this.item_hand != null && (maybeItem = MythicMobs.inst().getItemManager().getItem(this.item_hand)).isPresent()) {
            mi = maybeItem.get();
            e.setItemInHand(BukkitAdapter.adapt(mi.generateItemStack(1)));
        }
        if (this.headPoseP.isPresent()) {
            a = new EulerAngle((double)((float)this.headPoseP.get().get()), (double)((float)this.headPoseY.get().get()), (double)((float)this.headPoseA.get().get()));
            e.setHeadPose(a);
        }
        if (this.bodyPoseP.isPresent()) {
            a = new EulerAngle((double)((float)this.bodyPoseP.get().get()), (double)((float)this.bodyPoseY.get().get()), (double)((float)this.bodyPoseA.get().get()));
            e.setBodyPose(a);
        }
        if (this.lArmPoseP.isPresent()) {
            a = new EulerAngle((double)((float)this.lArmPoseP.get().get()), (double)((float)this.lArmPoseY.get().get()), (double)((float)this.lArmPoseA.get().get()));
            e.setLeftArmPose(a);
        }
        if (this.rArmPoseP.isPresent()) {
            a = new EulerAngle((double)((float)this.rArmPoseP.get().get()), (double)((float)this.rArmPoseY.get().get()), (double)((float)this.rArmPoseA.get().get()));
            e.setRightArmPose(a);
        }
        if (this.lLegPoseP.isPresent()) {
            a = new EulerAngle((double)((float)this.lLegPoseP.get().get()), (double)((float)this.lLegPoseY.get().get()), (double)((float)this.lLegPoseA.get().get()));
            e.setLeftLegPose(a);
        }
        if (this.rLegPoseP.isPresent()) {
            a = new EulerAngle((double)((float)this.rLegPoseP.get().get()), (double)((float)this.rLegPoseY.get().get()), (double)((float)this.rLegPoseA.get().get()));
            e.setRightLegPose(a);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof ArmorStand;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

