/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.legacy.commands;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMobStack;
import io.lumine.xikage.mythicmobs.mobs.WorldScaling;
import io.lumine.xikage.mythicmobs.util.PageableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class MobCommands {
    public static void menuCommands(CommandSender sender) {
        sender.sendMessage(MythicMobs.menu_header);
        sender.sendMessage(ChatColor.YELLOW + "" + ChatColor.ITALIC + "Command argumnts in <>'s are optional");
        sender.sendMessage(ChatColor.GOLD + "/mm mobs list <search filter>" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - List all loaded Mythic Mobs");
        sender.sendMessage(ChatColor.GOLD + "/mm mobs info [MobName]" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Show info about the given Mythic Mob");
        sender.sendMessage(ChatColor.GOLD + "/mm mobs kill [MobName]" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Kill all Mythic Mobs with the given name");
        sender.sendMessage(ChatColor.GOLD + "/mm mobs killall" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Remove ALL Mythic Mobs");
        sender.sendMessage(ChatColor.GOLD + "/mm mobs spawn [MobName] <amount> <world,x,y,z>" + ChatColor.GREEN + "" + ChatColor.ITALIC + " - Spawn a mob");
    }

    public static void parseCommands(CommandSender sender, Command cmd, String commandlabel, String[] args) {
        if (args.length == 1) {
            MobCommands.menuCommands(sender);
            return;
        }
        switch (args[1]) {
            case "spawn": 
            case "s": {
                MobCommands.cmdMobSpawn(sender, args, false);
                break;
            }
            case "spawnsilent": 
            case "ss": {
                MobCommands.cmdMobSpawn(sender, args, true);
                break;
            }
            case "list": 
            case "l": {
                MobCommands.cmdMobsList(sender, args);
                break;
            }
            case "listactive": 
            case "la": {
                MobCommands.cmdMobsListActive(sender, args);
                break;
            }
            case "kill": 
            case "k": {
                MobCommands.cmdMobsKill(sender, args);
                break;
            }
            case "killall": 
            case "ka": {
                MobCommands.cmdMobsKillAll(sender, args);
                break;
            }
            case "info": 
            case "i": {
                MobCommands.cmdMobInfo(sender, args);
                break;
            }
            case "clean": {
                MobCommands.cmdMobsClean(sender, args);
                break;
            }
            case "stats": {
                MobCommands.cmdMobStats(sender, args);
                break;
            }
            default: {
                MobCommands.menuCommands(sender);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void cmdMobSpawn(CommandSender sender, String[] args, boolean silent) {
        loc = null;
        amount = 1;
        if (args.length < 3) {
            if (!silent) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must specify a mob to spawn.");
            }
            return;
        }
        level = 1;
        if (args.length > 3) {
            try {
                MythicMobs.debug(1, "Parsing mob amount from: " + args[3]);
                amount = Integer.parseInt(args[3]);
            }
            catch (Exception e) {
                if (!silent) {
                    sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "Invalid mob amount supplied: must be an integer.");
                }
                return;
            }
        }
        if (args.length > 4) {
            try {
                part = args[4].split(",");
                w = Bukkit.getWorld((String)part[0]);
                x = Float.parseFloat(part[1]);
                y = Float.parseFloat(part[2]);
                z = Float.parseFloat(part[3]);
                MythicMobs.debug(1, "Parsing location using: " + w.toString() + "," + x + "," + y + "," + z);
                if (w == null) ** GOTO lbl33
                loc = new Location(w, (double)x, (double)y, (double)z);
            }
            catch (Exception e) {
                if (!silent) {
                    sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "Invalid location specified for spawning a mob: location must be in format world,x,y,z");
                }
                return;
            }
        } else {
            loc = sender instanceof Player != false ? ((Player)sender).getLocation() : null;
        }
lbl33:
        // 3 sources

        if (loc == null) {
            if (!silent) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "Invalid location specified for spawning a mob: world does not exist.");
            }
            return;
        }
        if (args[2].contains(":")) {
            split = args[2].split(":");
            mob = split[0];
            try {
                level = Integer.parseInt(split[1]);
            }
            catch (Exception ex) {
                if (!silent) {
                    sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "Invalid mob level supplied: must be an integer.");
                }
                return;
            }
        } else {
            mob = args[2];
            level = WorldScaling.getLevelBonus(BukkitAdapter.adapt(loc));
        }
        l = null;
        for (i = 0; i < amount; ++i) {
            l = MythicMobs.inst().getMobManager().spawnMob(mob, loc, level);
        }
        if (l != null) {
            if (!silent) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Mobs " + ChatColor.AQUA + args[2] + ChatColor.GREEN + " spawned at your location!");
            }
        } else if (!silent) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "No Mythic Mob loaded with the name " + args[2] + ".");
        }
    }

    public static void cmdMobsList(CommandSender sender, String[] args) {
        String[] parts;
        String s = "";
        boolean page = true;
        s = args.length > 2 ? ChatColor.GOLD + "Mythic Mobs found containing " + args[2] + ": " : ChatColor.GOLD + "Mobs Loaded: ";
        ArrayList<MythicMob> mobs = new ArrayList<MythicMob>(MythicMobs.inst().getMobManager().getMobTypes());
        Collections.sort(mobs);
        PageableList<MythicMob> pages = new PageableList<MythicMob>(mobs);
        for (MythicMob mm : MythicMobs.inst().getMobManager().getMobTypes()) {
            if (args.length > 2) {
                if (!mm.getInternalName().contains(args[2])) continue;
                parts = mm.getInternalName().split(args[2]);
                if (parts.length == 2) {
                    s = s + ChatColor.RED + parts[0] + ChatColor.DARK_RED + args[2] + ChatColor.RED + parts[1] + ChatColor.GRAY + ", ";
                }
                if (parts.length == 1) {
                    s = s + ChatColor.RED + parts[0] + ChatColor.DARK_RED + args[2] + ChatColor.GRAY + ", ";
                }
                if (parts.length != 0) continue;
                s = s + ChatColor.DARK_RED + args[2] + ChatColor.GRAY + ", ";
                continue;
            }
            s = s + ChatColor.RED + mm.getInternalName() + ChatColor.GRAY + ", ";
        }
        for (MythicMobStack el : MythicMobs.inst().getMobManager().getMobStacks()) {
            if (args.length > 2) {
                if (!el.getName().contains(args[2])) continue;
                parts = el.getName().split(args[2]);
                if (parts.length == 2) {
                    s = s + ChatColor.RED + parts[0] + ChatColor.DARK_RED + args[2] + ChatColor.RED + parts[1] + ChatColor.GRAY + ", ";
                }
                if (parts.length == 1) {
                    s = s + ChatColor.RED + parts[0] + ChatColor.DARK_RED + args[2] + ChatColor.GRAY + ", ";
                }
                if (parts.length != 0) continue;
                s = s + ChatColor.DARK_RED + args[2] + ChatColor.GRAY + ", ";
                continue;
            }
            s = s + ChatColor.RED + el.getName() + ChatColor.GRAY + ", ";
        }
        sender.sendMessage(s);
    }

    public static void cmdMobsFind(CommandSender sender, String[] args) {
        String[] parts;
        String s = "";
        s = args.length > 2 ? ChatColor.GOLD + "Mythic Mobs found containing " + args[2] + ": " : ChatColor.GOLD + "Mobs Loaded: ";
        for (MythicMob mm : MythicMobs.inst().getMobManager().getMobTypes()) {
            if (args.length > 2) {
                if (!mm.getInternalName().contains(args[2])) continue;
                parts = mm.getInternalName().split(args[2]);
                if (parts.length == 2) {
                    s = s + ChatColor.RED + parts[0] + ChatColor.DARK_RED + args[2] + ChatColor.RED + parts[1] + ChatColor.GRAY + ", ";
                }
                if (parts.length == 1) {
                    s = s + ChatColor.RED + parts[0] + ChatColor.DARK_RED + args[2] + ChatColor.GRAY + ", ";
                }
                if (parts.length != 0) continue;
                s = s + ChatColor.DARK_RED + args[2] + ChatColor.GRAY + ", ";
                continue;
            }
            s = s + ChatColor.RED + mm.getInternalName() + ChatColor.GRAY + ", ";
        }
        for (MythicMobStack el : MythicMobs.inst().getMobManager().getMobStacks()) {
            if (args.length > 2) {
                if (!el.getName().contains(args[2])) continue;
                parts = el.getName().split(args[2]);
                if (parts.length == 2) {
                    s = s + ChatColor.RED + parts[0] + ChatColor.DARK_RED + args[2] + ChatColor.RED + parts[1] + ChatColor.GRAY + ", ";
                }
                if (parts.length == 1) {
                    s = s + ChatColor.RED + parts[0] + ChatColor.DARK_RED + args[2] + ChatColor.GRAY + ", ";
                }
                if (parts.length != 0) continue;
                s = s + ChatColor.DARK_RED + args[2] + ChatColor.GRAY + ", ";
                continue;
            }
            s = s + ChatColor.RED + el.getName() + ChatColor.GRAY + ", ";
        }
        sender.sendMessage(s);
    }

    public static void cmdMobsKill(CommandSender sender, String[] args) {
        String s = ChatColor.GREEN + "Mobs Killed: ";
        for (LivingEntity l : MythicMobs.inst().getMobManager().getAllMythicEntities()) {
            ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)l);
            if (am == null || !am.getType().getInternalName().contains(args[2])) continue;
            am.setDespawned();
            MythicMobs.inst().getMobManager().unregisterActiveMob(am);
            l.remove();
        }
        for (MythicMob mm : MythicMobs.inst().getMobManager().getMobTypes()) {
            if (!mm.getInternalName().contains(args[2])) continue;
            String[] parts = mm.getInternalName().split(args[2]);
            if (parts.length == 2) {
                s = s + ChatColor.RED + parts[0] + ChatColor.DARK_RED + args[2] + ChatColor.RED + parts[1] + ChatColor.GRAY + ", ";
            }
            if (parts.length == 1) {
                s = s + ChatColor.RED + parts[0] + ChatColor.DARK_RED + args[2] + ChatColor.GRAY + ", ";
            }
            if (parts.length != 0) continue;
            s = s + ChatColor.DARK_RED + args[2] + ChatColor.GRAY + ", ";
        }
        System.gc();
        sender.sendMessage(s);
    }

    public static void cmdMobsKillAll(CommandSender sender, String[] args) {
        int radius = 0;
        boolean literally = false;
        if (args.length > 2) {
            radius = Integer.parseInt(args[2]);
        }
        if (args.length > 3 && args[3].equals("LITERALLY")) {
            literally = true;
        }
        int amount = 0;
        if (radius > 0) {
            AbstractPlayer player = BukkitAdapter.adapt((Player)sender);
            for (ActiveMob am : MythicMobs.inst().getMobManager().getActiveMobs()) {
                if (am.getType().isPersistent() && !literally || !am.getLocation().getWorld().equals(player.getWorld()) || !(am.getLocation().distanceSquared(player.getLocation()) <= Math.pow(radius, 2.0))) continue;
                am.setDead();
                MythicMobs.inst().getMobManager().unregisterActiveMob(am);
                am.getEntity().remove();
                ++amount;
            }
        } else {
            amount = literally ? MythicMobs.inst().getMobManager().removeAllAllMobs() : MythicMobs.inst().getMobManager().removeAllMobs();
        }
        sender.sendMessage(ChatColor.GREEN + "Removed " + amount + " Mythic Mobs!");
        System.gc();
    }

    public static void cmdMobsClean(CommandSender sender, String[] args) {
        System.gc();
    }

    public static void cmdMobInfo(CommandSender sender, String[] args) {
        if (MythicMobs.inst().getMobManager().getMythicMob(args[2]) != null) {
            MythicMob mm = MythicMobs.inst().getMobManager().getMythicMob(args[2]);
            sender.sendMessage(ChatColor.GOLD + "Stats for " + ChatColor.BOLD + ChatColor.GRAY + mm.getInternalName() + ":");
            sender.sendMessage(ChatColor.GOLD + "displayName: " + ChatColor.GRAY + mm.getDisplayName() + ChatColor.GRAY + " / " + ChatColor.translateAlternateColorCodes((char)'&', (String)mm.getDisplayName()));
            sender.sendMessage(ChatColor.GOLD + "MobType: " + ChatColor.GRAY + mm.getEntityType());
            sender.sendMessage(ChatColor.GOLD + "Damage: " + ChatColor.GRAY + mm.getBaseDamage() + " (+" + mm.getPerLevelDamage() + " per level)");
            sender.sendMessage(ChatColor.GOLD + "Health: " + ChatColor.GRAY + mm.getHealth() + " (+" + mm.getPerLevelHealth() + " per level)");
            sender.sendMessage(ChatColor.GOLD + "Armor: " + ChatColor.GRAY + mm.getBaseArmor() + " (+" + mm.getPerLevelArmor() + " per level)");
            sender.sendMessage(ChatColor.GOLD + "Power per Level: +" + ChatColor.GRAY + mm.getPerLevelPower());
            sender.sendMessage(ChatColor.GOLD + "Located in File: " + ChatColor.GRAY + mm.getFileName());
        } else {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "No Mythic Mob loaded with the name " + args[2] + ".");
        }
    }

    public static void cmdMobsListActive(CommandSender sender, String[] args) {
        if (args.length > 2) {
            MythicMob mm = MythicMobs.inst().getMobManager().getMythicMob(args[2]);
            if (mm != null) {
                int radius = 0;
                if (args.length > 3) {
                    radius = Integer.parseInt(args[3]);
                }
                ArrayList<ActiveMob> aml = new ArrayList<ActiveMob>();
                if (radius > 0) {
                    for (ActiveMob am : MythicMobs.inst().getMobManager().getActiveMobs()) {
                        if (!am.getType().getInternalName().equals(mm.getInternalName())) continue;
                        aml.add(am);
                    }
                }
                sender.sendMessage(ChatColor.GOLD + "ActiveMobs of type " + ChatColor.BOLD + ChatColor.GRAY + mm.getInternalName() + " (" + aml.size() + " total):");
                for (ActiveMob am : aml) {
                    sender.sendMessage(ChatColor.GOLD + "* " + ChatColor.AQUA + "(" + am.getLocation().getBlockX() + "," + am.getLocation().getBlockY() + "," + am.getLocation().getBlockZ() + ChatColor.WHITE + " - " + ChatColor.GRAY + am.getUniqueId());
                }
            } else {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "No Mythic Mob loaded with the name " + args[2] + ".");
            }
        } else {
            HashMap<MythicMob, Integer> mobs = new HashMap<MythicMob, Integer>();
            for (ActiveMob am : MythicMobs.inst().getMobManager().getActiveMobs()) {
                if (mobs.containsKey(am.getType())) {
                    mobs.put(am.getType(), (Integer)mobs.get(am.getType()) + 1);
                    continue;
                }
                mobs.put(am.getType(), 1);
            }
            int i = 0;
            for (Map.Entry entry : MobCommands.sortByValue(mobs).entrySet()) {
                sender.sendMessage("" + ((MythicMob)entry.getKey()).getDisplayName() + " - " + entry.getValue());
                if (++i < 50) continue;
                break;
            }
        }
    }

    public static void cmdMobStats(CommandSender sender, String[] args) {
        int amount = 0;
        int alive = 0;
        int dead = 0;
        int valid = 0;
        int invalid = 0;
        int n = 0;
        AbstractPlayer player = BukkitAdapter.adapt((Player)sender);
        for (ActiveMob am : MythicMobs.inst().getMobManager().getActiveMobs()) {
            if (!am.getLocation().getWorld().equals(player.getWorld())) continue;
            ++amount;
            if (am.getEntity() == null) {
                ++n;
                continue;
            }
            if (am.getEntity().isDead()) {
                ++dead;
            } else {
                ++alive;
            }
            if (am.getEntity().isValid()) {
                ++valid;
                continue;
            }
            ++invalid;
        }
        sender.sendMessage(ChatColor.GREEN + "Total ActiveMob Instances: " + ChatColor.WHITE + amount);
        sender.sendMessage(ChatColor.GREEN + "Alive: " + ChatColor.WHITE + alive);
        sender.sendMessage(ChatColor.GREEN + "Dead: " + ChatColor.WHITE + dead);
        sender.sendMessage(ChatColor.GREEN + "Valid: " + ChatColor.WHITE + valid);
        sender.sendMessage(ChatColor.GREEN + "Invalid: " + ChatColor.WHITE + invalid);
        sender.sendMessage(ChatColor.GREEN + "Null: " + ChatColor.WHITE + n);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedHashMap result = new LinkedHashMap();
        Stream st = map.entrySet().stream();
        st.sorted(Comparator.comparing(e -> (Comparable)e.getValue())).forEachOrdered(e -> {
            Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
        });
        return result;
    }
}

