/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.compatibility;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.compatibility.BarAPISupport;
import io.lumine.xikage.mythicmobs.compatibility.ChampionsSupport;
import io.lumine.xikage.mythicmobs.compatibility.EffectLibSupport;
import io.lumine.xikage.mythicmobs.compatibility.ElementalsSupport;
import io.lumine.xikage.mythicmobs.compatibility.EnchantsPlusSupport;
import io.lumine.xikage.mythicmobs.compatibility.HeroesSupport;
import io.lumine.xikage.mythicmobs.compatibility.HologramsSupport;
import io.lumine.xikage.mythicmobs.compatibility.LibsDisguisesSupport;
import io.lumine.xikage.mythicmobs.compatibility.MPetCompat;
import io.lumine.xikage.mythicmobs.compatibility.MythicDropsSupport;
import io.lumine.xikage.mythicmobs.compatibility.PhatLootsSupport;
import io.lumine.xikage.mythicmobs.compatibility.RelicsSupport;
import io.lumine.xikage.mythicmobs.compatibility.SkillAPISupport;
import io.lumine.xikage.mythicmobs.compatibility.TerrainControlSupport;
import io.lumine.xikage.mythicmobs.compatibility.VaultSupport;
import io.lumine.xikage.mythicmobs.compatibility.WorldGuardSupport;
import io.lumine.xikage.mythicmobs.compatibility.mcMMOSupport;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CompatibilityManager {
    private Optional<HologramsSupport> holograms = Optional.empty();
    private Optional<MPetCompat> mPet = Optional.empty();
    private Optional<RelicsSupport> relics = Optional.empty();
    private Optional<TerrainControlSupport> terrainControl = Optional.empty();
    private Optional<VaultSupport> vault = Optional.empty();
    private Optional<WorldGuardSupport> worldGuard = Optional.empty();
    public static ChampionsSupport Champions;
    public static BarAPISupport BarAPI;
    public static EffectLibSupport EffectLib;
    public static ElementalsSupport Elementals;
    public static EnchantsPlusSupport EnchantsPlus;
    public static HeroesSupport Heroes;
    public static LibsDisguisesSupport LibsDisguises;
    public static mcMMOSupport mcMMO;
    public static MythicDropsSupport MythicDrops;
    public static PhatLootsSupport PhatLoots;
    public static SkillAPISupport SkillAPI;

    public CompatibilityManager(MythicMobs core) {
        try {
            if (Bukkit.getPluginManager().getPlugin("Champions") != null) {
                Champions = new ChampionsSupport();
                MythicMobs.log("MythicMobs Champions Support has been enabled!");
            } else {
                Champions = null;
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for Champions (is it up to date?)");
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("BarAPI") != null) {
                BarAPI = new BarAPISupport();
                MythicMobs.log("MythicMobs BarAPI Support has been enabled!");
            } else {
                BarAPI = null;
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for BarAPI (is it up to date?)");
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("EffectLib") != null) {
                EffectLib = new EffectLibSupport();
                MythicMobs.log("MythicMobs EffectLib Support has been enabled!");
            } else {
                EffectLib = null;
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for EffectLib (is it up to date?)");
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("Elementals") != null) {
                Elementals = new ElementalsSupport();
                MythicMobs.log("MythicMobs Elementals Support has been enabled!");
            } else {
                Elementals = null;
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for Elementals (is it up to date?)");
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("EnchantsPlus") != null) {
                EnchantsPlus = new EnchantsPlusSupport();
                MythicMobs.log("MythicMobs EnchantsPlus Support has been enabled!");
            } else {
                EnchantsPlus = null;
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for EnchantsPlus (is it up to date?)");
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("Heroes") != null) {
                Heroes = new HeroesSupport();
                MythicMobs.log("MythicMobs Heroes Support has been enabled!");
            } else {
                Heroes = null;
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for Heroes (is it up to date?)");
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("Holograms") != null) {
                this.holograms = Optional.of(new HologramsSupport(core));
                MythicMobs.log("MythicMobs Holograms Support has been enabled!");
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for Holograms (is it up to date?)");
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("LibsDisguises") != null) {
                LibsDisguises = new LibsDisguisesSupport();
                MythicMobs.log("MythicMobs Lib's Disguises Support has been enabled!");
            } else {
                LibsDisguises = null;
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for LibsDisguises (is it up to date?)");
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("mcMMO") != null) {
                mcMMO = new mcMMOSupport();
                MythicMobs.log("MythicMobs mcMMO Support has been enabled!");
            } else {
                MythicDrops = null;
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for mcMMO (is it up to date?)");
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("MiniaturePets") != null) {
                this.mPet = Optional.of(new MPetCompat());
                MythicMobs.log("MiniaturePets Support has been enabled!");
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for MiniaturePets (is it up to date?)");
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("MythicDrops") != null) {
                MythicDrops = new MythicDropsSupport();
                MythicMobs.log("MythicMobs MythicDrops Support has been enabled!");
            } else {
                MythicDrops = null;
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for MythicDrops (is it up to date?)");
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("PhatLoots") != null) {
                PhatLoots = new PhatLootsSupport();
                MythicMobs.log("MythicMobs PhatLoots Support has been enabled!");
            } else {
                PhatLoots = null;
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for PhatLoots (is it up to date?)");
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("Relics") != null) {
                this.relics = Optional.of(new RelicsSupport());
                MythicMobs.log("MythicMobs Relics Support has been enabled!");
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for Relics (is it up to date?)");
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("SkillAPI") != null) {
                SkillAPI = new SkillAPISupport();
                MythicMobs.log("MythicMobs SkillAPI Support has been enabled!");
            } else {
                new BukkitRunnable(){

                    public void run() {
                        if (Bukkit.getPluginManager().getPlugin("SkillAPI") != null) {
                            SkillAPI = new SkillAPISupport();
                            MythicMobs.log("MythicMobs SkillAPI Support has been enabled!");
                        } else {
                            SkillAPI = null;
                        }
                    }
                }.runTaskLater((Plugin)MythicMobs.inst(), 1L);
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for SkillAPI (is it up to date?)");
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("TerrainControl") != null) {
                this.terrainControl = Optional.of(new TerrainControlSupport());
                MythicMobs.log("MythicMobs TerrainControl Support has been enabled!");
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for TerrainControl (is it up to date?)");
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
                this.vault = Optional.of(new VaultSupport());
                MythicMobs.log("MythicMobs Vault Support has been enabled!");
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for Vault (is it up to date?)");
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
                this.worldGuard = Optional.of(new WorldGuardSupport());
                MythicMobs.log("MythicMobs WorldGuard Support has been enabled!");
            }
        }
        catch (NoClassDefFoundError er) {
            MythicMobs.log("Error attempting to enable support for WorldGuard (is it up to date?)");
        }
    }

    public Optional<HologramsSupport> getHolograms() {
        return this.holograms;
    }

    public Optional<MPetCompat> getMiniaturePets() {
        return this.mPet;
    }

    public Optional<TerrainControlSupport> getTerrainControl() {
        return this.terrainControl;
    }

    public Optional<VaultSupport> getVault() {
        return this.vault;
    }

    public Optional<WorldGuardSupport> getWorldGuard() {
        return this.worldGuard;
    }

    public void shutdown() {
        if (this.holograms.isPresent()) {
            this.holograms.get().shutdown();
        }
    }

    public Optional<RelicsSupport> getRelics() {
        return this.relics;
    }
}

