/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.commands.mobs;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.util.commands.Command;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class ListActiveCommand
extends Command<MythicMobs> {
    public ListActiveCommand(Command<MythicMobs> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length > 0) {
            MythicMob mm = MythicMobs.inst().getMobManager().getMythicMob(args[0]);
            if (mm != null) {
                int radius = 0;
                if (args.length > 1) {
                    radius = Integer.parseInt(args[1]);
                }
                ArrayList<ActiveMob> aml = new ArrayList<ActiveMob>();
                if (radius > 0) {
                    for (ActiveMob am : MythicMobs.inst().getMobManager().getActiveMobs()) {
                        if (!am.getType().getInternalName().equals(mm.getInternalName())) continue;
                        aml.add(am);
                    }
                }
                sender.sendMessage(ChatColor.GOLD + "ActiveMobs of type " + ChatColor.BOLD + ChatColor.GRAY + mm.getInternalName() + " (" + aml.size() + " total):");
                for (ActiveMob am : aml) {
                    sender.sendMessage(ChatColor.GOLD + "* " + ChatColor.AQUA + "(" + am.getLocation().getBlockX() + "," + am.getLocation().getBlockY() + "," + am.getLocation().getBlockZ() + ChatColor.WHITE + " - " + ChatColor.GRAY + am.getUniqueId());
                }
            } else {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "No Mythic Mob loaded with the name " + args[0] + ".");
            }
        } else {
            HashMap<MythicMob, Integer> mobs = new HashMap<MythicMob, Integer>();
            for (ActiveMob am : MythicMobs.inst().getMobManager().getActiveMobs()) {
                if (mobs.containsKey(am.getType())) {
                    mobs.put(am.getType(), (Integer)mobs.get(am.getType()) + 1);
                    continue;
                }
                mobs.put(am.getType(), 1);
            }
            int i = 0;
            for (Map.Entry entry : ListActiveCommand.sortByValue(mobs).entrySet()) {
                sender.sendMessage("" + ((MythicMob)entry.getKey()).getDisplayName() + " - " + entry.getValue());
                if (++i < 50) continue;
                break;
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], ((MythicMobs)((Object)this.getPlugin())).getMobManager().getMobNames(), new ArrayList());
        }
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.mobs.listactive";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "listactive";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"la"};
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedHashMap result = new LinkedHashMap();
        Stream st = map.entrySet().stream();
        st.sorted(Comparator.comparing(e -> (Comparable)e.getValue())).forEachOrdered(e -> {
            Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
        });
        return result;
    }
}

