/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.commands.items;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.util.commands.Command;
import io.lumine.xikage.mythicmobs.util.commands.CommandHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.StringUtil;

public class GiveCommand
extends Command<MythicMobs> {
    public GiveCommand(Command<MythicMobs> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            CommandHelper.sendError(sender, "Command Syntax: /mm item give <name> <item>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        String item = args[1];
        int amount = 1;
        if (args.length > 2) {
            amount = Integer.valueOf(args[2]);
        }
        if (target == null) {
            CommandHelper.sendError(sender, "That player is not online");
            return true;
        }
        Optional<MythicItem> maybeItem = MythicMobs.inst().getItemManager().getItem(item);
        if (maybeItem.isPresent()) {
            MythicItem mi = maybeItem.get();
            for (int i = 0; i < amount; ++i) {
                target.getInventory().addItem(new ItemStack[]{BukkitAdapter.adapt(mi.generateItemStack(1, BukkitAdapter.adapt(target), BukkitAdapter.adapt(target)))});
            }
            target.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Item " + ChatColor.AQUA + item + ChatColor.GREEN + " was put in your inventory!");
            sender.sendMessage("");
        } else {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "No Mythic Item loaded with the name " + item + ".");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> players = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                players.add(p.getName());
            }
            return (List)StringUtil.copyPartialMatches((String)args[0], players, new ArrayList());
        }
        if (args.length == 2) {
            return (List)StringUtil.copyPartialMatches((String)args[1], ((MythicMobs)((Object)this.getPlugin())).getItemManager().getItemNames(), new ArrayList());
        }
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.items.give";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "give";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"g", "gi"};
    }
}

