/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.commands.eggs;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.mobs.EggManager;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.util.commands.Command;
import io.lumine.xikage.mythicmobs.util.commands.CommandHelper;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class GiveCommand
extends Command<MythicMobs> {
    public GiveCommand(Command<MythicMobs> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        Player p = (Player)sender;
        if (args.length < 2) {
            CommandHelper.sendError(sender, "Command Syntax: /mm egg give <name> <mob_name> [amount]");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        MythicMob mm = MythicMobs.inst().getMobManager().getMythicMob(args[1]);
        int amount = 1;
        if (args.length > 2) {
            amount = Integer.valueOf(args[2]);
        }
        if (target == null) {
            CommandHelper.sendError(sender, "That player is not online");
            return true;
        }
        if (mm == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "No Mythic Mob loaded with the name " + args[2] + ".");
            return true;
        }
        if (EggManager.giveMythicEgg(mm, target, amount)) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Gave " + ChatColor.AQUA + amount + ChatColor.GREEN + " Mythic Eggs to " + ChatColor.AQUA + args[2] + ChatColor.GREEN + "!");
        } else {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "An error occured, could not give mob egg.");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> players = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                players.add(p.getName());
            }
            return (List)StringUtil.copyPartialMatches((String)args[0], players, new ArrayList());
        }
        if (args.length == 2) {
            return (List)StringUtil.copyPartialMatches((String)args[1], ((MythicMobs)((Object)this.getPlugin())).getMobManager().getMobNames(), new ArrayList());
        }
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.eggs.give";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "give";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"g", "gi"};
    }
}

