/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.commands.eggs;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.mobs.EggManager;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.util.commands.Command;
import io.lumine.xikage.mythicmobs.util.commands.CommandHelper;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class GetCommand
extends Command<MythicMobs> {
    public GetCommand(Command<MythicMobs> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        Player p = (Player)sender;
        if (args.length < 1) {
            CommandHelper.sendError(sender, "Command Syntax: /mm egg get <mob_name> [amount]");
            return true;
        }
        MythicMob mm = MythicMobs.inst().getMobManager().getMythicMob(args[0]);
        int amount = 1;
        if (args.length > 1) {
            amount = Integer.valueOf(args[1]);
        }
        if (mm == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "No Mythic Mob loaded with the name " + args[0] + ".");
            return true;
        }
        if (EggManager.giveMythicEgg(mm, p, amount)) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Got " + ChatColor.AQUA + amount + ChatColor.GREEN + " Mythic Eggs" + ChatColor.GREEN + "!");
        } else {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "An error occured, could not get mob egg.");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[1], ((MythicMobs)((Object)this.getPlugin())).getMobManager().getMobNames(), new ArrayList());
        }
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.eggs.get";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "get";
    }
}

