/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.commands;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.util.commands.Command;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SignalCommand
extends Command<MythicMobs> {
    public SignalCommand(Command<MythicMobs> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        String signal;
        UUID uuid;
        try {
            uuid = UUID.fromString(args[1]);
            signal = args[2];
        }
        catch (Exception ex) {
            sender.sendMessage(ChatColor.RED + "Signal skill must be in format: /mm signal <uuid> <signal>");
            return true;
        }
        if (!MythicMobs.inst().getMobManager().isActiveMob(uuid)) {
            sender.sendMessage(ChatColor.RED + "Failed to send Signal: UUID does not correspond to a Mythic Mob.");
            return true;
        }
        ActiveMob am = MythicMobs.inst().getMobManager().getActiveMob(uuid).get();
        AbstractPlayer trigger = null;
        if (sender instanceof Player) {
            if (!sender.hasPermission("mythicmobs.signal")) {
                sender.sendMessage(ChatColor.RED + "Failed to send Signal: You do not have permission to use that command!");
                return true;
            }
            trigger = BukkitAdapter.adapt((Player)sender);
        }
        am.signalMob(trigger, signal);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.signal";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "signal";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"si"};
    }
}

