/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.api.bukkit;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.api.exceptions.InvalidMobTypeException;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class BukkitAPIHelper {
    public MythicMob getMythicMob(String type) {
        return MythicMobs.inst().getMobManager().getMythicMob(type);
    }

    public Entity spawnMythicMob(MythicMob type, Location location, int level) throws InvalidMobTypeException {
        if (type == null) {
            throw new InvalidMobTypeException("Supplied mob type cannot be null.");
        }
        return type.spawn(BukkitAdapter.adapt(location), level).getEntity().getBukkitEntity();
    }

    public Entity spawnMythicMob(String type, Location location) throws InvalidMobTypeException {
        return this.spawnMythicMob(type, location, 1);
    }

    public Entity spawnMythicMob(String type, Location location, int level) throws InvalidMobTypeException {
        MythicMob mm = MythicMobs.inst().getMobManager().getMythicMob(type);
        if (mm == null) {
            throw new InvalidMobTypeException(type + " is not a valid Mythic Mob type.");
        }
        return mm.spawn(BukkitAdapter.adapt(location), level).getEntity().getBukkitEntity();
    }

    public boolean isMythicMob(Entity l) {
        return MythicMobs.inst().getMobManager().isActiveMob(BukkitAdapter.adapt(l));
    }

    public boolean isMythicMob(UUID u) {
        return MythicMobs.inst().getMobManager().isActiveMob(u);
    }

    public ActiveMob getMythicMobInstance(Entity e) {
        return MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt(e));
    }

    public boolean castSkill(Entity e, String skillName) {
        return this.castSkill(e, skillName, e.getLocation(), 1.0f);
    }

    public boolean castSkill(Entity e, String skillName, float power) {
        return this.castSkill(e, skillName, e.getLocation(), power);
    }

    public boolean castSkill(Entity e, String skillName, Location origin) {
        return this.castSkill(e, skillName, origin, 1.0f);
    }

    public boolean castSkill(Entity e, String skillName, Location origin, float power) {
        return this.castSkill(e, skillName, null, origin, null, null, power);
    }

    public boolean castSkill(Entity e, String skillName, Location origin, Collection<Entity> eTargets, Collection<Location> lTargets, float power) {
        return this.castSkill(e, skillName, null, origin, eTargets, lTargets, power);
    }

    public boolean castSkill(Entity e, String skillName, Entity trigger, Location origin, Collection<Entity> eTargets, Collection<Location> lTargets, float power) {
        SkillMetadata data;
        if (!MythicMobs.inst().getMobManager().isActiveMob(e.getUniqueId())) {
            return false;
        }
        Optional<Skill> maybeSkill = MythicMobs.inst().getSkillManager().getSkill(skillName);
        if (!maybeSkill.isPresent()) {
            return false;
        }
        ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(e);
        Skill skill = maybeSkill.get();
        HashSet<AbstractEntity> feTargets = new HashSet<AbstractEntity>();
        HashSet<AbstractLocation> flTargets = new HashSet<AbstractLocation>();
        if (eTargets != null) {
            for (Entity en : eTargets) {
                feTargets.add(BukkitAdapter.adapt(en));
            }
        }
        if (lTargets != null) {
            for (Location l : lTargets) {
                flTargets.add(BukkitAdapter.adapt(l));
            }
        }
        if (skill.usable(data = new SkillMetadata(SkillTrigger.API, am, BukkitAdapter.adapt(trigger), BukkitAdapter.adapt(origin), feTargets, flTargets, power), SkillTrigger.API)) {
            skill.execute(data);
        }
        return true;
    }

    public boolean addThreat(Entity mob, LivingEntity target, double amount) {
        if (!MythicMobs.inst().getMobManager().isActiveMob(mob.getUniqueId())) {
            return false;
        }
        ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(mob);
        if (am.getThreatTable() == null) {
            return false;
        }
        am.getThreatTable().threatGain(BukkitAdapter.adapt((Entity)target), amount);
        return true;
    }

    public boolean reduceThreat(Entity mob, LivingEntity target, double amount) {
        if (!MythicMobs.inst().getMobManager().isActiveMob(mob.getUniqueId())) {
            return false;
        }
        ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(mob);
        if (am.getThreatTable() == null) {
            return false;
        }
        am.getThreatTable().threatLoss(BukkitAdapter.adapt((Entity)target), amount);
        return true;
    }

    public boolean taunt(Entity mob, LivingEntity target) {
        if (!MythicMobs.inst().getMobManager().isActiveMob(mob.getUniqueId())) {
            return false;
        }
        ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(mob);
        if (am.getThreatTable() == null) {
            return false;
        }
        am.getThreatTable().Taunt(BukkitAdapter.adapt((Entity)target));
        return true;
    }
}

