/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.events;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.TaskManager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.VanillaManager;
import io.lumine.xikage.mythicmobs.mobs.WorldScaling;
import io.lumine.xikage.mythicmobs.mobs.entities.MythicEntityType;
import io.lumine.xikage.mythicmobs.spawning.random.RandomSpawnPoint;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.plugin.Plugin;

public class MobSpawnListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void MobSpawnEvent(CreatureSpawnEvent e) {
        if (e.getEntity() == null) {
            return;
        }
        if (ConfigManager.debugMode) {
            return;
        }
        if (ConfigManager.debugSpawners) {
            return;
        }
        if (MythicMobs.inst().getCompatibility().getWorldGuard().isPresent() && !MythicMobs.inst().getCompatibility().getWorldGuard().get().LocationAllowsMobSpawning(e.getLocation())) {
            return;
        }
        RandomSpawnPoint rsp = new RandomSpawnPoint(BukkitAdapter.adapt((Entity)e.getEntity()), BukkitAdapter.adapt(e.getLocation()), e.getSpawnReason());
        final AbstractEntity spawn = BukkitAdapter.adapt((Entity)e.getEntity());
        Entity ee = BukkitAdapter.adapt(MythicMobs.inst().getRandomSpawningManager().handleSpawnEvent(rsp));
        if (ee != null) {
            e.setCancelled(true);
        } else if (e.getSpawnReason() != CreatureSpawnEvent.SpawnReason.CUSTOM) {
            MythicEntityType met = VanillaManager.getMythicEntityType((Entity)e.getEntity());
            Optional<MythicMob> maybeType = MythicMobs.inst().getMobManager().getVanillaType(met);
            if (maybeType.isPresent()) {
                MythicMob mm = maybeType.get();
                int level = 1 + WorldScaling.getLevelBonus(spawn.getLocation());
                ActiveMob am = MythicMobs.inst().getMobManager().registerActiveMob(spawn, mm, level);
                mm.getMythicEntity().applyOptions((Entity)e.getEntity());
                mm.applyMobOptions(am, level);
                mm.applyMobVolatileOptions(am);
                mm.applySpawnModifiers(am);
            }
        }
        if (e.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM) {
            LivingEntity l;
            if (ConfigManager.UseCompatibilityMode) {
                l = e.getEntity();
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.inst(), new Runnable(){

                    @Override
                    public void run() {
                        if (!MythicMobs.inst().getMobManager().isActiveMob(spawn.getUniqueId())) {
                            MythicMobs.debug(3, "Compatibility mode enabled and found custom mob spawn! Checking for MythicMob '" + l.getCustomName() + "'...");
                            MythicMob mm = MythicMobs.inst().getMobManager().getMythicMobByDisplayCompat(spawn);
                            if (mm != null) {
                                MythicMobs.inst().getMobManager().SetupMythicMobCompat(l, mm);
                            } else {
                                MythicMobs.inst().getMobManager().getVoidList().add(l.getUniqueId());
                            }
                        }
                    }
                }, 10L);
            } else {
                l = e.getEntity();
                TaskManager.get().runLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!MythicMobs.inst().getMobManager().isActiveMob(l.getUniqueId())) {
                            MythicMobs.inst().getMobManager().getVoidList().add(l.getUniqueId());
                        }
                    }
                }, 1);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onMobTame(EntityTameEvent event) {
        LivingEntity e = event.getEntity();
        if (MythicMobs.inst().getMobManager().isActiveMob(e.getUniqueId())) {
            final ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)e);
            TaskManager.get().runLater(new Runnable(){

                @Override
                public void run() {
                    am.getType().applyMobOptions(am, am.getLevel());
                    am.getType().applyMobVolatileOptions(am);
                }
            }, 5);
        }
    }
}

