/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.events;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.mobs.EggManager;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MobEggListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void EggEvent(PlayerInteractEvent e) {
        if (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            ItemStack i = e.getItem();
            if (i == null) {
                return;
            }
            if (i.getType() != Material.MONSTER_EGG) {
                return;
            }
            if (!i.getItemMeta().hasLore()) {
                return;
            }
            MythicMobs.debug(3, "Detected Monster Egg usage, parsing Mythic Egg...");
            List list = e.getItem().getItemMeta().getLore();
            if (((String)list.get(0)).equals(ChatColor.DARK_GRAY + "" + ChatColor.ITALIC + "A Mythical Egg that can")) {
                MythicMobs.debug(2, "Mythic Egg used. Attempting to spawn mob...");
                final MythicMob mm = EggManager.getMythicMobFromEgg((String)list.get(2));
                if (mm == null) {
                    MythicMobs.debug(2, "-- The egg's mob was invalid?");
                    return;
                }
                ItemStack eggItem = e.getItem().clone();
                if (i.getAmount() == 1) {
                    i = new ItemStack(Material.AIR, 1);
                    e.getPlayer().setItemInHand(i);
                } else {
                    i.setAmount(i.getAmount() - 1);
                }
                if (e.getAction() == Action.RIGHT_CLICK_BLOCK) {
                    MythicMobs.debug(2, "-- Block was right-clicked. Spawning mob at block.");
                    Location location = e.getClickedBlock().getLocation().clone();
                    location.setY(location.getY() + 1.0);
                    MythicMobs.inst().getMobManager().spawnMob(mm.getInternalName(), location);
                    MythicMobs.debug(1, "Mythic Mob " + mm.getInternalName() + " was spawned from an egg.");
                } else {
                    MythicMobs.debug(2, "-- Block was thrown. Spawning mob at egg in 3 seconds...");
                    Player player = e.getPlayer();
                    final Item egg = e.getPlayer().getWorld().dropItem(new Location(player.getWorld(), player.getLocation().getX(), player.getLocation().getY() + 1.4, player.getLocation().getZ()), eggItem);
                    Vector dir = player.getLocation().getDirection();
                    Vector vec = new Vector(dir.getX(), dir.getY(), dir.getZ()).multiply(1);
                    egg.setPickupDelay(Short.MAX_VALUE);
                    egg.setTicksLived(5800);
                    egg.setVelocity(vec);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.inst(), new Runnable(){

                        @Override
                        public void run() {
                            MythicMobs.inst().getMobManager().spawnMob(mm.getInternalName(), egg.getLocation());
                            egg.remove();
                            MythicMobs.debug(1, "Mythic Mob " + mm.getInternalName() + " was spawned from an egg.");
                        }
                    }, 50L);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void DispenseEggEvent(BlockDispenseEvent e) {
        if (e.getBlock().getType() == Material.DROPPER) {
            return;
        }
        ItemStack i = e.getItem();
        if (i == null) {
            return;
        }
        if (i.getType() != Material.MONSTER_EGG) {
            return;
        }
        if (!i.getItemMeta().hasLore()) {
            return;
        }
        MythicMobs.debug(3, "Detected Monster Egg being dispensed, parsing Mythic Egg...");
        List list = e.getItem().getItemMeta().getLore();
        if (((String)list.get(0)).equals(ChatColor.DARK_GRAY + "" + ChatColor.ITALIC + "A Mythical Egg that can")) {
            MythicMobs.debug(2, "Mythic Egg dispensed. Attempting to spawn mob...");
            MythicMob mm = EggManager.getMythicMobFromEgg((String)list.get(2));
            if (mm == null) {
                MythicMobs.debug(2, "-- The egg's mob was invalid?");
                return;
            }
            Location location = e.getBlock().getLocation().clone();
            if (e.getBlock().getData() == 8) {
                location.setY(location.getY() - 1.0);
            } else if (e.getBlock().getData() == 9) {
                location.setY(location.getY() + 1.0);
            } else if (e.getBlock().getData() == 10) {
                location.setZ(location.getZ() - 1.0);
            } else if (e.getBlock().getData() == 11) {
                location.setZ(location.getZ() + 1.0);
            } else if (e.getBlock().getData() == 12) {
                location.setX(location.getX() - 1.0);
            } else if (e.getBlock().getData() == 13) {
                location.setX(location.getX() + 1.0);
            } else {
                location.setY(location.getY() + 1.0);
            }
            MythicMobs.inst().getMobManager().spawnMob(mm.getInternalName(), location);
            MythicMobs.debug(1, "Mythic Mob " + mm.getInternalName() + " was spawned from a dispensed egg.");
        }
    }
}

