/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit;

import io.lumine.xikage.mythicmobs.adapters.AbstractBossBar;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.ServerInterface;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitBossBar;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitWorld;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitServer
implements ServerInterface {
    @Override
    public List<AbstractWorld> getWorlds() {
        ArrayList<AbstractWorld> wl = new ArrayList<AbstractWorld>();
        for (World w : Bukkit.getWorlds()) {
            wl.add(new BukkitWorld(w));
        }
        return wl;
    }

    @Override
    public void dispatchCommand(String s) {
        Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), s);
    }

    @Override
    public List<AbstractPlayer> getOnlinePlayers() {
        ArrayList<AbstractPlayer> pl = new ArrayList<AbstractPlayer>();
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            pl.add(BukkitAdapter.adapt(p));
        }
        return pl;
    }

    @Override
    public AbstractLocation newLocation(AbstractWorld w, double x, double y, double z) {
        Location l = new Location(BukkitAdapter.adapt(w), x, y, z);
        return BukkitAdapter.adapt(l);
    }

    @Override
    public AbstractWorld getWorld(String world) {
        World w = Bukkit.getWorld((String)world);
        if (w == null) {
            return null;
        }
        return new BukkitWorld(w);
    }

    @Override
    public boolean isValidBiome(Object o) {
        return false;
    }

    @Override
    public AbstractBossBar createBossBar(String title, AbstractBossBar.BarColor color, AbstractBossBar.BarStyle style) {
        return new BukkitBossBar(title, color, style);
    }
}

