/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Spawners;

import java.io.File;
import java.util.ArrayList;
import java.util.UUID;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.AbstractPlayer;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Save.SaveSpawners;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.SConditions.SCondition;
import net.elseland.xikage.MythicMobs.Spawners.MythicSpawner;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;

public class SpawnerManager {
    public static void tickSpawnerAsyncClocks() {
    }

    public void tickSpawnerClocks() {
        MythicMobs.plugin.listSpawners.stream().forEach(spawner -> {
            MythicMobs.plugin.getTimingsHandler().markSpawnerNew(spawner.name);
            spawner.tickSpawnerClock();
            MythicMobs.plugin.getTimingsHandler().markSpawnerComplete(spawner.name);
        });
    }

    public static void resetAndSaveAll() {
        for (MythicSpawner ms : MythicMobs.plugin.listSpawners) {
            ms.unloadSpawner();
        }
        SaveSpawners.SaveAll();
    }

    public static ArrayList<MythicSpawner> getSpawnersByString(String string) {
        return SpawnerManager.getSpawnersByString(null, string);
    }

    public static ArrayList<MythicSpawner> getSpawnersByString(AbstractLocation abstractLocation, String string) {
        if (string == null) {
            return null;
        }
        ArrayList<MythicSpawner> msl = new ArrayList();
        if (string.startsWith("g:")) {
            String group = string.substring(2);
            msl = SpawnerManager.getSpawnersByGroup(group);
        } else if (string.startsWith("r:")) {
            if (abstractLocation == null) {
                return null;
            }
            String sradius = string.substring(2);
            double radius = 0.0;
            try {
                radius = Double.parseDouble(sradius);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (MythicSpawner ms : MythicMobs.plugin.listSpawners) {
                if (ms.location.getWorld() == null || !ms.location.getWorld().equals(abstractLocation.getWorld()) || !(ms.distanceTo(abstractLocation) <= radius)) continue;
                msl.add(ms);
            }
        } else if (string.equals("*")) {
            for (MythicSpawner ms : MythicMobs.plugin.listSpawners) {
                msl.add(ms);
            }
        } else if (string.contains("*") || string.contains("?")) {
            for (MythicSpawner ms : MythicMobs.plugin.listSpawners) {
                if (!ms.name.matches(string.replace("?", ".?").replace("*", ".*?"))) continue;
                msl.add(ms);
            }
        } else {
            MythicSpawner ms = SpawnerManager.getSpawnerByName(string);
            if (ms != null) {
                msl.add(ms);
            }
        }
        return msl;
    }

    public static MythicSpawner getSpawnerByName(String name) {
        for (MythicSpawner s : MythicMobs.plugin.listSpawners) {
            if (!s.name.equals(name)) continue;
            return s;
        }
        return null;
    }

    public static ArrayList<MythicSpawner> getSpawnersByGroup(String group) {
        ArrayList<MythicSpawner> msl = new ArrayList<MythicSpawner>();
        for (MythicSpawner s : MythicMobs.plugin.listSpawners) {
            try {
                if (!s.group.equals(group)) continue;
                msl.add(s);
            }
            catch (Exception e) {}
        }
        return msl;
    }

    public static MythicSpawner getSpawnerAtLocation(Location location) {
        for (MythicSpawner s : MythicMobs.plugin.listSpawners) {
            if (!s.location.equals(location)) continue;
            return s;
        }
        return null;
    }

    public static MythicSpawner createSpawner(String name, Location location, String mobName) {
        MythicMobs.debug(2, "Creating New Spawner at " + location.getX() + "," + location.getY() + "," + location.getZ());
        if (SpawnerManager.getSpawnerByName(name) != null) {
            MythicMobs.debug(3, "-- Spawner creation failed due to bad name.");
            return null;
        }
        if (MythicMobs.inst().getMobManager().getMythicMob(mobName) == null) {
            MythicMobs.debug(3, "-- Spawner creation failed due to bad mob name.");
            return null;
        }
        MythicSpawner newspawner = new MythicSpawner(name, BukkitAdapter.adapt(location), mobName);
        MythicMobs.plugin.listSpawners.add(newspawner);
        SaveSpawners.SaveSpawner(newspawner);
        MythicMobs.debug(2, "New spawner created successfully!");
        return newspawner;
    }

    public static boolean copySpawner(String name, String nameNew, AbstractLocation location) {
        MythicSpawner msNew;
        MythicMobs.debug(2, "Creating Copy of Spawner at " + location.getX() + "," + location.getY() + "," + location.getZ());
        MythicSpawner ms = SpawnerManager.getSpawnerByName(name);
        try {
            msNew = ms.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return false;
        }
        msNew.name = nameNew;
        msNew.location = location;
        msNew.world = location.getWorld().getName();
        msNew.setBlockX(location.getBlockX());
        msNew.setBlockY(location.getBlockY());
        msNew.setBlockZ(location.getBlockZ());
        msNew.mobs = new ArrayList<UUID>();
        msNew.mobs.clear();
        msNew.setBreakable(false);
        msNew.setBreakable(ms.isBreakable());
        MythicSpawner.addSpawnerToChunkLookupTable(msNew);
        MythicMobs.plugin.listSpawners.add(msNew);
        SaveSpawners.SaveSpawner(msNew);
        MythicMobs.debug(2, "New spawner cloned successfully!");
        return true;
    }

    public static boolean moveSpawner(String name, AbstractLocation location) {
        MythicMobs.debug(2, "Moving spawner to " + location.getX() + "," + location.getY() + "," + location.getZ());
        MythicSpawner ms = SpawnerManager.getSpawnerByName(name);
        if (ms == null) {
            return false;
        }
        return SpawnerManager.moveSpawner(ms, location);
    }

    public static boolean moveSpawner(MythicSpawner ms, AbstractLocation location) {
        MythicMobs.debug(2, "Moving spawner to " + location.getX() + "," + location.getY() + "," + location.getZ());
        MythicSpawner.removeSpawnerFromChunkLookupTable(ms);
        ms.location = location;
        ms.world = location.getWorld().getName();
        ms.setBlockX(location.getBlockX());
        ms.setBlockY(location.getBlockY());
        ms.setBlockZ(location.getBlockZ());
        MythicSpawner.addSpawnerToChunkLookupTable(ms);
        SaveSpawners.SaveSpawner(ms);
        MythicMobs.debug(2, "Spawner moved successfully!");
        return true;
    }

    public static synchronized boolean mobIsValid(Location location, UUID u) {
        if (location.getWorld() == null) {
            return true;
        }
        for (LivingEntity l : location.getWorld().getLivingEntities()) {
            if (!l.getUniqueId().equals(u)) continue;
            return true;
        }
        return false;
    }

    public static boolean playerWithinSpawnerRange(int range, AbstractLocation location) {
        int rangeSquared = (int)Math.pow(range, 2.0);
        for (AbstractPlayer player : MythicMobs.inst().getEntityManager().getPlayers(location.getWorld())) {
            if (!location.getWorld().equals(player.getWorld()) || !(location.distanceSquared(player.getLocation()) <= (double)rangeSquared)) continue;
            return true;
        }
        return false;
    }

    public static void RemoveMobFromSpawners(ActiveMob am) {
        if (am.getSpawner() != null) {
            am.getSpawner().removeMob(am);
        }
    }

    public static boolean setSpawnerAttribute(MythicSpawner ms, String attr, String value) {
        try {
            switch (attr.toLowerCase()) {
                case "group": {
                    ms.group = value;
                    break;
                }
                case "radius": 
                case "r": {
                    ms.spawnRadius = Integer.parseInt(value);
                    break;
                }
                case "radiusy": 
                case "ry": {
                    ms.spawnRadiusY = Integer.parseInt(value);
                    break;
                }
                case "cooldown": 
                case "cd": {
                    ms.setCooldownSeconds(Integer.parseInt(value));
                    break;
                }
                case "warmup": 
                case "wu": {
                    ms.setWarmupSeconds(Integer.parseInt(value));
                    break;
                }
                case "maxmobs": {
                    ms.maxMobs = Integer.parseInt(value);
                    break;
                }
                case "moblevel": 
                case "level": 
                case "moblvl": {
                    ms.mobLevel = Integer.parseInt(value);
                    break;
                }
                case "mobsperspawn": 
                case "mps": {
                    ms.mobsPerSpawn = Integer.parseInt(value);
                    break;
                }
                case "usetimer": 
                case "timer": {
                    ms.useTimer = Boolean.parseBoolean(value);
                    break;
                }
                case "showflames": 
                case "flames": {
                    ms.showFlames = Boolean.parseBoolean(value);
                    break;
                }
                case "activation": 
                case "activationrange": 
                case "ar": {
                    ms.setActivationRange(Integer.parseInt(value));
                    break;
                }
                case "leash": 
                case "leashrange": {
                    ms.leashRange = Integer.parseInt(value);
                    break;
                }
                case "healonleash": 
                case "leashheal": {
                    ms.leashHeal = Boolean.parseBoolean(value);
                    break;
                }
                case "resetthreatonleash": 
                case "leashresetthreat": {
                    ms.setLeashResetsThreat(Boolean.parseBoolean(value));
                    break;
                }
                case "mobtype": {
                    if (MythicMobs.inst().getMobManager().getMythicMob(value) != null) {
                        ms.mobName = value;
                    }
                    break;
                }
                case "breakable": {
                    ms.setBreakable(Boolean.parseBoolean(value));
                    break;
                }
                case "checkforplayers": {
                    ms.setCheckForPlayers(Boolean.parseBoolean(value));
                    break;
                }
                default: {
                    MythicMobs.debug(1, "The attribute " + attr + " does not exist!");
                    return false;
                }
            }
        }
        catch (Exception e) {
            MythicMobs.debug(1, "The value " + value + " is invalid for attribute " + attr);
            return false;
        }
        SaveSpawners.SaveSpawner(ms);
        return true;
    }

    public static boolean addSpawnerCondition(MythicSpawner ms, String condition, String value) {
        if (SCondition.getSpawningConditionByName(condition) == null) {
            MythicMobs.debug(1, "The condition " + condition + " does not exist!");
            return false;
        }
        ms.conditions.add(condition + " " + value);
        SaveSpawners.SaveSpawner(ms);
        return true;
    }

    public static boolean removeSpawnerCondition(MythicSpawner ms, String condition) {
        for (String s : ms.conditions) {
            if (!s.contains(condition)) continue;
            ms.conditions.remove(s);
            SaveSpawners.SaveSpawner(ms);
            return true;
        }
        return false;
    }

    public static boolean removeSpawner(MythicSpawner ms) {
        if (ms.isBreakable()) {
            MythicMobs.plugin.mmBreakableSpawners.remove(ms.getLocation());
        }
        MythicMobs.plugin.listSpawners.remove(ms);
        File spawnerFile = new File(MythicMobs.plugin.getDataFolder() + System.getProperty("file.separator") + "Spawners", ms.name + ".yml");
        spawnerFile.delete();
        return true;
    }

    public Location findSpawningLocation(Location location, int radius) {
        for (int tries = 0; tries < 64; ++tries) {
            Location spawnLoc = SpawnerManager.randomizeSpawnLocation(location, radius);
            if (!this.areaIsEmpty(spawnLoc)) continue;
            return spawnLoc;
        }
        return null;
    }

    public static Location randomizeSpawnLocation(Location location, int r) {
        double z;
        double y;
        double x;
        double sX = location.getX();
        double sY = location.getY();
        double sZ = location.getZ();
        do {
            x = SpawnerManager.randomRange(sX - (double)r, sX + (double)r);
            y = SpawnerManager.randomRange(sY - (double)r, sY + (double)r);
            z = SpawnerManager.randomRange(sZ - (double)r, sZ + (double)r);
        } while (location.distance(new Location(location.getWorld(), x, y, z)) > (double)r);
        return new Location(location.getWorld(), x, y, z);
    }

    public static double randomRange(double arg0, double arg1) {
        double range;
        double d = range = arg0 < arg1 ? arg1 - arg0 : arg0 - arg1;
        if (range < 1.0) {
            return Math.floor(arg0) + 0.5;
        }
        double min = arg0 < arg1 ? arg0 : arg1;
        return Math.floor(min + Math.random() * range) + 0.5;
    }

    public boolean areaIsEmpty(Location loc) {
        return true;
    }
}

