/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.IO.Load.MythicConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.AbstractSkill;
import net.elseland.xikage.MythicMobs.Skills.Conditions.MythicCondition;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.DelaySkill;
import net.elseland.xikage.MythicMobs.Skills.SkillCaster;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Skills.SkillString;
import net.elseland.xikage.MythicMobs.Skills.SkillTrigger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class Skill
extends AbstractSkill {
    protected LinkedList<SkillMechanic> skills = new LinkedList();
    protected List<MythicCondition> conditionsTarget = new ArrayList<MythicCondition>();
    protected List<MythicCondition> conditionsTrigger = new ArrayList<MythicCondition>();

    public Skill(String name, MythicConfig mc) {
        this.cooldown = (float)mc.getDouble("Cooldown", 0.0);
        this.conditionsSelf = mc.getStringList("Conditions");
        List<String> nSkills = mc.getStringList("Skills");
        for (String s : nSkills) {
            SkillMechanic ms;
            if (s.contains("\"")) {
                String[] split = s.split("\"");
                int i = 0;
                String ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s = ns;
                s = SkillString.convertLegacyVariables(s);
            }
            if ((ms = MythicMobs.inst().getSkillManager().getSkillMechanic(s)) == null) continue;
            this.skills.add(ms);
        }
    }

    public boolean usable(SkillMetadata meta, SkillTrigger trigger) {
        SkillCaster skillCaster = meta.getCaster();
        if (this.onCooldown(skillCaster) || !this.rollChance() || !this.checkHealth(skillCaster) || !this.checkMobConditions(skillCaster)) {
            return false;
        }
        for (MythicCondition mc : this.conditionsTrigger) {
            if (mc.evaluateTrigger(meta)) continue;
            return false;
        }
        for (MythicCondition mc : this.conditionsTarget) {
            mc.evaluateTargets(meta);
        }
        return true;
    }

    public void execute(SkillTrigger basetrigger, SkillCaster caster, AbstractEntity trigger, AbstractLocation origin, HashSet<AbstractEntity> eTargets, HashSet<AbstractLocation> lTargets, float power) {
        SkillMetadata data = new SkillMetadata(basetrigger, caster, trigger, origin, eTargets, lTargets, power);
        this.execute(data);
    }

    public void execute(SkillMetadata data) {
        LinkedList skillqueue = (LinkedList)this.skills.clone();
        Skill.execute(data, skillqueue);
        this.setCooldown(data.getCaster(), this.cooldown);
    }

    public static void execute(SkillMetadata data, Queue<SkillMechanic> skillqueue) {
        while (skillqueue.size() > 0) {
            SkillMechanic mbs = skillqueue.poll();
            if (mbs instanceof DelaySkill) {
                AbstractSkill.DelayedSkill ds = new AbstractSkill.DelayedSkill(data, skillqueue);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.plugin, (Runnable)ds, (long)((DelaySkill)mbs).getTicks());
                break;
            }
            if (!mbs.usable(data.getCaster(), null)) continue;
            mbs.execute(data.deepClone());
        }
    }

    public boolean isUsable(SkillMetadata data) {
        return this.usable(data, null);
    }
}

