/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class VelocitySkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected float velocityX;
    protected float velocityY;
    protected float velocityZ;
    protected VelocityMode mode;

    public VelocitySkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.velocityX = mlc.getFloat(new String[]{"velocityx", "vx", "x"}, 1.0f);
        this.velocityY = mlc.getFloat(new String[]{"velocityy", "vy", "y"}, 1.0f);
        this.velocityZ = mlc.getFloat(new String[]{"velocityz", "vz", "z"}, 1.0f);
        String strMode = mlc.getString(new String[]{"mode", "m"}, "SET", new String[0]);
        switch (strMode.toUpperCase()) {
            case "ADD": {
                this.mode = VelocityMode.ADD;
                break;
            }
            case "MULTIPLY": {
                this.mode = VelocityMode.MULTIPLY;
                break;
            }
            default: {
                this.mode = VelocityMode.SET;
            }
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        Entity e = target.getBukkitEntity();
        if (this.mode.equals((Object)VelocityMode.SET)) {
            e.setVelocity(new Vector(this.velocityX, this.velocityY, this.velocityZ));
        } else if (this.mode.equals((Object)VelocityMode.ADD)) {
            Vector v = e.getVelocity();
            v.setX(v.getX() + (double)this.velocityX);
            v.setY(v.getY() + (double)this.velocityY);
            v.setZ(v.getZ() + (double)this.velocityZ);
            e.setVelocity(v);
        } else if (this.mode.equals((Object)VelocityMode.MULTIPLY)) {
            Vector v = e.getVelocity();
            v.setX(v.getX() * (double)this.velocityX);
            v.setY(v.getY() * (double)this.velocityY);
            v.setZ(v.getZ() * (double)this.velocityZ);
            e.setVelocity(v);
        }
        return true;
    }

    static enum VelocityMode {
        SET,
        ADD,
        MULTIPLY;

    }
}

