/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.TaskManager;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.Skill;
import net.elseland.xikage.MythicMobs.Skills.SkillCaster;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Util.HitBox;

public class TotemSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected Optional<Skill> onTickSkill = Optional.empty();
    protected Optional<Skill> onHitSkill = Optional.empty();
    protected Optional<Skill> onEndSkill = Optional.empty();
    protected Optional<Skill> onStartSkill = Optional.empty();
    protected String onTickSkillName;
    protected String onHitSkillName;
    protected String onEndSkillName;
    protected String onStartSkillName;
    protected int tickInterval;
    protected float ticksPerSecond;
    protected int maxCharges;
    protected float hitRadius;
    protected float verticalHitRadius;
    protected float duration;
    protected float YOffset;
    protected boolean hitTarget = true;
    protected boolean hitPlayers = false;
    protected boolean hitNonPlayers = false;
    protected boolean hitTargetOnly = false;

    public TotemSkill(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.onTickSkillName = mlc.getString(new String[]{"ontickskill", "ontick", "ot", "skill", "s", "meta", "m"});
        this.onHitSkillName = mlc.getString(new String[]{"onhitskill", "onhit", "oh"});
        this.onEndSkillName = mlc.getString(new String[]{"onendskill", "onend", "oe"});
        this.onStartSkillName = mlc.getString(new String[]{"onstartskill", "onstart", "os"});
        this.tickInterval = mlc.getInteger(new String[]{"interval", "int", "i"}, 4);
        this.ticksPerSecond = 20.0f / (float)this.tickInterval;
        this.maxCharges = mlc.getInteger(new String[]{"charges", "ch", "c"}, 0);
        this.hitRadius = mlc.getFloat("horizontalradius", 1.25f);
        this.hitRadius = mlc.getFloat("hradius", this.hitRadius);
        this.hitRadius = mlc.getFloat("hr", this.hitRadius);
        this.hitRadius = mlc.getFloat("r", this.hitRadius);
        this.duration = mlc.getFloat("maxduration", 10.0f);
        this.duration = mlc.getFloat("md", this.duration);
        this.duration *= 1000.0f;
        this.verticalHitRadius = mlc.getFloat("verticalradius", this.hitRadius);
        this.verticalHitRadius = mlc.getFloat("vradius", this.verticalHitRadius);
        this.verticalHitRadius = mlc.getFloat("vr", this.verticalHitRadius);
        this.YOffset = mlc.getFloat("yoffset", 1.0f);
        this.YOffset = mlc.getFloat("yo", this.YOffset);
        this.hitPlayers = mlc.getBoolean("hitplayers", false);
        this.hitPlayers = mlc.getBoolean("hp", this.hitPlayers);
        this.hitNonPlayers = mlc.getBoolean("hitnonplayers", false);
        this.hitNonPlayers = mlc.getBoolean("hnp", this.hitNonPlayers);
        this.hitTarget = mlc.getBoolean("hittarget", true);
        this.hitTarget = mlc.getBoolean("ht", this.hitTarget);
        this.hitTargetOnly = mlc.getBoolean("hittargetonly", false);
        this.hitTargetOnly = mlc.getBoolean("hittargetonly", this.hitTargetOnly);
        MythicMobs.inst().getSkillManager().queueSecondPass(() -> {
            if (this.onTickSkillName != null) {
                this.onTickSkill = MythicMobs.inst().getSkillManager().getSkill(this.onTickSkillName);
            }
            MythicMobs.debug(3, "-- Loaded SkillSkill pointing at " + this.onTickSkillName);
            if (this.onHitSkillName != null) {
                this.onHitSkill = MythicMobs.inst().getSkillManager().getSkill(this.onHitSkillName);
            }
            MythicMobs.debug(3, "-- Loaded SkillSkill pointing at " + this.onHitSkillName);
            if (this.onEndSkillName != null) {
                this.onEndSkill = MythicMobs.inst().getSkillManager().getSkill(this.onEndSkillName);
            }
            MythicMobs.debug(3, "-- Loaded SkillSkill pointing at " + this.onEndSkillName);
            if (this.onStartSkillName != null) {
                this.onStartSkill = MythicMobs.inst().getSkillManager().getSkill(this.onStartSkillName);
            }
            MythicMobs.debug(3, "-- Loaded SkillSkill pointing at " + this.onStartSkillName);
        });
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        try {
            new TotemTracker(data, target);
            return true;
        }
        catch (Exception ex) {
            MythicMobs.plugin.handleException(ex);
            return false;
        }
    }

    private class TotemTracker
    implements Runnable {
        private SkillMetadata data;
        private boolean cancelled = false;
        private SkillCaster am;
        private float power;
        private long startTime;
        private AbstractLocation currentLocation;
        private int charges;
        private int taskId;
        private HashSet<AbstractEntity> targets;
        private List<AbstractEntity> inRange;
        private Map<AbstractEntity, Long> immune;
        private int counter = 0;

        public TotemTracker(SkillMetadata data, AbstractEntity target) {
            this.data = data;
            this.am = data.getCaster();
            this.power = data.getPower();
            this.charges = TotemSkill.this.maxCharges;
            this.startTime = System.currentTimeMillis();
            this.currentLocation = data.getOrigin() != null ? data.getOrigin().clone() : this.am.getEntity().getLocation().clone();
            if (TotemSkill.this.YOffset != 0.0f) {
                this.currentLocation.setY(this.currentLocation.getY() + (double)TotemSkill.this.YOffset);
            }
            MythicMobs.debug(3, "------ Initializing projectile skill");
            this.taskId = TaskManager.get().scheduleTask(this, 0, TotemSkill.this.tickInterval);
            if (TotemSkill.this.hitPlayers || TotemSkill.this.hitNonPlayers || TotemSkill.this.hitTarget) {
                this.inRange = this.currentLocation.getWorld().getLivingEntities();
                Iterator<AbstractEntity> iter = this.inRange.iterator();
                while (iter.hasNext()) {
                    AbstractEntity e = iter.next();
                    MythicMobs.debug(4, "-------- Added entity " + e.getName());
                    if (e.getUniqueId().equals(this.am.getEntity().getUniqueId())) {
                        iter.remove();
                        MythicMobs.debug(4, "-------- Removed entity " + e.getName() + ": is self");
                        continue;
                    }
                    if (!TotemSkill.this.hitPlayers && e.isPlayer() && !e.equals(target)) {
                        iter.remove();
                        MythicMobs.debug(4, "-------- Removed entity " + e.getName() + ": is player");
                        continue;
                    }
                    if (TotemSkill.this.hitNonPlayers || e.isPlayer() && !e.equals(target)) continue;
                    iter.remove();
                    MythicMobs.debug(4, "-------- Removed entity " + e.getName() + ": is non-player");
                }
                if (TotemSkill.this.hitTarget) {
                    this.inRange.add(target);
                }
            }
            this.targets = new HashSet();
            this.immune = new HashMap<AbstractEntity, Long>();
            if (TotemSkill.this.onStartSkill.isPresent() && TotemSkill.this.onStartSkill.get().isUsable(data)) {
                SkillMetadata sData = data.deepClone();
                sData.setLocationTarget(this.currentLocation);
                sData.setOrigin(this.currentLocation.clone());
                TotemSkill.this.onStartSkill.get().execute(sData);
            }
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            if (TotemSkill.this.duration > 0.0f && (float)this.startTime + TotemSkill.this.duration < (float)System.currentTimeMillis()) {
                this.stop();
                return;
            }
            ++this.counter;
            if (this.inRange != null) {
                MythicMobs.debug(4, "-------- Checking if entities in HitBox");
                HitBox hitBox = new HitBox(this.currentLocation, TotemSkill.this.hitRadius, TotemSkill.this.verticalHitRadius);
                for (int i = 0; i < this.inRange.size(); ++i) {
                    AbstractEntity e = this.inRange.get(i);
                    if (!e.isDead() && hitBox.contains(e.getLocation().add(0.0, 0.6, 0.0))) {
                        MythicMobs.debug(4, "---------- Target " + e.getName() + " is in HitBox!");
                        this.targets.add(e);
                        if (TotemSkill.this.maxCharges > 0) {
                            --this.charges;
                            if (this.charges > 0) break;
                            this.doHit(this.targets);
                            this.stop();
                            return;
                        }
                        this.inRange.remove(i);
                        this.immune.put(e, System.currentTimeMillis());
                        break;
                    }
                    MythicMobs.debug(4, "---------- Target " + e.getName() + " is NOT in HitBox!");
                }
                Iterator<Map.Entry<AbstractEntity, Long>> iter = this.immune.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<AbstractEntity, Long> entry = iter.next();
                    if (entry.getValue() >= System.currentTimeMillis() - 2000L) continue;
                    iter.remove();
                    this.inRange.add(entry.getKey());
                }
            }
            if (TotemSkill.this.onTickSkill.isPresent() && TotemSkill.this.onTickSkill.get().isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                AbstractLocation location = this.currentLocation.clone();
                HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
                targets.add(location);
                sData.setLocationTargets(targets);
                sData.setOrigin(location);
                TotemSkill.this.onTickSkill.get().execute(sData);
            }
            if (this.targets.size() > 0) {
                this.doHit((HashSet)this.targets.clone());
            }
            this.targets.clear();
        }

        public void doHit(HashSet<AbstractEntity> targets) {
            if (TotemSkill.this.onHitSkill.isPresent() && TotemSkill.this.onHitSkill.get().isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                sData.setEntityTargets(targets);
                sData.setOrigin(this.currentLocation.clone());
                TotemSkill.this.onHitSkill.get().execute(sData);
            }
        }

        public void stop() {
            if (TotemSkill.this.onEndSkill.isPresent() && TotemSkill.this.onEndSkill.get().isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                TotemSkill.this.onEndSkill.get().execute(sData.setOrigin(this.currentLocation).setLocationTarget(this.currentLocation));
            }
            TaskManager.get().cancelTask(this.taskId);
            this.cancelled = true;
            if (this.inRange != null) {
                this.inRange.clear();
            }
        }
    }
}

