/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.Mobs.Entities.MythicEntity;
import net.elseland.xikage.MythicMobs.Mobs.MobManager;
import net.elseland.xikage.MythicMobs.Mobs.MythicMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;

public class SummonSkill
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected MythicMob mm;
    protected MythicEntity me;
    protected String strType;
    protected int amount;
    protected int noise;
    protected int yNoise;
    protected boolean yUpOnly;
    protected boolean onSurface;
    protected boolean inheritThreatTable;
    protected boolean copyThreatTable;

    public SummonSkill(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.strType = mlc.getString("type", "SKELETON");
        this.strType = mlc.getString("t", this.strType);
        this.strType = mlc.getString("mob", this.strType);
        this.strType = mlc.getString("m", this.strType);
        try {
            this.amount = mlc.getInteger("amount", 1);
            this.amount = mlc.getInteger("a", this.amount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.noise = mlc.getInteger(new String[]{"noise", "n", "radius", "r"}, 0);
        this.yNoise = mlc.getInteger(new String[]{"ynoise", "yn", "yradius", "yr"}, this.noise);
        this.yUpOnly = mlc.getBoolean(new String[]{"yradiusuponly", "yradiusonlyup", "yruo", "yu"}, false);
        this.onSurface = mlc.getBoolean(new String[]{"onsurface", "os", "s"}, true);
        this.copyThreatTable = mlc.getBoolean(new String[]{"copythreattable", "ctt"}, false);
        this.inheritThreatTable = mlc.getBoolean(new String[]{"inheritthreattable", "itt"}, false);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        if (this.mm == null && this.me == null) {
            this.mm = MythicMobs.inst().getMobManager().getMythicMob(this.strType);
            if (this.mm == null) {
                this.me = MythicEntity.getMythicEntity(this.strType);
                if (this.me == null) {
                    MythicMobs.skillConfigError("SUMMON", this.line, "The 'type' attribute must be a valid MythicMob or MythicEntity type.");
                }
            }
        }
        if (this.mm != null) {
            if (this.noise > 0) {
                for (int i = 1; i <= this.amount; ++i) {
                    MythicMobs.inst().getMobManager();
                    AbstractLocation l = MobManager.findSafeSpawnLocation(target, this.noise, this.yNoise, this.mm.getMythicEntity().getHeight(), this.yUpOnly);
                    ActiveMob ams = this.mm.spawn(l, data.getCaster().getLevel());
                    if (ams == null) continue;
                    MythicMobs.inst().getEntityManager().registerMob(ams.getEntity().getWorld(), ams.getEntity());
                    if (data.getCaster() instanceof ActiveMob) {
                        ActiveMob am = (ActiveMob)data.getCaster();
                        ams.setParent(am);
                        ams.setFaction(am.getFaction());
                        if (this.copyThreatTable) {
                            try {
                                ams.importThreatTable(am.getThreatTable().clone());
                                ams.getThreatTable().targetHighestThreat();
                            }
                            catch (CloneNotSupportedException e1) {
                                e1.printStackTrace();
                            }
                            continue;
                        }
                        if (!this.inheritThreatTable) continue;
                        ams.importThreatTable(am.getThreatTable());
                        ams.getThreatTable().targetHighestThreat();
                        continue;
                    }
                    ams.setOwner(data.getCaster().getEntity().getUniqueId());
                }
            } else {
                for (int i = 1; i <= this.amount; ++i) {
                    ActiveMob ams = this.mm.spawn(target, data.getCaster().getLevel());
                    if (ams == null) continue;
                    MythicMobs.inst().getEntityManager().registerMob(ams.getEntity().getWorld(), ams.getEntity());
                    if (data.getCaster() instanceof ActiveMob) {
                        ActiveMob am = (ActiveMob)data.getCaster();
                        ams.setParent(am);
                        ams.setFaction(am.getFaction());
                        if (this.copyThreatTable) {
                            try {
                                ams.importThreatTable(am.getThreatTable().clone());
                                ams.getThreatTable().targetHighestThreat();
                            }
                            catch (CloneNotSupportedException e1) {
                                e1.printStackTrace();
                            }
                            continue;
                        }
                        if (!this.inheritThreatTable) continue;
                        ams.importThreatTable(am.getThreatTable());
                        ams.getThreatTable().targetHighestThreat();
                        continue;
                    }
                    ams.setOwner(data.getCaster().getEntity().getUniqueId());
                }
            }
            return true;
        }
        if (this.me != null) {
            if (this.noise > 0) {
                for (int i = 1; i <= this.amount; ++i) {
                    MythicMobs.inst().getMobManager();
                    AbstractLocation l = MobManager.findSafeSpawnLocation(target, this.noise, this.yNoise, this.me.getHeight(), this.yUpOnly);
                    this.me.spawn(BukkitAdapter.adapt(l));
                }
            } else {
                for (int i = 1; i <= this.amount; ++i) {
                    this.me.spawn(BukkitAdapter.adapt(target));
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.castAtLocation(data, target.getLocation());
        return true;
    }
}

