/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.TaskManager;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import org.bukkit.util.Vector;

public class SpinEffect
extends SkillMechanic
implements ITargetedEntitySkill {
    protected int duration;
    protected int velocity;

    public SpinEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 40);
        this.velocity = mlc.getInteger(new String[]{"velocity", "v"}, 18);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Animator(target, this.duration, this.velocity);
        return true;
    }

    private class Animator
    implements Runnable {
        private AbstractEntity target;
        private float yaw;
        private int velocity;
        private int duration;
        private int iteration;
        private int taskId;

        public Animator(AbstractEntity target, int duration, int velocity) {
            this(duration, velocity);
            this.target = target;
            this.yaw = target.getLocation().getYaw();
        }

        protected Animator(int duration, int velocity) {
            this.velocity = velocity;
            this.duration = duration;
            this.iteration = 0;
            this.taskId = TaskManager.get().scheduleTask(this, 0, 1);
        }

        @Override
        public void run() {
            if (this.iteration > this.duration) {
                TaskManager.get().cancelTask(this.taskId);
            } else {
                this.yaw = (this.yaw + (float)this.velocity) % 360.0f;
                AbstractLocation l = this.target.getLocation();
                Vector v = this.target.getBukkitEntity().getVelocity();
                v.setY(v.getY() + 0.01);
                l.setYaw(this.yaw);
                this.target.teleport(l);
                this.target.getBukkitEntity().setVelocity(v);
                ++this.iteration;
            }
        }
    }
}

