/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;

public class SoundEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    String sound;
    float pitch;
    float volume;

    public SoundEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.sound = mlc.getString("sound", "reddust");
        this.sound = mlc.getString("s", this.sound);
        this.pitch = mlc.getFloat("pitch", 1.0f);
        this.pitch = mlc.getFloat("p", this.pitch);
        this.volume = mlc.getFloat("volume", 1.0f);
        this.volume = mlc.getFloat("v", this.volume);
        if (this.sound.equals("random.wood_click")) {
            this.sound = "random.wood click";
        } else if (this.sound.equals("mob.ghast.affectionate_scream")) {
            this.sound = "mob.ghast.affectionate scream";
        }
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playSoundEffect(target);
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playSoundEffect(target.getLocation());
        return false;
    }

    protected void playSoundEffect(AbstractLocation l) {
        MythicMobs.plugin.volatileCodeHandler.PlaySoundAtLocation(l, this.sound, this.volume, this.pitch);
    }
}

