/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.WitherSkull;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class ShootSkullSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected float yield;
    protected boolean playsound;

    public ShootSkullSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.yield = mlc.getFloat("yield", 1.0f);
        this.yield = mlc.getFloat("strength", this.yield);
        this.yield = mlc.getFloat("y", this.yield);
        this.yield = mlc.getFloat("s", this.yield);
        this.playsound = mlc.getBoolean("playsound", false);
        this.playsound = mlc.getBoolean("ps", this.playsound);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        WitherSkull fireball;
        Entity l = BukkitAdapter.adapt(data.getCaster().getEntity());
        Entity t = BukkitAdapter.adapt(target);
        if (l instanceof Creature && ((Creature)l).getTarget() == target) {
            fireball = (WitherSkull)((LivingEntity)l).launchProjectile(WitherSkull.class);
        } else {
            Vector facing = t.getLocation().toVector().subtract(l.getLocation().toVector()).normalize();
            Location loc = l.getLocation().clone();
            double yaw = Math.toDegrees(Math.atan2(-facing.getX(), facing.getZ()));
            double pitch = Math.toDegrees(-Math.asin(facing.getY()));
            loc.setYaw((float)yaw);
            loc.setPitch((float)pitch);
            loc.add(facing.multiply(2));
            fireball = (WitherSkull)l.getLocation().getWorld().spawn(loc, WitherSkull.class);
        }
        if (this.playsound) {
            l.getWorld().playEffect(l.getLocation(), Effect.GHAST_SHOOT, 0);
        }
        fireball.setBounce(false);
        fireball.setYield(this.yield);
        if (l instanceof LivingEntity) {
            fireball.setShooter((ProjectileSource)((LivingEntity)l));
        }
        return true;
    }
}

