/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ParticleEffect;
import net.elseland.xikage.MythicMobs.Skills.SkillCaster;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ParticleLineEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    float distanceBetween;
    float yStartOffset;
    boolean fromOrigin;

    public ParticleLineEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.yStartOffset = mlc.getFloat("ystartoffset", 0.0f);
        this.yStartOffset = mlc.getFloat("ys", this.yStartOffset);
        this.distanceBetween = mlc.getFloat("distancebetween", 0.25f);
        this.distanceBetween = mlc.getFloat("db", this.distanceBetween);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playParticleLineEffect(data.getCaster(), data.getOrigin(), target);
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playParticleLineEffect(data.getCaster(), data.getOrigin(), target.getLocation());
        return false;
    }

    protected void playParticleLineEffect(SkillCaster am, AbstractLocation origin, AbstractLocation target) {
        Location l;
        Location sl = this.fromOrigin ? BukkitAdapter.adapt(origin).add(0.0, (double)this.yStartOffset, 0.0) : BukkitAdapter.adapt(am.getEntity()).getLocation().add(0.0, (double)this.yStartOffset, 0.0);
        int c = (int)Math.ceil(sl.distance(l = BukkitAdapter.adapt(target)) / (double)this.distanceBetween) - 1;
        if (c <= 0) {
            return;
        }
        Vector v = l.toVector().subtract(sl.toVector()).normalize().multiply(this.distanceBetween);
        Location l2 = sl.clone().add(0.0, (double)this.yOffset, 0.0);
        for (int i = 0; i < c; ++i) {
            l2.add(v);
            this.playParticleEffect(l2);
        }
    }
}

