/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import java.awt.Color;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.ParticleMaker;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Util.MythicUtil;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ParticleEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    String strParticle;
    float hSpread;
    float vSpread;
    float pSpeed;
    float yOffset;
    float fOffset;
    float sOffset;
    boolean useEyeLocation;
    int amount;
    int viewDistance;
    Color color = null;
    boolean fromOrigin;

    public ParticleEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.strParticle = mlc.getString("particle", "reddust");
        this.strParticle = mlc.getString("p", this.strParticle);
        this.amount = mlc.getInteger("amount", 10);
        this.amount = mlc.getInteger("a", this.amount);
        this.hSpread = mlc.getFloat("hspread", 0.0f);
        this.hSpread = mlc.getFloat("hs", this.hSpread);
        this.vSpread = mlc.getFloat("vspread", 0.0f);
        this.vSpread = mlc.getFloat("vs", this.vSpread);
        this.pSpeed = mlc.getFloat("speed", 0.0f);
        this.pSpeed = mlc.getFloat("s", this.pSpeed);
        this.yOffset = mlc.getFloat("yoffset", 0.0f);
        this.yOffset = mlc.getFloat("y", this.yOffset);
        this.fOffset = mlc.getFloat("forwardoffset", 0.0f);
        this.fOffset = mlc.getFloat("foffset", this.fOffset);
        this.fOffset = mlc.getFloat("fo", this.fOffset);
        this.sOffset = mlc.getFloat("sideoffset", 0.0f);
        this.sOffset = mlc.getFloat("soffset", this.sOffset);
        this.sOffset = mlc.getFloat("so", this.sOffset);
        this.useEyeLocation = mlc.getBoolean("useeyelocation", false);
        this.useEyeLocation = mlc.getBoolean("uel", this.useEyeLocation);
        this.viewDistance = mlc.getInteger(new String[]{"viewdistance", "vd"}, 128);
        this.viewDistance *= this.viewDistance;
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        String color = mlc.getString(new String[]{"color", "c"}, null, new String[0]);
        if (color != null) {
            this.color = Color.decode(color);
        }
        this.fOffset *= -1.0f;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playParticleEffect(BukkitAdapter.adapt(target));
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        Location l = this.useEyeLocation ? target.getEyeLocation() : BukkitAdapter.adapt(target.getLocation());
        if (this.fOffset > 0.0f || this.sOffset != 0.0f) {
            l.setPitch(0.0f);
            l = MythicUtil.move(l, this.fOffset, 0.0, this.sOffset);
        }
        this.playParticleEffect(l);
        return false;
    }

    protected void playParticleEffect(Location target) {
        if (MythicMobs.minecraftVersion < 7) {
            MythicMobs.plugin.volatileCodeHandler.doParticleEffect(target, this.strParticle, this.hSpread, this.vSpread, this.amount, this.pSpeed, this.yOffset, 256);
            return;
        }
        if (this.color != null) {
            this.playColoredParticleEffect(target);
            return;
        }
        Location ln = target.clone().add(0.0, (double)this.yOffset, 0.0);
        new ParticleMaker.ParticlePacket(this.strParticle, this.hSpread, this.vSpread, this.hSpread, this.pSpeed, this.amount, true).send(ln, this.viewDistance);
    }

    protected void playColoredParticleEffect(Location target) {
        for (int i = 0; i < this.amount; ++i) {
            Location ln = target.clone().add((double)(0.0f - this.hSpread) + MythicMobs.r.nextDouble() * (double)this.hSpread * 2.0, (double)(this.yOffset - this.vSpread) + MythicMobs.r.nextDouble() * (double)this.vSpread * 2.0, (double)(0.0f - this.hSpread) + MythicMobs.r.nextDouble() * (double)this.hSpread * 2.0);
            new ParticleMaker.ParticlePacket(this.strParticle, this.color, this.pSpeed, this.amount, true).send(ln, this.viewDistance);
        }
    }

    protected void playDirectionalParticleEffect(Location target) {
        Vector direction = new Vector(0, 0, 0);
        for (int i = 0; i < this.amount; ++i) {
            Location ln = target.clone().add((double)(0.0f - this.hSpread) + MythicMobs.r.nextDouble() * (double)this.hSpread * 2.0, (double)(this.yOffset - this.vSpread) + MythicMobs.r.nextDouble() * (double)this.vSpread * 2.0, (double)(0.0f - this.hSpread) + MythicMobs.r.nextDouble() * (double)this.hSpread * 2.0);
            new ParticleMaker.ParticlePacket(this.strParticle, direction, this.pSpeed, this.amount, true).send(ln, this.viewDistance);
        }
    }
}

