/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Skills.INoTargetSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Skills.SkillString;
import org.bukkit.Bukkit;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;

public class ModifyScoreMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected String entry;
    protected String objective;
    protected ModifyScoreAction action;
    protected String value;

    public ModifyScoreMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.entry = mlc.getString(new String[]{"entry", "e", "name", "n"}, "dummy", new String[0]);
        this.objective = mlc.getString(new String[]{"objective", "obj", "o"}, "", new String[0]);
        this.value = mlc.getString(new String[]{"value", "v"}, "0", new String[0]);
        String strAction = mlc.getString(new String[]{"action", "a"}, "SET", new String[0]);
        try {
            this.action = ModifyScoreAction.valueOf(strAction.toUpperCase());
        }
        catch (Exception ex) {
            this.action = ModifyScoreAction.SET;
        }
    }

    @Override
    public boolean cast(SkillMetadata data) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        String fentry = SkillString.parseMobVariables(this.entry, data.getCaster(), null, data.getTrigger());
        String fobjective = SkillString.parseMobVariables(this.objective, data.getCaster(), null, data.getTrigger());
        int fvalue = Integer.valueOf(SkillString.parseMobVariables(this.value, data.getCaster(), null, data.getTrigger()));
        Objective objective = scoreboard.getObjective(fobjective);
        if (objective == null) {
            objective = scoreboard.registerNewObjective(fobjective, "dummy");
        }
        if (this.action != ModifyScoreAction.UNSET) {
            Score score = objective.getScore(fentry);
            score.setScore(this.applyModifier(score.getScore(), fvalue));
        }
        return true;
    }

    protected int applyModifier(int score, int value) {
        if (this.action == ModifyScoreAction.SET) {
            score = value;
        } else if (this.action == ModifyScoreAction.ADD) {
            score += value;
        } else if (this.action == ModifyScoreAction.SUBTRACT) {
            score -= value;
        } else if (this.action == ModifyScoreAction.MULTIPLY) {
            score *= value;
        } else if (this.action == ModifyScoreAction.DIVIDE) {
            score /= value;
        } else if (this.action == ModifyScoreAction.MOD) {
            score %= value;
        }
        return score;
    }

    protected static enum ModifyScoreAction {
        SET,
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        MOD,
        UNSET;

    }
}

