/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import java.util.List;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.AbstractPlayer;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Adapters.TaskManager;
import net.elseland.xikage.MythicMobs.IO.Load.Configuration;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillCaster;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class GeyserEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private int height;
    private int tickInterval;
    private Material type;

    public GeyserEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.height = mlc.getInteger(new String[]{"height", "h"}, 3);
        this.tickInterval = mlc.getInteger(new String[]{"interval", "i", "speed", "s"}, 10);
        String strType = mlc.getString(new String[]{"type", "t"}, "water", new String[0]);
        this.type = strType.equalsIgnoreCase("lava") ? Material.STATIONARY_LAVA : (strType.equalsIgnoreCase("water") ? Material.STATIONARY_WATER : Material.STATIONARY_WATER);
        if (this.height <= 0) {
            this.height = 1;
        }
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(data.getCaster(), target);
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(data.getCaster(), target.getLocation());
        return true;
    }

    protected void playEffect(SkillCaster am, AbstractLocation target) {
        List<AbstractPlayer> players = target.getWorld().getPlayersNearLocation(target, 50);
        new Animator(target, players);
    }

    private class Animator
    implements Runnable {
        private int taskId;
        private int tick = 0;
        private AbstractLocation start;
        private List<AbstractPlayer> nearby;

        public Animator(AbstractLocation start, List<AbstractPlayer> nearby) {
            this.start = start;
            this.nearby = nearby;
            this.taskId = TaskManager.get().scheduleTask(this, 0, GeyserEffect.this.tickInterval);
        }

        @Override
        public void run() {
            try {
                if (this.tick > GeyserEffect.this.height * 2) {
                    TaskManager.get().cancelTask(this.taskId);
                } else if (this.tick < GeyserEffect.this.height) {
                    Block block = BukkitAdapter.adapt(this.start.clone().add(0.0, this.tick, 0.0)).getBlock();
                    if (block.getType() == Material.AIR) {
                        for (AbstractPlayer p : this.nearby) {
                            ((Player)BukkitAdapter.adapt(p)).sendBlockChange(block.getLocation(), GeyserEffect.this.type, (byte)0);
                        }
                    }
                } else {
                    int n = GeyserEffect.this.height - (this.tick - GeyserEffect.this.height) - 1;
                    Block block = BukkitAdapter.adapt(this.start.clone().add(0.0, n, 0.0)).getBlock();
                    for (AbstractPlayer p : this.nearby) {
                        ((Player)BukkitAdapter.adapt(p)).sendBlockChange(block.getLocation(), block.getType(), block.getData());
                    }
                }
                ++this.tick;
            }
            catch (Exception ex) {
                if (Configuration.debugLevel > 0) {
                    ex.printStackTrace();
                }
                TaskManager.get().cancelTask(this.taskId);
            }
        }
    }
}

