/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import java.util.Arrays;
import java.util.List;
import net.elseland.xikage.MythicMobs.Drops.DropHandler;
import net.elseland.xikage.MythicMobs.Drops.MythicDropTable;
import net.elseland.xikage.MythicMobs.Drops.MythicEquipable;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Items.MythicItem;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.Mobs.Entities.MythicArmorStand;
import net.elseland.xikage.MythicMobs.Mobs.EquipmentManager;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.INoTargetSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.EntityEquipment;

public class EquipSkill
extends SkillMechanic
implements INoTargetSkill {
    String equipString;

    public EquipSkill(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.equipString = mlc.getString("item");
        this.equipString = mlc.getString("i", this.equipString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cast(SkillMetadata data) {
        MythicDropTable dt;
        Object split;
        if (!(data.getCaster() instanceof ActiveMob)) {
            return false;
        }
        ActiveMob am = (ActiveMob)data.getCaster();
        MythicEquipable helmet = null;
        MythicEquipable chest = null;
        MythicEquipable leggings = null;
        MythicEquipable boots = null;
        MythicEquipable hand = null;
        MythicEquipable offhand = null;
        MythicMobs.debug(3, "Executing Equip AbstractSkill");
        MythicMobs.debug(3, "-- Parsing equipment: " + this.equipString);
        String prefix = "";
        if (this.equipString.contains(":")) {
            split = this.equipString.split(":");
            dt = DropHandler.getMythicDropTable(split[0]);
            prefix = split[1];
        } else {
            dt = DropHandler.getMythicDropTable(this.equipString);
        }
        if (dt != null) {
            MythicMobs.debug(3, "---- Retrieved Drop Table: " + dt.dtName);
            MythicMobs.debug(4, "---- Drop Table contains: " + dt.equipablesList.toString());
        } else {
            MythicMobs.debug(3, "---- No Drop Table found named " + this.equipString + ". Searching for item...");
            split = this.equipString.split(":");
            MythicItem mi = MythicItem.getMythicItem(split[0]);
            if (mi != null) {
                try {
                    List<String> baseEquipmentList = Arrays.asList(this.equipString);
                    dt = new MythicDropTable(baseEquipmentList, null, null, null, null);
                }
                catch (Exception e) {
                    MythicMobs.error("Equip AbstractSkill appears to have invalid equipment configured for it. Please check the formatting! Equipment: " + this.equipString);
                }
            }
        }
        if (dt != null) {
            dt.parseTable(am);
            for (MythicEquipable is : dt.equipablesList) {
                MythicMobs.debug(4, "------ Loaded item in slot " + is.getSlot() + " with Item Stack: " + is.getItemStack().toString());
                if (!(MythicMobs.r.nextFloat() <= is.getChance())) continue;
                if (is.getSlot() == 0 && EquipmentManager.CompareEquipment(is, hand)) {
                    hand = is;
                }
                if (is.getSlot() == 1 && EquipmentManager.CompareEquipment(is, boots)) {
                    boots = is;
                }
                if (is.getSlot() == 2 && EquipmentManager.CompareEquipment(is, leggings)) {
                    leggings = is;
                }
                if (is.getSlot() == 3 && EquipmentManager.CompareEquipment(is, chest)) {
                    chest = is;
                }
                if (is.getSlot() == 4 && EquipmentManager.CompareEquipment(is, helmet)) {
                    helmet = is;
                }
                if (is.getSlot() != 5 || !EquipmentManager.CompareEquipment(is, offhand)) continue;
                offhand = is;
            }
        }
        if (am.getType().getMythicEntity() instanceof MythicArmorStand) {
            ArmorStand as = (ArmorStand)data.getCaster().getEntity().getBukkitEntity();
            if (helmet != null) {
                as.setHelmet(helmet.getItemStack());
                MythicMobs.debug(3, "-- Set Mob Helm to: " + helmet.getItemStack().toString());
            }
            if (chest != null) {
                as.setChestplate(chest.getItemStack());
                MythicMobs.debug(3, "-- Set Mob Chest to: " + chest.getItemStack().toString());
            }
            if (leggings != null) {
                as.setLeggings(leggings.getItemStack());
                MythicMobs.debug(3, "-- Set Mob Legs to: " + leggings.getItemStack().toString());
            }
            if (boots != null) {
                as.setBoots(boots.getItemStack());
                MythicMobs.debug(3, "-- Set Mob Boots to: " + boots.getItemStack().toString());
            }
            if (hand != null) {
                as.setItemInHand(hand.getItemStack());
                MythicMobs.debug(3, "-- Set Mob Hand to: " + hand.getItemStack().toString());
            }
            if (offhand == null) return true;
        }
        if (!data.getCaster().getEntity().isLiving()) return true;
        EntityEquipment ee = am.getLivingEntity().getEquipment();
        ee.setItemInHandDropChance(0.0f);
        ee.setHelmetDropChance(0.0f);
        ee.setChestplateDropChance(0.0f);
        ee.setLeggingsDropChance(0.0f);
        ee.setBootsDropChance(0.0f);
        if (helmet != null) {
            ee.setHelmet(helmet.getItemStack());
            MythicMobs.debug(3, "-- Set Mob Helm to: " + helmet.getItemStack().toString());
        }
        if (chest != null) {
            ee.setChestplate(chest.getItemStack());
            MythicMobs.debug(3, "-- Set Mob Chest to: " + chest.getItemStack().toString());
        }
        if (leggings != null) {
            ee.setLeggings(leggings.getItemStack());
            MythicMobs.debug(3, "-- Set Mob Legs to: " + leggings.getItemStack().toString());
        }
        if (boots != null) {
            ee.setBoots(boots.getItemStack());
            MythicMobs.debug(3, "-- Set Mob Boots to: " + boots.getItemStack().toString());
        }
        if (hand != null) {
            ee.setItemInHand(hand.getItemStack());
            MythicMobs.debug(3, "-- Set Mob Hand to: " + hand.getItemStack().toString());
        }
        if (offhand == null) return true;
        ee.setItemInOffHand(offhand.getItemStack());
        MythicMobs.debug(3, "-- Set Mob OffHand to: " + offhand.getItemStack().toString());
        return true;
    }
}

