/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Conditions;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.Conditions.ConditionAction;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.AltitudeCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.BiomeCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.CrouchingCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.DawnCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.DayCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.DistanceCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.DistanceFromSpawnCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.DuskCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.EntityTypeCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.FallSpeedCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.GlidingCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.HeightAboveCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.HeightBelowCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.HeightCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.InBlockCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.InsideCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.LevelCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.LineOfSightCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.NightCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.NotInRegionCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.OnBlockCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.OnGroundCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.OutsideCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.OwnerCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.RainingCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.RegionCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.ScoreCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.SunnyCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions.ThunderingCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.IEntityComparisonCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.IEntityCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.ILocationComparisonCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.ILocationCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.InvalidCondition;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;

public class MythicCondition {
    protected String conditionVar = "0";
    protected ConditionAction ACTION = ConditionAction.REQUIRED;
    protected String actionVar = null;

    public MythicCondition(String line) {
        String[] split = line.split(" ");
        if (split.length < 2) {
            return;
        }
        if (ConditionAction.isAction(split[1])) {
            this.ACTION = ConditionAction.valueOf(split[1].toUpperCase());
            if (split.length > 2) {
                this.actionVar = split[2];
            }
        } else {
            this.conditionVar = split[1];
            if (split.length > 2 && ConditionAction.isAction(split[2])) {
                this.ACTION = ConditionAction.valueOf(split[2].toUpperCase());
                if (split.length > 3) {
                    this.actionVar = split[3];
                }
            }
        }
    }

    public boolean evaluateCaster(SkillMetadata meta) {
        if (this instanceof InvalidCondition) {
            return true;
        }
        if (this instanceof IEntityCondition) {
            return this.handleOutcome(meta, ((IEntityCondition)((Object)this)).check(meta.getCaster().getEntity()));
        }
        if (this instanceof ILocationCondition) {
            return this.handleOutcome(meta, ((ILocationCondition)((Object)this)).check(meta.getCaster().getLocation()));
        }
        return false;
    }

    public boolean evaluateTrigger(SkillMetadata meta) {
        if (this instanceof InvalidCondition) {
            return true;
        }
        if (meta.getTrigger() == null) {
            return false;
        }
        if (this instanceof IEntityCondition) {
            return this.handleOutcome(meta, ((IEntityCondition)((Object)this)).check(meta.getTrigger()));
        }
        if (this instanceof IEntityComparisonCondition) {
            return this.handleOutcome(meta, ((IEntityComparisonCondition)((Object)this)).check(meta.getCaster().getEntity(), meta.getTrigger()));
        }
        if (this instanceof ILocationCondition) {
            return this.handleOutcome(meta, ((ILocationCondition)((Object)this)).check(meta.getTrigger().getLocation()));
        }
        if (this instanceof ILocationComparisonCondition) {
            return this.handleOutcome(meta, ((ILocationComparisonCondition)((Object)this)).check(meta.getCaster().getLocation(), meta.getTrigger().getLocation()));
        }
        return false;
    }

    public void evaluateTargets(SkillMetadata meta) {
        if (this instanceof InvalidCondition) {
            return;
        }
        if (meta.getEntityTargets() != null && meta.getEntityTargets().size() > 0) {
            meta.getEntityTargets().removeIf(target -> {
                if (this instanceof IEntityCondition) {
                    return !this.handleOutcome(meta, ((IEntityCondition)((Object)this)).check((AbstractEntity)target));
                }
                if (this instanceof IEntityComparisonCondition) {
                    return !this.handleOutcome(meta, ((IEntityComparisonCondition)((Object)this)).check(meta.getCaster().getEntity(), (AbstractEntity)target));
                }
                if (this instanceof ILocationCondition) {
                    return !this.handleOutcome(meta, ((ILocationCondition)((Object)this)).check(target.getLocation()));
                }
                if (this instanceof ILocationComparisonCondition) {
                    return !this.handleOutcome(meta, ((ILocationComparisonCondition)((Object)this)).check(meta.getCaster().getLocation(), target.getLocation()));
                }
                return false;
            });
        } else if (meta.getLocationTargets() != null && meta.getLocationTargets().size() > 0) {
            meta.getLocationTargets().removeIf(target -> {
                if (this instanceof ILocationCondition) {
                    return !this.handleOutcome(meta, ((ILocationCondition)((Object)this)).check((AbstractLocation)target));
                }
                if (this instanceof ILocationComparisonCondition) {
                    return !this.handleOutcome(meta, ((ILocationComparisonCondition)((Object)this)).check(meta.getCaster().getLocation(), (AbstractLocation)target));
                }
                return false;
            });
        }
    }

    public boolean handleOutcome(SkillMetadata meta, boolean outcome) {
        switch (this.ACTION) {
            case CAST: {
                break;
            }
            case CASTINSTEAD: {
                break;
            }
            case CANCEL: 
            case FALSE: {
                return !outcome;
            }
            case POWER: {
                try {
                    float powerMod = Float.valueOf(this.actionVar).floatValue();
                    meta.setPower(meta.getPower() * powerMod);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case REQUIRED: 
            case TRUE: {
                return outcome;
            }
        }
        return true;
    }

    public void setAction(ConditionAction action) {
        this.ACTION = action;
    }

    public static MythicCondition getCondition(String condition) {
        if (condition.contains("}")) {
            String ns;
            String sp1 = condition.substring(0, condition.indexOf("}"));
            String sp2 = condition.substring(condition.indexOf("}"));
            condition = ns = sp1.replace(" ", "") + sp2;
            MythicMobs.debug(4, "------ Normalized Condition string to: " + condition);
        }
        String[] s = condition.split(" ");
        String name = null;
        MythicLineConfig mlc = new MythicLineConfig(s[0]);
        name = s[0].contains("{") ? s[0].substring(0, s[0].indexOf("{")) : s[0];
        MythicMobs.debug(3, "------ Matching MythicCondition type to " + name);
        switch (name.toUpperCase()) {
            case "ALTITUDE": 
            case "HEIGHTFROMSURFACE": {
                return new AltitudeCondition(condition, mlc);
            }
            case "BIOME": {
                return new BiomeCondition(condition, mlc);
            }
            case "CROUCHING": 
            case "SNEAKING": {
                return new CrouchingCondition(condition, mlc);
            }
            case "DAWN": {
                return new DawnCondition(condition);
            }
            case "DAY": {
                return new DayCondition(condition);
            }
            case "DISTANCE": {
                return new DistanceCondition(condition, mlc);
            }
            case "DISTANCEFROMSPAWN": {
                return new DistanceFromSpawnCondition(condition, mlc);
            }
            case "DUSK": {
                return new DuskCondition(condition);
            }
            case "ENTITYTYPE": {
                return new EntityTypeCondition(condition, mlc);
            }
            case "FALLSPEED": 
            case "FALLINGSPEED": {
                return new FallSpeedCondition(condition, mlc);
            }
            case "GLIDING": 
            case "ISGLIDING": {
                return new GlidingCondition(condition, mlc);
            }
            case "HEIGHT": {
                return new HeightCondition(condition);
            }
            case "HEIGHTABOVE": {
                return new HeightAboveCondition(condition);
            }
            case "HEIGHTBELOW": {
                return new HeightBelowCondition(condition);
            }
            case "INBLOCK": 
            case "INSIDEBLOCK": {
                return new InBlockCondition(condition);
            }
            case "INSIDE": {
                return new InsideCondition(condition);
            }
            case "LEVEL": {
                return new LevelCondition(condition);
            }
            case "LINEOFSIGHT": 
            case "INLINEOFSIGHT": {
                return new LineOfSightCondition(condition, mlc);
            }
            case "NIGHT": {
                return new NightCondition(condition);
            }
            case "ONBLOCK": {
                return new OnBlockCondition(condition);
            }
            case "ONGROUND": 
            case "GROUNDED": {
                return new OnGroundCondition(condition, mlc);
            }
            case "OUTSIDE": {
                return new OutsideCondition(condition);
            }
            case "OWNER": {
                return new OwnerCondition(condition, mlc);
            }
            case "RAINING": 
            case "ISRAINING": {
                return new RainingCondition(condition);
            }
            case "REGION": 
            case "INREGION": {
                return new RegionCondition(condition, mlc);
            }
            case "NOTINREGION": {
                return new NotInRegionCondition(condition, mlc);
            }
            case "SCORE": {
                return new ScoreCondition(condition, mlc);
            }
            case "SUNNY": 
            case "ISSUNNY": {
                return new SunnyCondition(condition);
            }
            case "THUNDERING": 
            case "ISTHUNDERING": {
                return new ThunderingCondition(condition);
            }
        }
        return new InvalidCondition(condition);
    }
}

