/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.RandomSpawning;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.AbstractWorld;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.Configuration;
import net.elseland.xikage.MythicMobs.IO.Load.MythicConfig;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.Mobs.MythicMob;
import net.elseland.xikage.MythicMobs.Mobs.WorldScaling;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.RandomSpawning.RandomSpawnPoint;
import net.elseland.xikage.MythicMobs.RandomSpawning.RandomSpawnerAction;
import net.elseland.xikage.MythicMobs.SConditions.SCondition;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class RandomSpawner {
    public static Set<RandomSpawnPoint> spawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public String name;
    public List<MythicMob> mobTypes = new ArrayList<MythicMob>();
    RandomSpawnerAction action;
    public int priority;
    public int level;
    public float chance;
    public HashSet<Biome> biomes = new HashSet();
    public HashSet<AbstractWorld> worlds = new HashSet();
    public HashSet<CreatureSpawnEvent.SpawnReason> spawnReasons = new HashSet();
    public List<String> conditions;
    private boolean hasConditions = false;
    private boolean useWorldScaling = true;

    public RandomSpawner(String file, String name, MythicConfig mc) {
        this.name = name;
        String strAction = mc.getString("SpawnMethod", "ADD");
        strAction = mc.getString("Action", strAction);
        this.action = RandomSpawnerAction.valueOf(strAction.toUpperCase());
        String strMobName = mc.getString("Mobname", "");
        strMobName = mc.getString("MobName", strMobName);
        strMobName = mc.getString("MobType", strMobName);
        strMobName = mc.getString("Type", strMobName);
        strMobName = mc.getString("Types", strMobName);
        if (!strMobName.equalsIgnoreCase("GROUP")) {
            String[] types;
            for (String s : types = strMobName.split(",")) {
                MythicMob mm = MythicMobs.inst().getMobManager().getMythicMob(s);
                if (mm == null) continue;
                this.mobTypes.add(mm);
            }
        }
        this.level = mc.getInt("Level", 1);
        this.chance = (float)mc.getDouble("Chance", 1.0);
        this.priority = mc.getInt("Priority", 1);
        this.useWorldScaling = mc.getBoolean("UseWorldScaling", true);
        this.conditions = mc.getStringList("Conditions");
        if (this.conditions.size() > 0) {
            this.hasConditions = true;
        }
        String world = mc.getString("Worlds");
        String biome = mc.getString("Biomes");
        String reasons = mc.getString("Reason");
        reasons = mc.getString("Reasons", reasons);
        if (world != null) {
            String[] worldName = world.split(",");
            World w = null;
            if (worldName != null) {
                String[] stringArray = worldName;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String wName = stringArray[i];
                    w = Bukkit.getWorld((String)wName);
                    if (w == null) continue;
                    this.worlds.add(BukkitAdapter.adapt(w));
                }
            }
        }
        if (biome != null) {
            String[] biomename;
            for (String bName : biomename = biome.split(",")) {
                Biome b = Biome.valueOf((String)bName.toUpperCase());
                if (b == null) continue;
                this.biomes.add(b);
            }
        }
        if (reasons != null) {
            String[] r;
            for (String rr : r = reasons.split(",")) {
                CreatureSpawnEvent.SpawnReason fr = CreatureSpawnEvent.SpawnReason.valueOf((String)rr);
                if (fr == null) continue;
                this.spawnReasons.add(fr);
            }
        }
    }

    public float getChance() {
        return this.chance;
    }

    public int getLevel(AbstractLocation location) {
        int level = this.getBaseLevel();
        if (this.useWorldScaling) {
            level += WorldScaling.getLevelBonus(location);
        }
        return level;
    }

    public int getBaseLevel() {
        return this.level;
    }

    public int getPriority() {
        return this.priority;
    }

    public RandomSpawnerAction getAction() {
        return this.action;
    }

    public HashSet<Biome> getBiomes() {
        return this.biomes;
    }

    public HashSet<AbstractWorld> getWorlds() {
        return this.worlds;
    }

    public HashSet<CreatureSpawnEvent.SpawnReason> getReasons() {
        return this.spawnReasons;
    }

    public boolean isValid() {
        return this.mobTypes.size() > 0;
    }

    public boolean hasConditions() {
        return this.hasConditions;
    }

    public boolean checkSpawn(RandomSpawnPoint rsp) {
        if (this.chance < MythicMobs.r.nextFloat()) {
            return false;
        }
        if (this.spawnReasons.size() > 0) {
            if (!this.spawnReasons.contains(rsp.getReason())) {
                return false;
            }
        } else {
            switch (rsp.getReason()) {
                case NATURAL: {
                    break;
                }
                case REINFORCEMENTS: {
                    break;
                }
                case VILLAGE_INVASION: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (!this.worlds.contains(rsp.getLocation().getWorld())) {
            return false;
        }
        if (this.biomes.size() > 0 && !this.biomes.contains(rsp.getBiome())) {
            return false;
        }
        if (this.hasConditions()) {
            for (String strCondition : this.conditions) {
                MythicMobs.debug(4, "-- Validating Spawn Condition " + strCondition);
                String[] split = strCondition.split(" ");
                String conditionData = null;
                if (split.length > 1) {
                    conditionData = split[1];
                }
                if (SCondition.getSpawningConditionByName(split[0]).check(BukkitAdapter.adapt(rsp.getLocation()), (LivingEntity)BukkitAdapter.adapt(rsp.getEntity()), conditionData)) continue;
                return false;
            }
        }
        return true;
    }

    public ActiveMob spawn(RandomSpawnPoint rsp) {
        MythicMob mm = this.mobTypes.size() > 0 ? this.mobTypes.get(MythicMobs.r.nextInt(this.mobTypes.size())) : this.mobTypes.get(0);
        return MythicMobs.inst().getMobManager().spawnMob(mm.getInternalName(), rsp.getLocation(), this.getLevel(rsp.getLocation()));
    }

    public static Entity handleSpawnEvent(RandomSpawnPoint rsp) {
        if (rsp.getEntity() == null) {
            return null;
        }
        if (MythicMobs.plugin.listRandomSpawningR.size() == 0) {
            return null;
        }
        if (!Configuration.generateRSPoints()) {
            MythicMobs.inst().getRandomSpawningManager().landSpawnPoints.add(rsp);
        }
        for (RandomSpawner RS : MythicMobs.plugin.listRandomSpawningR) {
            if (!RS.checkSpawn(rsp) || !RS.isValid()) continue;
            return RS.spawn(rsp).getEntity().getBukkitEntity();
        }
        return null;
    }
}

