/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.elseland.xikage.MythicMobs.API.Bukkit.MythicMobsBukkitAPI;
import net.elseland.xikage.MythicMobs.API.MythicMobsAPI;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitServer;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitSkillTriggers;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitWorldManager;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Commands.CommandHandler;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events.BlockBreakListener;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events.ChunkLoadListener;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events.ChunkUnloadListener;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events.EndermanTeleportListener;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events.MobEggListener;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events.MobExplodeListener;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events.MobLeashListener;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events.MobSpawnListener;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events.MobTagListener;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events.MobTargetListener;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events.PlayerLoginListener;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events.SilverfishEnterBlockListener;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events.SkillShootProjectileListener;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events.SkillTriggerAD;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events.SlimeSplitListener;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events.SnowFormListener;
import net.elseland.xikage.MythicMobs.Adapters.ServerInterface;
import net.elseland.xikage.MythicMobs.Adapters.SkillAdapter;
import net.elseland.xikage.MythicMobs.Adapters.TaskManager;
import net.elseland.xikage.MythicMobs.Adapters.WorldManager;
import net.elseland.xikage.MythicMobs.Clock.MythicMobsAsyncClock;
import net.elseland.xikage.MythicMobs.Clock.MythicMobsClock;
import net.elseland.xikage.MythicMobs.Clock.TimingsHandler;
import net.elseland.xikage.MythicMobs.Compatibility.CompatibilityManager;
import net.elseland.xikage.MythicMobs.Compatibility.LanguageAPISupport;
import net.elseland.xikage.MythicMobs.Drops.MythicDropTable;
import net.elseland.xikage.MythicMobs.IO.IOLoader;
import net.elseland.xikage.MythicMobs.IO.Load.Configuration;
import net.elseland.xikage.MythicMobs.Items.ItemManager;
import net.elseland.xikage.MythicMobs.Items.MythicItem;
import net.elseland.xikage.MythicMobs.LegacySkills.LegacyMythicSkill;
import net.elseland.xikage.MythicMobs.MCStats.MetricsLite;
import net.elseland.xikage.MythicMobs.Mobs.EntityManager;
import net.elseland.xikage.MythicMobs.Mobs.MobManager;
import net.elseland.xikage.MythicMobs.RandomSpawning.RandomSpawner;
import net.elseland.xikage.MythicMobs.RandomSpawning.RandomSpawnerManager;
import net.elseland.xikage.MythicMobs.Skills.SkillManager;
import net.elseland.xikage.MythicMobs.Spawners.MythicSpawner;
import net.elseland.xikage.MythicMobs.Spawners.SpawnerManager;
import net.elseland.xikage.MythicMobs.Util.Patterns;
import net.elseland.xikage.MythicMobs.VolatileCode.VolatileCodeDisabled;
import net.elseland.xikage.MythicMobs.VolatileCode.VolatileCodeHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MythicMobs
extends JavaPlugin {
    public static MythicMobs plugin;
    public Logger logger = Logger.getLogger("Minecraft");
    public static Random r;
    public List<Listener> skillEvents = new ArrayList<Listener>();
    public List<MythicDropTable> listDropTables = new ArrayList<MythicDropTable>();
    public List<MythicItem> listItems = new ArrayList<MythicItem>();
    public List<LegacyMythicSkill> listLegacySkills = new ArrayList<LegacyMythicSkill>();
    public List<RandomSpawner> listRandomSpawningA = new ArrayList<RandomSpawner>();
    public List<RandomSpawner> listRandomSpawningR = new ArrayList<RandomSpawner>();
    public List<RandomSpawner> listRandomSpawningD = new ArrayList<RandomSpawner>();
    public List<MythicSpawner> listSpawners = new ArrayList<MythicSpawner>();
    public ConcurrentHashMap<AbstractLocation, MythicSpawner> mmBreakableSpawners = new ConcurrentHashMap();
    public ConcurrentHashMap<String, HashSet<MythicSpawner>> mmChunkSpawnerLookup = new ConcurrentHashMap();
    public ConcurrentHashMap<Integer, MythicSpawner> mmSpawnerHashcodeLookup = new ConcurrentHashMap();
    public Set<Player> onlinePlayers = Collections.newSetFromMap(new ConcurrentHashMap());
    public IOLoader items;
    public IOLoader droptables;
    public IOLoader settings;
    public IOLoader spawners;
    public IOLoader spawning;
    public List<IOLoader> saveMobList;
    public List<IOLoader> saveItemList;
    public List<IOLoader> saveDropTablesList;
    public List<IOLoader> saveRandomSpawnerList;
    public List<IOLoader> saveMythicSpawnerList;
    public VolatileCodeHandler volatileCodeHandler;
    public TimingsHandler timingsHandler;
    public static String menu_header;
    public static String bukkitVersion;
    public static int minecraftVersion;
    public static LanguageAPISupport Language;
    public static boolean updateAvailable;
    private EntityManager entityManager;
    private WorldManager worldManager;
    private RandomSpawnerManager rsManager;
    private MobManager mobManager;
    private SkillManager skillManager;
    private ItemManager itemManager;
    private SpawnerManager spawnerManager;
    private CompatibilityManager compatibility;
    private ServerInterface server;
    private MythicMobsAPI mmAPI;

    public void onEnable() {
        plugin = this;
        this.server = new BukkitServer();
        TaskManager.initializeBukkit(this);
        SkillAdapter.initializeBukkit();
        PluginDescriptionFile pdfFile = this.getDescription();
        bukkitVersion = Bukkit.getServer().getClass().getPackage().getName().substring(23);
        try {
            String[] split = bukkitVersion.split("_");
            minecraftVersion = Integer.parseInt(split[1]);
        }
        catch (Exception ex) {
            minecraftVersion = 10;
            ex.printStackTrace();
        }
        Language = new LanguageAPISupport((Plugin)plugin, "enUS");
        MythicMobs.log(Language.get((CommandSender)Bukkit.getConsoleSender(), "loading", "Loading {0} for Bukkit {1} (Minecraft 1.{2})...", pdfFile.getName(), bukkitVersion, minecraftVersion));
        Patterns.CompilePatterns();
        this.compatibility = new CompatibilityManager();
        this.itemManager = new ItemManager();
        this.mobManager = new MobManager();
        this.skillManager = new SkillManager();
        this.spawnerManager = new SpawnerManager();
        Configuration.LoadAll(true);
        MythicMobs.log("MythicMobs configuration file loaded successfully.");
        this.volatileCodeHandler = this.getVolatileCodeHandler();
        this.timingsHandler = new TimingsHandler();
        MythicMobs.inst().getMobManager().loadCachedActiveMobs();
        this.entityManager = new EntityManager();
        this.worldManager = new BukkitWorldManager();
        this.rsManager = new RandomSpawnerManager();
        this.getCommand("MythicMobs").setExecutor((CommandExecutor)new CommandHandler());
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new MythicMobsClock(), 0L, (long)Configuration.ClockInterval);
        this.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this, (Runnable)new MythicMobsAsyncClock(), 0L, (long)Configuration.ClockInterval);
        PluginManager manager = this.getServer().getPluginManager();
        manager.registerEvents((Listener)this.entityManager, (Plugin)this);
        manager.registerEvents((Listener)this.worldManager, (Plugin)this);
        manager.registerEvents((Listener)new ChunkLoadListener(), (Plugin)this);
        manager.registerEvents((Listener)new ChunkUnloadListener(), (Plugin)this);
        manager.registerEvents((Listener)new BukkitSkillTriggers(), (Plugin)this);
        manager.registerEvents((Listener)new SkillTriggerAD(), (Plugin)this);
        manager.registerEvents((Listener)new MobSpawnListener(), (Plugin)this);
        manager.registerEvents((Listener)new SkillShootProjectileListener(), (Plugin)this);
        manager.registerEvents((Listener)new MobLeashListener(), (Plugin)this);
        manager.registerEvents((Listener)new MobTagListener(), (Plugin)this);
        manager.registerEvents((Listener)new MobTargetListener(), (Plugin)this);
        manager.registerEvents((Listener)new SlimeSplitListener(), (Plugin)this);
        manager.registerEvents((Listener)new EndermanTeleportListener(), (Plugin)this);
        manager.registerEvents((Listener)new MobEggListener(), (Plugin)this);
        manager.registerEvents((Listener)new PlayerLoginListener(), (Plugin)this);
        manager.registerEvents((Listener)new MobExplodeListener(), (Plugin)this);
        manager.registerEvents((Listener)new SilverfishEnterBlockListener(), (Plugin)this);
        manager.registerEvents((Listener)new SnowFormListener(), (Plugin)this);
        manager.registerEvents((Listener)new BlockBreakListener(), (Plugin)this);
        this.mmAPI = new MythicMobsBukkitAPI();
        MythicMobs.log("v" + pdfFile.getVersion() + " has been successfully loaded!");
        if (Configuration.AllowMetrics) {
            try {
                MetricsLite metrics = new MetricsLite((Plugin)this);
                metrics.start();
            }
            catch (IOException e) {
                MythicMobs.debug(1, "Metrics: Failed to submit Metrics stats.");
            }
        }
        MythicMobs.inst().getMobManager().ScanWorld();
    }

    public void onDisable() {
        MythicMobs.log("Disabling Mythic Mobs...");
        this.rsManager.shutdown();
        SpawnerManager.resetAndSaveAll();
        Configuration.SaveAll();
        MythicMobs.inst().getMobManager().despawnAllMobs();
        PluginDescriptionFile pdfFile = this.getDescription();
        this.entityManager = null;
        this.volatileCodeHandler = null;
        this.timingsHandler = null;
        MythicMobs.log("All active settings have been saved.");
        Configuration.ResetAll();
        MythicMobs.log("v" + pdfFile.getVersion() + " has been Disabled!");
    }

    public static MythicMobs inst() {
        return plugin;
    }

    public MobManager getMobManager() {
        return this.mobManager;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public WorldManager getWorldManager() {
        return this.worldManager;
    }

    public SkillManager getSkillManager() {
        return this.skillManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public MythicMobsAPI getAPI() {
        return this.mmAPI;
    }

    public CompatibilityManager getCompatibility() {
        return this.compatibility;
    }

    public ServerInterface getMinecraftServer() {
        return this.server;
    }

    public void registerSkillEvents(Listener l) {
        this.getServer().getPluginManager().registerEvents(l, (Plugin)this);
    }

    public void unregisterSkillEvents() {
        for (Listener l : this.skillEvents) {
            HandlerList.unregisterAll((Listener)l);
        }
        this.skillEvents.clear();
    }

    public static void throwSevere(String key, String default_text, Object ... params) {
        MythicMobs.log(Level.SEVERE, Language.get((CommandSender)Bukkit.getConsoleSender(), key, default_text, params));
    }

    public static void throwWarning(String key, String default_text, Object ... params) {
        MythicMobs.log(Level.WARNING, Language.get((CommandSender)Bukkit.getConsoleSender(), key, default_text, params));
    }

    public static void throwInfo(String key, String default_text, Object ... params) {
        MythicMobs.log(Level.INFO, Language.get((CommandSender)Bukkit.getConsoleSender(), key, default_text, params));
    }

    public static void debug(String message) {
        MythicMobs.debug(2, message);
    }

    public static void debug(int level, String message) {
        if (level <= Configuration.debugLevel) {
            MythicMobs.log(Level.INFO, message);
        }
    }

    public static void log(String message) {
        MythicMobs.log(Level.INFO, "" + message);
    }

    public static void log(Level level, String message) {
        plugin.getLogger().log(level, message);
    }

    public static void error(String message) {
        MythicMobs.log(Level.WARNING, message);
    }

    public static void skillConfigError(String skill, String line, String message) {
        MythicMobs.log(Level.WARNING, "Error with '" + skill + "' skill: " + message);
        MythicMobs.log(Level.WARNING, "-- Incorrect line: " + line);
    }

    public static void targeterConfigError(String skill, String line, String message) {
        MythicMobs.log(Level.WARNING, "Error with '" + skill + "' targeter: " + message);
        MythicMobs.log(Level.WARNING, "-- Incorrect attribute: " + line);
    }

    public TimingsHandler getTimingsHandler() {
        return this.timingsHandler;
    }

    public VolatileCodeHandler getVolatileCodeHandler() {
        if (this.volatileCodeHandler != null) {
            return this.volatileCodeHandler;
        }
        VolatileCodeHandler VCH = new VolatileCodeDisabled();
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        String version = packageName.substring(packageName.lastIndexOf(46) + 1);
        if (version.equals("craftbukkit")) {
            version = "pre";
        }
        try {
            Class<?> clazz = Class.forName("net.elseland.xikage.MythicMobs.VolatileCode.VolatileCodeEnabled_" + version);
            if (VolatileCodeHandler.class.isAssignableFrom(clazz)) {
                VCH = (VolatileCodeHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            MythicMobs.error(menu_header);
            MythicMobs.error("This version of MythicMobs is not fully compatible with your version of Bukkit.");
            MythicMobs.error("Some features may be limited or disabled until you use a compatible version.");
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown exception loading version handler. Volatile code has been disabled.", e);
        }
        return VCH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(Exception ex) {
        if (Configuration.errorLogging) {
            plugin.getLogger().severe("AN EXCEPTION HAS OCCURED:");
            try (PrintWriter writer = null;){
                File folder = new File(plugin.getDataFolder(), "Error Logs");
                if (!folder.exists()) {
                    folder.mkdir();
                }
                writer = new PrintWriter(new File(folder, System.currentTimeMillis() + ".txt"));
                for (Throwable t = ex; t != null; t = t.getCause()) {
                    plugin.getLogger().severe("    " + t.getMessage() + " (" + t.getClass().getName() + ")");
                    t.printStackTrace(writer);
                    writer.println();
                }
                plugin.getLogger().severe("This error has been saved in the Error Logs folder");
                writer.println("MythicMobs version: " + plugin.getDescription().getVersion());
                writer.println("Bukkit version: " + Bukkit.getServer().getVersion());
            }
        } else {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(Error ex) {
        if (Configuration.errorLogging) {
            plugin.getLogger().severe("AN ERROR HAS OCCURED:");
            try (PrintWriter writer = null;){
                File folder = new File(plugin.getDataFolder(), "Error Logs");
                if (!folder.exists()) {
                    folder.mkdir();
                }
                writer = new PrintWriter(new File(folder, System.currentTimeMillis() + ".txt"));
                for (Throwable t = ex; t != null; t = t.getCause()) {
                    plugin.getLogger().severe("    " + t.getMessage() + " (" + t.getClass().getName() + ")");
                    t.printStackTrace(writer);
                    writer.println();
                }
                plugin.getLogger().severe("This error has been saved in the Error Logs folder");
                writer.println("MythicMobs version: " + plugin.getDescription().getVersion());
                writer.println("Bukkit version: " + Bukkit.getServer().getVersion());
            }
        } else {
            ex.printStackTrace();
        }
    }

    public int getMinecraftVersion() {
        return minecraftVersion;
    }

    public RandomSpawnerManager getRandomSpawningManager() {
        return this.rsManager;
    }

    public SpawnerManager getSpawnerManager() {
        return this.spawnerManager;
    }

    static {
        r = new Random();
        menu_header = ChatColor.GOLD + "--====|||| " + ChatColor.RED + ChatColor.BOLD + " MythicMobs " + ChatColor.GOLD + " ||||====--";
        updateAvailable = false;
    }
}

