/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Mobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import net.elseland.xikage.MythicMobs.API.Bukkit.Events.MythicMobSpawnEvent;
import net.elseland.xikage.MythicMobs.Adapters.AbstractBossBar;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Compatibility.CompatibilityManager;
import net.elseland.xikage.MythicMobs.Compatibility.MPetCompat;
import net.elseland.xikage.MythicMobs.IO.Load.Configuration;
import net.elseland.xikage.MythicMobs.IO.Load.MythicConfig;
import net.elseland.xikage.MythicMobs.LegacySkills.LegacyMythicTimerSkill;
import net.elseland.xikage.MythicMobs.LegacySkills.LegacySkillHandler;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.Mobs.Entities.MythicEntity;
import net.elseland.xikage.MythicMobs.Mobs.EquipmentManager;
import net.elseland.xikage.MythicMobs.Mobs.MobManager;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.QueuedMobSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Skills.SkillString;
import net.elseland.xikage.MythicMobs.Skills.SkillTrigger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.util.Vector;

public class MythicMob
implements Comparable<MythicMob> {
    private MythicConfig config;
    private String internalName;
    protected String displayName;
    protected MythicEntity mobType;
    protected Optional<MPetCompat.MiniaturePetType> mPetType;
    protected boolean optionDespawn;
    protected boolean optionPersistent;
    protected boolean optionShowHealthInChat;
    protected String strMobType;
    protected String file;
    protected String faction;
    protected double health;
    protected double damage;
    protected double armor;
    protected double attrMovementSpeed;
    protected double attrKnockbackResist;
    protected double attrFollowRange;
    protected double attrAttackSpeed;
    protected double lvlModDamage;
    protected double lvlModHealth;
    protected double lvlModArmor;
    protected double lvlModKBR;
    protected double lvlModPower;
    protected double lvlModSpeed;
    protected double lvlModAttackSpeed;
    protected boolean optionSilent;
    protected boolean optionNoAI;
    protected boolean optionGlowing;
    protected boolean optionInvincible;
    protected boolean optionCollidable;
    protected boolean optionNoGravity;
    protected boolean optionInteractable;
    protected boolean useBossBar;
    protected int bossBarRange;
    protected int bossBarRangeSq;
    protected String bossBarTitle;
    protected AbstractBossBar.BarColor bossBarColor;
    protected AbstractBossBar.BarStyle bossBarStyle;
    protected boolean bossBarCreateFog;
    protected boolean bossBarDarkenSky;
    protected boolean bossBarPlayMusic;
    protected String mount;
    private List<String> drops;
    private List<String> dropsPerLevel;
    private List<String> equipment;
    private List<String> damageModifiers;
    private List<String> entityDamageModifiers;
    private List<String> levelmods;
    private List<String> aiGSelectors;
    private List<String> aiTSelectors;
    private Queue<SkillMechanic> mSkills;
    private Queue<SkillMechanic> mSpawnSkills;
    private Queue<SkillMechanic> mDeathSkills;
    private Queue<SkillMechanic> mPlayerDeathSkills;
    private Queue<SkillMechanic> mTimerSkills;
    private Queue<SkillMechanic> mGenericSignalSkills;
    private Queue<SkillMechanic> mSpawnerReadySkills;
    private Map<String, SkillMechanic> mSignalSkills;
    private List<String> legacySkills;
    public List<LegacyMythicTimerSkill> legacyTimerSkills;
    public boolean usingTimers;
    int size;
    private int noDamageTicks;
    public int maxAttackRange;
    public int maxAttackableRange;
    public int maxThreatDistance;
    private boolean alwaysShowName;
    private boolean useThreatTable;
    private boolean useImmunityTable;
    private boolean optionTTFromDamage;
    private boolean optionTTDecayUnreachable;
    public boolean repeatAllSkills;
    public boolean preventOtherDrops;
    public boolean preventRandomEquipment;
    public boolean preventLeashing;
    public boolean preventRename;
    public boolean preventSlimeSplit;
    public boolean preventEndermanTeleport;
    public boolean preventItemPickup;
    public boolean preventSilverfishBI;
    public boolean preventExploding;
    public boolean preventMobKillDrops;
    public boolean digout;
    protected double spawnVelocityX;
    protected double spawnVelocityXMax;
    protected double spawnVelocityY;
    protected double spawnVelocityYMax;
    protected double spawnVelocityZ;
    protected double spawnVelocityZMax;
    protected boolean spawnVelocityXRange;
    protected boolean spawnVelocityYRange;
    protected boolean spawnVelocityZRange;
    public String color;
    public String catType;
    public String horseStyle;
    public String horseType;
    public String horseArmor;
    public String villagerType;
    public boolean horseTamed;
    public boolean horseSaddled;
    public boolean horseChest;
    protected List<String> killMessages;
    public String disguise;
    private Disguise libsDisguise;

    public MythicMob(String file, String internalName, MythicConfig mc) {
        block76: {
            block75: {
                block74: {
                    block73: {
                        block72: {
                            Matcher Rmatcher;
                            Pattern Rpattern;
                            this.mPetType = Optional.empty();
                            this.optionShowHealthInChat = false;
                            this.faction = null;
                            this.optionSilent = false;
                            this.optionNoAI = false;
                            this.optionGlowing = false;
                            this.optionInvincible = false;
                            this.optionCollidable = true;
                            this.optionNoGravity = true;
                            this.optionInteractable = true;
                            this.useBossBar = false;
                            this.mSkills = new LinkedList<SkillMechanic>();
                            this.mSpawnSkills = new LinkedList<SkillMechanic>();
                            this.mDeathSkills = new LinkedList<SkillMechanic>();
                            this.mPlayerDeathSkills = new LinkedList<SkillMechanic>();
                            this.mTimerSkills = new LinkedList<SkillMechanic>();
                            this.mGenericSignalSkills = new LinkedList<SkillMechanic>();
                            this.mSpawnerReadySkills = new LinkedList<SkillMechanic>();
                            this.mSignalSkills = new HashMap<String, SkillMechanic>();
                            this.usingTimers = false;
                            this.alwaysShowName = true;
                            this.optionTTFromDamage = true;
                            this.optionTTDecayUnreachable = true;
                            this.repeatAllSkills = false;
                            this.preventOtherDrops = false;
                            this.preventRandomEquipment = false;
                            this.preventLeashing = false;
                            this.preventRename = true;
                            this.preventSlimeSplit = true;
                            this.preventEndermanTeleport = true;
                            this.preventItemPickup = true;
                            this.preventSilverfishBI = true;
                            this.preventExploding = false;
                            this.preventMobKillDrops = false;
                            this.digout = false;
                            this.spawnVelocityXMax = 0.0;
                            this.spawnVelocityYMax = 0.0;
                            this.spawnVelocityZMax = 0.0;
                            this.spawnVelocityXRange = false;
                            this.spawnVelocityYRange = false;
                            this.spawnVelocityZRange = false;
                            this.libsDisguise = null;
                            this.config = mc;
                            this.file = file;
                            this.internalName = internalName;
                            MythicMobs.debug(2, "Loading mob type: " + this.internalName);
                            this.strMobType = mc.getString("Type");
                            this.strMobType = mc.getString("MobType", this.strMobType);
                            this.strMobType = mc.getString("Mobtype", this.strMobType);
                            if (this.strMobType == null) {
                                MythicEntity me = MythicEntity.getMythicEntity(internalName);
                                if (me == null) {
                                    MythicMobs.throwSevere("error-mythicmob-load-notype", "Could not load MythicMob {0}! No Type specified.", this.internalName);
                                    this.strMobType = "NULL";
                                    this.mobType = MythicEntity.getMythicEntity("SKELETON");
                                    this.displayName = "ERROR: MOB TYPE FOR '" + this.internalName + "' IS NOT OPTIONAL";
                                    return;
                                }
                                MythicMobs.debug(2, "-- EntityType is vanilla override for: " + this.strMobType);
                                this.mobType = me;
                            } else {
                                MythicMobs.debug(2, "-- EntityType is " + this.strMobType);
                                MythicMobs.inst().getMobManager();
                                this.strMobType = MobManager.convertMobTypeAliases(this.strMobType);
                                if (this.strMobType.equalsIgnoreCase("MINIATUREPET") || this.strMobType.equalsIgnoreCase("MPET")) {
                                    try {
                                        MPetCompat compat;
                                        MPetCompat mPetCompat = compat = MythicMobs.inst().getCompatibility().getMiniaturePets().get();
                                        mPetCompat.getClass();
                                        this.mPetType = Optional.of(mPetCompat.new MPetCompat.MiniaturePetType(mc));
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                } else {
                                    this.mobType = MythicEntity.getMythicEntity(this.strMobType);
                                }
                            }
                            if (this.mobType != null) {
                                this.mobType.instantiate(mc);
                            } else if (!this.mPetType.isPresent()) {
                                MythicMobs.throwSevere("error-mythicmob-load-invalidtype", "Could not load MythicMob {0}! Invalid type specified.", this.internalName);
                                this.strMobType = "NULL";
                                this.mobType = MythicEntity.getMythicEntity("SKELETON");
                                this.displayName = "ERROR: MOB TYPE FOR '" + this.internalName + "' IS INVALID";
                                return;
                            }
                            this.displayName = mc.getString("Display");
                            this.displayName = mc.getString("DisplayName", this.displayName);
                            if (this.displayName != null) {
                                this.displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)this.displayName);
                            }
                            this.health = mc.getDouble("Health");
                            this.damage = mc.getDouble("Damage", -1.0);
                            this.armor = mc.getDouble("Armor");
                            this.armor = mc.getDouble("Armour", this.armor);
                            this.optionInvincible = mc.getBoolean("Options.Invincible", false);
                            this.optionInvincible = mc.getBoolean("Options.Invulnerable", this.optionInvincible);
                            this.faction = mc.getString("Faction", null);
                            this.mount = mc.getString("Riding");
                            this.mount = mc.getString("Mount", this.mount);
                            this.optionDespawn = mc.getBoolean("Despawn", true);
                            this.optionDespawn = mc.getBoolean("Options.Despawn", this.optionDespawn);
                            this.optionPersistent = mc.getBoolean("Persistent", false);
                            this.optionPersistent = mc.getBoolean("Options.Persistent", this.optionPersistent);
                            this.attrAttackSpeed = mc.getDouble("Options.AttackSpeed", 0.0);
                            this.attrMovementSpeed = mc.getDouble("Options.MovementSpeed", 0.0);
                            this.attrKnockbackResist = mc.getDouble("Options.KnockbackResistance", 0.0);
                            this.attrFollowRange = mc.getDouble("Options.FollowRange", 0.0);
                            this.attrAttackSpeed = mc.getDouble("Options.AttackSpeed", 0.0);
                            this.optionGlowing = mc.getBoolean("Options.Glowing", false);
                            this.optionCollidable = mc.getBoolean("Options.Collidable", true);
                            this.optionNoGravity = mc.getBoolean("Options.NoGravity", false);
                            this.optionInteractable = mc.getBoolean("Options.Interactable", this.optionInteractable);
                            this.optionSilent = mc.getBoolean("Options.Silent", this.optionSilent);
                            this.optionNoAI = mc.getBoolean("Options.NoAI", this.optionNoAI);
                            this.noDamageTicks = mc.getInt("Options.NoDamageTicks", 10) * 2;
                            this.useBossBar = mc.getBoolean("BossBar.Enabled", false);
                            this.bossBarTitle = mc.getString("BossBar.Title", this.displayName);
                            this.bossBarRange = mc.getInt("BossBar.Range", 64);
                            this.bossBarRangeSq = (int)Math.pow(this.bossBarRange, 2.0);
                            String bossBarColor = mc.getString("BossBar.Color", "WHITE");
                            String bossBarStyle = mc.getString("BossBar.Style", "SOLID");
                            try {
                                this.bossBarColor = AbstractBossBar.BarColor.valueOf(bossBarColor);
                            }
                            catch (Exception ex) {
                                this.bossBarColor = AbstractBossBar.BarColor.WHITE;
                            }
                            try {
                                this.bossBarStyle = AbstractBossBar.BarStyle.valueOf(bossBarStyle);
                            }
                            catch (Exception ex) {
                                this.bossBarStyle = AbstractBossBar.BarStyle.SOLID;
                            }
                            this.bossBarCreateFog = mc.getBoolean("BossBar.CreateFog", false);
                            this.bossBarDarkenSky = mc.getBoolean("BossBar.DarkenSky", false);
                            this.bossBarPlayMusic = mc.getBoolean("BossBar.PlayMusic", false);
                            MythicMobs.debug(2, "-- Loading mob skills... ");
                            List<String> nSkills = mc.getStringList("Skills");
                            int interval = 1;
                            for (String s : nSkills) {
                                Object ms;
                                MythicMobs.debug(2, "---- Loading skill string: " + s);
                                if (s.contains("\"")) {
                                    String[] split = s.split("\"");
                                    int i = 0;
                                    String ns = "";
                                    for (String ss : split) {
                                        ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                                        ++i;
                                    }
                                    s = ns;
                                    s = SkillString.convertLegacyVariables(s);
                                }
                                if ((ms = MythicMobs.inst().getSkillManager().getSkillMechanic(s)) != null) {
                                    MythicMobs.debug(2, "------ Base skill found.");
                                    if (s.contains("~onTimer")) {
                                        MythicMobs.debug(2, "-------- SkillTrigger is Timer. Assigning skill to Timer...");
                                        Rpattern = Pattern.compile("~onTimer:([0-9]+)");
                                        Rmatcher = Rpattern.matcher(s);
                                        Rmatcher.find();
                                        try {
                                            interval = Integer.parseInt(Rmatcher.group(1));
                                        }
                                        catch (Exception e) {
                                            MythicMobs.error("Error parsing Timer skill, invalid interval specified (must be an integer). AbstractSkill=" + s);
                                            continue;
                                        }
                                        MythicMobs.debug(2, "---------- AbstractSkill set on timer with interval " + interval);
                                        ((SkillMechanic)ms).setTimerInterval(interval);
                                        this.mTimerSkills.add((SkillMechanic)ms);
                                        continue;
                                    }
                                    if (s.contains("~onSignal:")) {
                                        String signal;
                                        MythicMobs.debug(2, "-------- SkillTrigger is Signal.");
                                        Rpattern = Pattern.compile("~onSignal:([a-zA-Z0-9_-]*)");
                                        Rmatcher = Rpattern.matcher(s);
                                        Rmatcher.find();
                                        try {
                                            signal = Rmatcher.group(1);
                                        }
                                        catch (Exception e) {
                                            MythicMobs.error("Error parsing Signal skill, invalid signal specified (contains invalid characters). AbstractSkill=" + s);
                                            continue;
                                        }
                                        MythicMobs.debug(2, "---------- AbstractSkill set on Signal with index " + signal);
                                        this.mSignalSkills.put(signal, (SkillMechanic)ms);
                                        continue;
                                    }
                                    if (s.contains("~onSignal")) {
                                        this.mGenericSignalSkills.add((SkillMechanic)ms);
                                        continue;
                                    }
                                    if (s.contains("~onSpawn")) {
                                        this.mSpawnSkills.add((SkillMechanic)ms);
                                        continue;
                                    }
                                    if (s.contains("~onDeath")) {
                                        this.mDeathSkills.add((SkillMechanic)ms);
                                        continue;
                                    }
                                    if (s.contains("~onPlayerDeath")) {
                                        this.mPlayerDeathSkills.add((SkillMechanic)ms);
                                        continue;
                                    }
                                    if (s.contains("~onReady") || s.contains("~onFirstSpawn")) {
                                        this.mSpawnerReadySkills.add((SkillMechanic)ms);
                                        continue;
                                    }
                                    MythicMobs.debug(2, "-------- SkillTrigger is NOT Timer. Assigning skill to regular skill tree...");
                                    this.mSkills.add((SkillMechanic)ms);
                                    continue;
                                }
                                MythicMobs.debug(2, "------ Base skill was not found.");
                            }
                            if (this.mTimerSkills.size() > 0) {
                                this.usingTimers = true;
                            }
                            this.legacySkills = mc.getStringList("LegacySkills");
                            ArrayList<String> eSkills = new ArrayList<String>();
                            ArrayList<LegacyMythicTimerSkill> tSkills = new ArrayList<LegacyMythicTimerSkill>();
                            for (String skill : this.legacySkills) {
                                if (skill.contains("~onTimer")) {
                                    Rpattern = Pattern.compile("~onTimer:([0-9]+)");
                                    Rmatcher = Rpattern.matcher(skill);
                                    Rmatcher.find();
                                    try {
                                        interval = Integer.parseInt(Rmatcher.group(1));
                                    }
                                    catch (Exception e) {
                                        MythicMobs.error("Error parsing Timer skill, invalid interval specified (must be an integer). AbstractSkill=" + skill);
                                        continue;
                                    }
                                    tSkills.add(new LegacyMythicTimerSkill(skill, interval));
                                    continue;
                                }
                                eSkills.add(skill);
                            }
                            ArrayList<String> pSkills = new ArrayList<String>();
                            for (String skill : eSkills) {
                                if (skill.contains("'")) {
                                    String[] split = skill.split("'");
                                    skill = split.length > 2 ? split[0] + "'" + SkillString.unparseMessageSpecialChars(split[1]) + "'" + split[2] : split[0] + "'" + SkillString.unparseMessageSpecialChars(split[1]) + "'";
                                }
                                pSkills.add(skill);
                            }
                            this.legacySkills = pSkills;
                            this.legacyTimerSkills = tSkills;
                            if (this.legacyTimerSkills.size() > 0) {
                                this.usingTimers = true;
                            }
                            this.optionShowHealthInChat = mc.getBoolean("ShowHealth", false);
                            this.catType = mc.getString("Options.Ocelot", "WILD_OCELOT");
                            this.catType = mc.getString("Options.CatType", this.catType);
                            this.catType = mc.getString("Options.OcelotType", this.catType);
                            this.horseArmor = mc.getString("Options.HorseArmor");
                            this.horseChest = mc.getBoolean("Options.HorseCarryingChest", false);
                            this.horseStyle = mc.getString("Options.HorseStyle");
                            this.horseType = mc.getString("Options.HorseType");
                            this.color = mc.getString("Options.HorseColor", "WHITE");
                            this.color = mc.getString("Options.SheepColor", this.color);
                            this.color = mc.getString("Options.Color", this.color);
                            this.horseSaddled = mc.getBoolean("Options.HorseSaddled", false);
                            this.horseSaddled = mc.getBoolean("Options.Saddled", this.horseSaddled);
                            this.horseTamed = mc.getBoolean("Options.HorseTamed", false);
                            this.horseTamed = mc.getBoolean("Options.Tamed", this.horseTamed);
                            this.villagerType = mc.getString("Options.VillagerType");
                            this.villagerType = mc.getString("Options.Profession", this.villagerType);
                            this.useThreatTable = mc.getBoolean("Modules.ThreatTable", false);
                            this.useImmunityTable = mc.getBoolean("Modules.ImmunityTable", false);
                            this.useThreatTable = mc.getBoolean("Options.UseThreatTable", this.useThreatTable);
                            this.useImmunityTable = mc.getBoolean("Options.UseImmunityTable", this.useImmunityTable);
                            this.useThreatTable = mc.getBoolean("ThreatTable.Enabled", this.useThreatTable);
                            this.optionTTFromDamage = mc.getBoolean("ThreatTable.UseDamageTaken", true);
                            this.optionTTDecayUnreachable = mc.getBoolean("ThreatTable.DecayUnreachable", true);
                            this.maxAttackRange = mc.getInt("Options.MaxAttackRange", 64);
                            this.maxAttackableRange = mc.getInt("Options.MaxCombatDistance", 256);
                            this.maxAttackableRange = mc.getInt("Options.MaxAttackableRange", this.maxAttackableRange);
                            this.maxThreatDistance = mc.getInt("Options.MaxThreatDistance", 40);
                            this.alwaysShowName = mc.getBoolean("Options.AlwaysShowName", false);
                            this.repeatAllSkills = mc.getBoolean("Options.RepeatAllSkills", false);
                            this.preventOtherDrops = mc.getBoolean("Options.PreventOtherDrops", false);
                            this.preventRandomEquipment = mc.getBoolean("Options.PreventRandomEquipment", false);
                            this.preventLeashing = mc.getBoolean("Options.PreventLeashing", true);
                            this.preventRename = mc.getBoolean("Options.PreventRenaming", true);
                            this.preventEndermanTeleport = mc.getBoolean("Options.PreventTeleport", false);
                            this.preventItemPickup = mc.getBoolean("Options.PreventItemPickup", false);
                            this.preventMobKillDrops = mc.getBoolean("Options.PreventMobKillDrops", false);
                            this.aiGSelectors = mc.getStringList("AIGoalSelectors");
                            this.aiTSelectors = mc.getStringList("AITargetSelectors");
                            this.drops = mc.getStringList("Drops");
                            this.dropsPerLevel = mc.getStringList("DropsPerLevel");
                            this.damageModifiers = mc.getStringList("DamageModifiers");
                            this.entityDamageModifiers = mc.getStringList("EntityDamageModifiers");
                            this.equipment = mc.getStringList("Equipment");
                            this.killMessages = mc.getStringList("KillMessages");
                            this.lvlModDamage = mc.getDouble("LevelModifiers.Damage", -1.0);
                            this.lvlModHealth = mc.getDouble("LevelModifiers.Health", -1.0);
                            this.lvlModKBR = mc.getDouble("LevelModifiers.KnockbackResistance", -1.0);
                            this.lvlModPower = mc.getDouble("LevelModifiers.Power", -1.0);
                            this.lvlModArmor = mc.getDouble("LevelModifiers.Armor", -1.0);
                            this.lvlModSpeed = mc.getDouble("LevelModifiers.MovementSpeed", -1.0);
                            this.lvlModAttackSpeed = mc.getDouble("LevelModifiers.AttackSpeed", -1.0);
                            try {
                                if (this.lvlModDamage < 0.0) {
                                    this.lvlModDamage = Configuration.defaultLevelModifierDamage.startsWith("+") ? Double.valueOf(Configuration.defaultLevelModifierDamage.substring(1)) : (Configuration.defaultLevelModifierDamage.startsWith("*") ? this.damage * Double.valueOf(Configuration.defaultLevelModifierDamage.substring(1)) : this.damage * Double.valueOf(Configuration.defaultLevelModifierDamage));
                                }
                            }
                            catch (Exception ex) {
                                MythicMobs.throwSevere("error-mythicmob-config-badlevelmod-damage", "Error calculating Damage Level Modifier: Default configuration is bad.", new Object[0]);
                                if (Configuration.debugLevel <= 0) break block72;
                                ex.printStackTrace();
                            }
                        }
                        try {
                            if (this.lvlModHealth < 0.0) {
                                this.lvlModHealth = Configuration.defaultLevelModifierHealth.startsWith("+") ? Double.valueOf(Configuration.defaultLevelModifierHealth.substring(1)) : (Configuration.defaultLevelModifierHealth.startsWith("*") ? this.health * Double.valueOf(Configuration.defaultLevelModifierHealth.substring(1)) : this.health * Double.valueOf(Configuration.defaultLevelModifierHealth));
                            }
                        }
                        catch (Exception ex) {
                            MythicMobs.throwSevere("error-mythicmob-config-badlevelmod-health", "Error calculating Health Level Modifier: Default configuration is bad.", new Object[0]);
                            if (Configuration.debugLevel <= 0) break block73;
                            ex.printStackTrace();
                        }
                    }
                    try {
                        if (this.lvlModPower < 0.0) {
                            this.lvlModPower = Configuration.defaultLevelModifierPower.startsWith("+") ? Double.valueOf(Configuration.defaultLevelModifierPower.substring(1)) : (Configuration.defaultLevelModifierPower.startsWith("*") ? Double.valueOf(Configuration.defaultLevelModifierPower.substring(1)).doubleValue() : Double.valueOf(Configuration.defaultLevelModifierPower).doubleValue());
                        }
                    }
                    catch (Exception ex) {
                        MythicMobs.throwSevere("error-mythicmob-config-badlevelmod-power", "Error calculating Power Level Modifier: Default configuration is bad.", new Object[0]);
                        if (Configuration.debugLevel <= 0) break block74;
                        ex.printStackTrace();
                    }
                }
                try {
                    if (this.lvlModArmor < 0.0) {
                        this.lvlModArmor = Configuration.defaultLevelModifierArmor.startsWith("+") ? Double.valueOf(Configuration.defaultLevelModifierArmor.substring(1)) : (Configuration.defaultLevelModifierArmor.startsWith("*") ? this.armor * Double.valueOf(Configuration.defaultLevelModifierArmor.substring(1)) : Double.valueOf(Configuration.defaultLevelModifierArmor));
                    }
                }
                catch (Exception ex) {
                    MythicMobs.throwSevere("error-mythicmob-config-badlevelmod-armor", "Error calculating Armor Level Modifier: Default configuration is bad.", new Object[0]);
                    if (Configuration.debugLevel <= 0) break block75;
                    ex.printStackTrace();
                }
            }
            try {
                if (this.lvlModKBR < 0.0) {
                    this.lvlModKBR = Configuration.defaultLevelModifierKBR.startsWith("+") ? Double.valueOf(Configuration.defaultLevelModifierKBR.substring(1)) : (Configuration.defaultLevelModifierKBR.startsWith("*") ? this.attrKnockbackResist * Double.valueOf(Configuration.defaultLevelModifierKBR.substring(1)) : Double.valueOf(Configuration.defaultLevelModifierKBR));
                }
            }
            catch (Exception ex) {
                MythicMobs.throwSevere("error-mythicmob-config-badlevelmod-armor", "Error calculating KBR Level Modifier: Default configuration is bad.", new Object[0]);
                if (Configuration.debugLevel <= 0) break block76;
                ex.printStackTrace();
            }
        }
        this.digout = mc.getBoolean("Options.DigOutOfGround", false);
        String strSpawnVelocityX = mc.getString("SpawnModifiers.VelocityX", "0");
        String strSpawnVelocityY = mc.getString("SpawnModifiers.VelocityY", "0");
        String strSpawnVelocityZ = mc.getString("SpawnModifiers.VelocityZ", "0");
        if (strSpawnVelocityX.contains("to")) {
            String[] split = strSpawnVelocityX.split("to");
            try {
                this.spawnVelocityX = Double.valueOf(split[0]);
                this.spawnVelocityXMax = Double.valueOf(split[1]);
                this.spawnVelocityXRange = true;
            }
            catch (Exception ex) {
                this.spawnVelocityX = 0.0;
                MythicMobs.throwSevere("error-mythicmob-load-invalidspawnmodifier-velocityx", "Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityX.", this.internalName);
            }
        } else {
            try {
                this.spawnVelocityX = Double.valueOf(strSpawnVelocityX);
            }
            catch (Exception ex) {
                this.spawnVelocityX = 0.0;
                MythicMobs.throwSevere("error-mythicmob-load-invalidspawnmodifier-velocityx", "Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityX.", this.internalName);
            }
        }
        if (strSpawnVelocityY.contains("to")) {
            String[] split = strSpawnVelocityY.split("to");
            try {
                this.spawnVelocityY = Double.valueOf(split[0]);
                this.spawnVelocityYMax = Double.valueOf(split[1]);
                this.spawnVelocityYRange = true;
            }
            catch (Exception ex) {
                this.spawnVelocityY = 0.0;
                MythicMobs.throwSevere("error-mythicmob-load-invalidspawnmodifier-velocityy", "Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityY.", this.internalName);
            }
        } else {
            try {
                this.spawnVelocityY = Double.valueOf(strSpawnVelocityY);
            }
            catch (Exception ex) {
                this.spawnVelocityY = 0.0;
                MythicMobs.throwSevere("error-mythicmob-load-invalidspawnmodifier-velocityy", "Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityY.", this.internalName);
            }
        }
        if (strSpawnVelocityZ.contains("to")) {
            String[] split = strSpawnVelocityZ.split("to");
            try {
                this.spawnVelocityZ = Double.valueOf(split[0]);
                this.spawnVelocityZMax = Double.valueOf(split[1]);
                this.spawnVelocityZRange = true;
            }
            catch (Exception ex) {
                this.spawnVelocityZ = 0.0;
                MythicMobs.throwSevere("error-mythicmob-load-invalidspawnmodifier-velocityz", "Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityZ.", this.internalName);
            }
        } else {
            try {
                this.spawnVelocityZ = Double.valueOf(strSpawnVelocityZ);
            }
            catch (Exception ex) {
                this.spawnVelocityZ = 0.0;
                MythicMobs.throwSevere("error-mythicmob-load-invalidspawnmodifier-velocityz", "Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityZ.", this.internalName);
            }
        }
        this.disguise = mc.getString("Options.Disguise", this.disguise);
        this.disguise = mc.getString("Disguise.Type", this.disguise);
        if (this.disguise == null || CompatibilityManager.LibsDisguises != null) {
            // empty if block
        }
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public ActiveMob spawn(AbstractLocation location, int level) {
        Entity e;
        MythicMobs.inst().getMobManager();
        MobManager.spawnflag = true;
        if (this.mPetType.isPresent()) {
            e = this.mPetType.get().spawn(location);
        } else if (this.mobType != null) {
            e = this.mobType.spawn(this, BukkitAdapter.adapt(location));
        } else {
            return null;
        }
        MythicMobs.debug(1, "Calling MythicMobSpawnEvent for " + this.getInternalName() + " (level: " + level + ")");
        MythicMobSpawnEvent event = new MythicMobSpawnEvent(e, this, level);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            e.remove();
            return null;
        }
        level = event.getMobLevel();
        ActiveMob am = new ActiveMob(e.getUniqueId(), BukkitAdapter.adapt(e), this, level);
        MythicMobs.inst().getMobManager().registerActiveMob(am);
        Scoreboard sb = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective o = sb.getObjective("MythicMobType");
        if (o == null) {
            o = sb.registerNewObjective("MythicMobType", "dummy");
        }
        o.getScore(am.getUniqueId().toString()).setScore(this.getInternalName().hashCode());
        am = this.applyMobOptions(am, level);
        am = this.applyMobVolatileOptions(am);
        am = this.applySpawnModifiers(am);
        if (this.getSkills() != null) {
            new QueuedMobSkill(SkillTrigger.SPAWN, am, null);
        }
        MythicMobs.inst().getMobManager();
        MobManager.spawnflag = false;
        return am;
    }

    public ActiveMob applyMobOptions(ActiveMob am, int level) {
        Entity entity = am.getEntity().getBukkitEntity();
        if (am.getEntity().isLiving()) {
            LivingEntity asLiving;
            block33: {
                asLiving = (LivingEntity)entity;
                if (!this.optionDespawn) {
                    asLiving.setRemoveWhenFarAway(false);
                }
                if (this.alwaysShowName) {
                    asLiving.setCustomNameVisible(true);
                }
                if (this.preventItemPickup) {
                    asLiving.setCanPickupItems(false);
                }
                if (MythicMobs.inst().getMinecraftVersion() >= 9) {
                    if (this.damage > 0.0 && asLiving.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE) != null) {
                        asLiving.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(am.getDamage());
                    }
                    if (this.attrMovementSpeed != 0.0) {
                        asLiving.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(this.getMovementSpeed(level));
                    }
                    if (this.attrAttackSpeed != 0.0 && asLiving.getAttribute(Attribute.GENERIC_ATTACK_SPEED) != null) {
                        asLiving.getAttribute(Attribute.GENERIC_ATTACK_SPEED).setBaseValue(this.getAttackSpeed(level));
                    }
                    if (this.attrFollowRange != 0.0) {
                        asLiving.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(this.attrFollowRange);
                    }
                    if (this.attrKnockbackResist != 0.0) {
                        asLiving.getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE).setBaseValue(this.getKnockbackResistance(level));
                    }
                    if (!this.optionCollidable) {
                        asLiving.setCollidable(false);
                    }
                } else {
                    if (this.attrMovementSpeed != 0.0) {
                        if (this.attrMovementSpeed == -1.0) {
                            MythicMobs.plugin.volatileCodeHandler.setMobSpeed((Entity)asLiving, 0.0);
                        } else {
                            MythicMobs.plugin.volatileCodeHandler.setMobSpeed((Entity)asLiving, this.getMovementSpeed(level));
                        }
                    }
                    if (this.attrFollowRange != 0.0) {
                        MythicMobs.plugin.volatileCodeHandler.setFollowRange((Entity)asLiving, this.attrFollowRange);
                    }
                    if (this.attrKnockbackResist > 0.0) {
                        MythicMobs.plugin.volatileCodeHandler.setKnockBackResistance((Entity)asLiving, this.getKnockbackResistance(level));
                    }
                }
                if (this.damage > 0.0 && CompatibilityManager.Heroes != null) {
                    CompatibilityManager.Heroes.setMobDamage(asLiving, am.getDamage());
                }
                if (this.health > 0.0) {
                    double health = this.health;
                    if (level > 1 && this.lvlModHealth > 0.0) {
                        health += this.lvlModHealth * (double)(level - 1);
                    }
                    try {
                        health = Math.ceil(health);
                        asLiving.setMaxHealth(health);
                        asLiving.setHealth(health);
                    }
                    catch (IllegalArgumentException ex) {
                        MythicMobs.throwSevere("error-mythicmob-load-spigotmaxhp", "Spawning MythicMob of type {0} failed: Mob HP is greater than server's maxHealth setting. Please modify spigot.yml and increase the maxHealth attribute to compensate.", this.internalName);
                        if (Configuration.debugLevel <= 0) break block33;
                        ex.printStackTrace();
                    }
                }
            }
            asLiving.setMaximumNoDamageTicks(this.noDamageTicks);
            if (entity instanceof Creature) {
                if (this.preventRandomEquipment) {
                    final EntityEquipment ee = asLiving.getEquipment();
                    new BukkitRunnable(){

                        public void run() {
                            ee.setHelmet(new ItemStack(Material.AIR));
                            ee.setChestplate(new ItemStack(Material.AIR));
                            ee.setLeggings(new ItemStack(Material.AIR));
                            ee.setBoots(new ItemStack(Material.AIR));
                            ee.setItemInHand(new ItemStack(Material.AIR));
                        }
                    }.runTaskLater((Plugin)MythicMobs.plugin, 1L);
                }
                final ActiveMob amm = am;
                new BukkitRunnable(){

                    public void run() {
                        EquipmentManager.setEquipment(amm);
                    }
                }.runTaskLater((Plugin)MythicMobs.plugin, 2L);
            }
            if (this.getDisplayName() != null) {
                asLiving.setCustomName(SkillString.parseMobVariables(this.getDisplayName(), am, null, null));
            }
        }
        if (MythicMobs.inst().getMinecraftVersion() >= 9) {
            if (this.optionInvincible) {
                entity.setInvulnerable(true);
            }
            if (this.optionGlowing) {
                entity.setGlowing(true);
            }
        }
        if (MythicMobs.inst().getMinecraftVersion() >= 10) {
            if (this.optionNoGravity) {
                entity.setGravity(false);
            }
            if (this.optionSilent) {
                entity.setSilent(true);
            }
        }
        MythicMobs.inst().getMobManager();
        MobManager.setMetaData(am.getEntity(), this.getInternalName(), "mobname");
        MythicMobs.inst().getMobManager();
        MobManager.setMetaData(am.getEntity(), "true", "mythicmob");
        if (this.mount != null) {
            MythicMobs.inst().getMobManager();
            if (!MobManager.mountflag && MythicMobs.inst().getMobManager().getMythicMob(this.mount) != null) {
                MythicMobs.inst().getMobManager();
                MobManager.mountflag = true;
                AbstractEntity mount = MythicMobs.inst().getMobManager().getMythicMob(this.mount).spawn(am.getLocation(), level).getEntity();
                MythicMobs.inst().getMobManager();
                MobManager.mountflag = false;
                mount.setPassenger(entity);
                ActiveMob mountInstance = MythicMobs.inst().getMobManager().getMythicMobInstance(mount);
                am.setMount(mountInstance);
            }
        }
        return am;
    }

    public ActiveMob applyMobVolatileOptions(ActiveMob am) {
        Entity e = am.getEntity().getBukkitEntity();
        if (this.hasFaction()) {
            e.setMetadata("Faction", (MetadataValue)new FixedMetadataValue((Plugin)MythicMobs.inst(), (Object)this.getFaction()));
        }
        if (am.getEntity().isCreature()) {
            if (this.optionNoAI) {
                MythicMobs.inst().getVolatileCodeHandler().setNoAI(am);
            }
            if (Configuration.EnableAIModifiers) {
                if (this.getAIGoalSelectors() != null) {
                    MythicMobs.plugin.volatileCodeHandler.aiGoalSelectorHandler((LivingEntity)e, this.getAIGoalSelectors());
                }
                if (this.getAITargetSelectors() != null) {
                    MythicMobs.plugin.volatileCodeHandler.aiTargetSelectorHandler((LivingEntity)e, this.getAITargetSelectors());
                }
            }
        }
        if (MythicMobs.inst().getMinecraftVersion() < 10 && this.optionSilent) {
            MythicMobs.plugin.getVolatileCodeHandler().setEntitySilent(e);
        }
        if (this.disguise != null && CompatibilityManager.LibsDisguises != null) {
            CompatibilityManager.LibsDisguises.setDisguise(am, this.disguise);
        }
        return am;
    }

    public ActiveMob applySpawnModifiers(ActiveMob am) {
        double vl;
        Entity e = am.getEntity().getBukkitEntity();
        Vector v = e.getVelocity();
        if (this.spawnVelocityXRange) {
            vl = MythicMobs.r.nextDouble() * (this.spawnVelocityXMax - this.spawnVelocityX) + this.spawnVelocityX;
            v.setX(vl);
        } else {
            v.setX(this.spawnVelocityX);
        }
        if (this.spawnVelocityYRange) {
            vl = MythicMobs.r.nextDouble() * (this.spawnVelocityYMax - this.spawnVelocityY) + this.spawnVelocityY;
            v.setY(vl);
        } else {
            v.setY(this.spawnVelocityY);
        }
        if (this.spawnVelocityZRange) {
            vl = MythicMobs.r.nextDouble() * (this.spawnVelocityZMax - this.spawnVelocityZ) + this.spawnVelocityZ;
            v.setZ(vl);
        } else {
            v.setZ(this.spawnVelocityZ);
        }
        e.setVelocity(v);
        return am;
    }

    public void executeSkills(SkillTrigger cause, SkillMetadata data) {
        for (SkillMechanic ms : this.getSkills(cause)) {
            if (!ms.usable(data.getCaster(), data.getCause())) continue;
            ms.execute(data);
        }
        if (Configuration.EnableLegacySkills) {
            LegacySkillHandler.ExecuteSkills(this.legacySkills, (Entity)((LivingEntity)BukkitAdapter.adapt(data.getCaster().getEntity())), (LivingEntity)BukkitAdapter.adapt(data.getTrigger()), data.getCause());
        }
    }

    public void executeSignalSkill(String signal, SkillMetadata data) {
        SkillMechanic ms;
        if (this.mSignalSkills.containsKey(signal) && (ms = this.mSignalSkills.get(signal)).usable(data.getCaster(), data.getCause())) {
            ms.execute(data);
        }
        for (SkillMechanic ms2 : this.mGenericSignalSkills) {
            if (!ms2.usable(data.getCaster(), data.getCause())) continue;
            ms2.execute(data);
        }
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getFileName() {
        return this.file;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEntityType() {
        return this.strMobType;
    }

    public MythicEntity getMythicEntity() {
        return this.mobType;
    }

    public boolean getDespawns() {
        return this.optionDespawn;
    }

    public boolean isPersistent() {
        return this.optionPersistent;
    }

    public double getBaseHealth() {
        return this.health;
    }

    public double getPerLevelHealth() {
        return this.lvlModHealth;
    }

    public double getBaseDamage() {
        return this.damage;
    }

    public double getPerLevelDamage() {
        return this.lvlModDamage;
    }

    public double getPerLevelPower() {
        return this.lvlModPower;
    }

    public double getBaseArmor() {
        return this.armor;
    }

    public double getPerLevelArmor() {
        return this.lvlModArmor;
    }

    public double getMovementSpeed(int level) {
        double attr = this.attrMovementSpeed;
        if (level > 1 && this.lvlModSpeed > 0.0) {
            attr += this.lvlModSpeed * (double)(level - 1);
        }
        return attr;
    }

    public double getKnockbackResistance(int level) {
        double attr = this.attrKnockbackResist;
        if (level > 1 && this.lvlModKBR > 0.0) {
            attr += this.lvlModKBR * (double)(level - 1);
        }
        return attr;
    }

    public double getAttackSpeed(int level) {
        double attr = this.attrAttackSpeed;
        if (level > 1 && this.lvlModAttackSpeed > 0.0) {
            attr += this.lvlModAttackSpeed * (double)(level - 1);
        }
        return attr;
    }

    public boolean hasFaction() {
        return this.faction != null;
    }

    public String getFaction() {
        return this.faction;
    }

    public double getHealth() {
        return this.health;
    }

    public boolean getIsInvincible() {
        return this.optionInvincible;
    }

    public boolean usesThreatTable() {
        return this.useThreatTable;
    }

    public boolean usesImmunityTable() {
        return this.useImmunityTable;
    }

    public boolean getThreatTableUseDamageTaken() {
        return this.optionTTFromDamage;
    }

    public boolean getThreatTableDecaysUnreachable() {
        return this.optionTTDecayUnreachable;
    }

    public List<String> getSkills() {
        return this.legacySkills;
    }

    public List<String> getEquipment() {
        return this.equipment;
    }

    public List<String> getDrops() {
        return this.drops;
    }

    public List<String> getDropsPerLevel() {
        return this.dropsPerLevel;
    }

    public List<String> getDamageModifiers() {
        return this.damageModifiers;
    }

    public List<String> getEntityDamageModifiers() {
        return this.entityDamageModifiers;
    }

    public List<String> getLevelModifiers() {
        return this.levelmods;
    }

    public List<String> getAIGoalSelectors() {
        return this.aiGSelectors;
    }

    public List<String> getAITargetSelectors() {
        return this.aiTSelectors;
    }

    public Queue<SkillMechanic> getSkills(SkillTrigger st) {
        switch (st) {
            case SPAWN: {
                return this.mSpawnSkills;
            }
            case DEATH: {
                return this.mDeathSkills;
            }
            case PLAYERDEATH: {
                return this.mPlayerDeathSkills;
            }
            case READY: {
                return this.mSpawnerReadySkills;
            }
        }
        return this.mSkills;
    }

    public Queue<SkillMechanic> getTimerSkills() {
        return this.mTimerSkills;
    }

    public boolean hasKillMessages() {
        return this.killMessages.size() > 0;
    }

    public String getKillMessage() {
        if (!this.hasKillMessages()) {
            return null;
        }
        String s = this.killMessages.size() == 1 ? Configuration.KillMessagePrefix + this.killMessages.get(0) : Configuration.KillMessagePrefix + this.killMessages.get(MythicMobs.r.nextInt(this.killMessages.size()));
        return s;
    }

    public double getSpawnVelocityX() {
        return this.spawnVelocityX;
    }

    public double getSpawnVelocityY() {
        return this.spawnVelocityY;
    }

    public double getSpawnVelocityZ() {
        return this.spawnVelocityZ;
    }

    public int getNoDamageTicks() {
        return this.noDamageTicks;
    }

    public boolean getIsInteractable() {
        return this.optionInteractable;
    }

    public boolean usesBossBar() {
        return this.useBossBar;
    }

    public int getBossBarRangeSquared() {
        return this.bossBarRangeSq;
    }

    public Optional<AbstractBossBar> getBossBar() {
        if (!this.useBossBar) {
            return Optional.empty();
        }
        AbstractBossBar bar = MythicMobs.inst().getMinecraftServer().createBossBar(this.bossBarTitle, this.bossBarColor, this.bossBarStyle);
        bar.setProgress(1.0);
        if (this.bossBarCreateFog) {
            bar.setCreateFog(true);
        }
        if (this.bossBarDarkenSky) {
            bar.setDarkenSky(true);
        }
        if (this.bossBarPlayMusic) {
            bar.setPlayBossMusic(true);
        }
        return Optional.of(bar);
    }

    public String getBossBarTitle() {
        return this.bossBarTitle;
    }

    public boolean equals(Object o) {
        return o instanceof MythicMob && ((MythicMob)o).getInternalName().equals(this.internalName);
    }

    public String toString() {
        return this.internalName;
    }

    @Override
    public int compareTo(MythicMob mm) {
        return this.internalName.compareTo(mm.getInternalName());
    }

    public boolean getShowHealthInChat() {
        return this.optionShowHealthInChat;
    }
}

