/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Mobs.Entities;

import net.elseland.xikage.MythicMobs.IO.Load.MythicConfig;
import net.elseland.xikage.MythicMobs.Mobs.Entities.MythicEntity;
import net.elseland.xikage.MythicMobs.Mobs.MythicMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Llama;
import org.bukkit.inventory.LlamaInventory;

public class MythicLlama
extends MythicEntity {
    private static final int height = 2;
    int age = 0;
    String horseColor;
    boolean ageLock;
    boolean horseChest;
    boolean horseSaddled;
    boolean horseTamed;

    @Override
    public void instantiate(MythicConfig mc) {
        this.age = mc.getInt("Options.Age", 0);
        this.ageLock = mc.getBoolean("Options.AgeLock", false);
        this.horseChest = mc.getBoolean("Options.CarryingChest", false);
        this.horseColor = mc.getString("Options.Color", this.horseColor);
        this.horseTamed = mc.getBoolean("Options.Tamed", this.horseTamed);
    }

    @Override
    public Entity spawn(MythicMob mm, Location location) {
        Llama e = (Llama)location.getWorld().spawnEntity(location, EntityType.LLAMA);
        e = (Llama)this.applyOptions((Entity)e);
        return e;
    }

    @Override
    public Entity spawn(Location location) {
        Llama e = (Llama)location.getWorld().spawnEntity(location, EntityType.LLAMA);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Llama e = (Llama)entity;
        e.setAge(this.age);
        e.setAgeLock(this.ageLock);
        try {
            e.setColor(Llama.Color.valueOf((String)this.horseColor));
        }
        catch (Exception ex) {
            MythicMobs.error("invalid llama color");
        }
        LlamaInventory hi = e.getInventory();
        if (this.horseChest) {
            e.setCarryingChest(true);
        }
        if (this.horseTamed) {
            e.setTamed(true);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Llama;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

