/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Mobs.Entities;

import net.elseland.xikage.MythicMobs.IO.Load.MythicConfig;
import net.elseland.xikage.MythicMobs.Mobs.Entities.MythicEntity;
import net.elseland.xikage.MythicMobs.Mobs.MythicMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import org.bukkit.Location;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class MythicCreeper
extends MythicEntity {
    private static final int height = 2;
    private boolean powered = false;
    private boolean preventSuicide = false;
    private int explosionFuseTicks = -1;
    private int explosionRadius = -1;

    @Override
    public void instantiate(MythicConfig mc) {
        this.powered = mc.getBoolean("Options.SuperCharged", false);
        this.preventSuicide = mc.getBoolean("Options.PreventSuicide", false);
        this.explosionFuseTicks = mc.getInt("Options.FuseTicks", -1);
        this.explosionRadius = mc.getInt("Options.ExplosionRadius", -1);
    }

    @Override
    public Entity spawn(MythicMob mm, Location location) {
        Creeper e = (Creeper)location.getWorld().spawnEntity(location, EntityType.CREEPER);
        e = this.applyOptions((Entity)e);
        return e;
    }

    @Override
    public Entity spawn(Location location) {
        Creeper e = (Creeper)location.getWorld().spawnEntity(location, EntityType.CREEPER);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Creeper e = (Creeper)entity;
        if (this.powered) {
            e.setPowered(true);
        }
        if (this.explosionFuseTicks >= 0) {
            MythicMobs.plugin.volatileCodeHandler.setCreeperFuseTicks(e, this.explosionFuseTicks);
        }
        if (this.explosionRadius >= 0) {
            MythicMobs.plugin.volatileCodeHandler.setCreeperExplosionRadius(e, this.explosionRadius);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Creeper;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    public boolean preventSuicide() {
        return this.preventSuicide;
    }
}

