/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Items;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import net.elseland.xikage.MythicMobs.Compatibility.CompatibilityManager;
import net.elseland.xikage.MythicMobs.IO.Load.MythicConfig;
import net.elseland.xikage.MythicMobs.Items.AttributeHandler;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.SkillString;
import net.elseland.xikage.MythicMobs.Util.MythicUtil;
import net.elseland.xikage.MythicMobs.Util.Patterns;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class MythicItem {
    public String id;
    private int iid;
    private boolean useiid = false;
    public int data = 0;
    public int amount = 1;
    public String displayName;
    public String internalName;
    public String file;
    public String color;
    public String player;
    public String skinURL;
    public String skinTexture;
    UUID skinUUID;
    public List<String> lore;
    public List<String> Enchants;
    public List<String> potionEffects;
    public List<String> bannerLayers;
    public double speed;
    public double damage;
    public double knock;
    public double health;
    public double range;
    private Map<String, Map<String, Object>> itemAttributes = new HashMap<String, Map<String, Object>>();
    private Map<String, Object> itemOptions = new HashMap<String, Object>();
    private List<String> hideOptions = new ArrayList<String>();
    private boolean unbreakable;
    private boolean hideFlags;

    public MythicItem(String file, String internalName, MythicConfig mc) {
        List<String> hideOptions;
        boolean repairable;
        int repairCost;
        this.file = file;
        this.internalName = internalName;
        this.id = mc.getString("Id", "1");
        if (this.id.matches("[0-9]*")) {
            this.iid = Integer.parseInt(this.id);
            this.useiid = true;
        }
        this.data = mc.getInt("Data", 0);
        this.amount = mc.getInt("Amount", 1);
        this.displayName = mc.getString("Display");
        this.lore = mc.getStringList("Lore");
        this.Enchants = mc.getStringList("Enchantments");
        this.potionEffects = mc.getStringList("PotionEffects");
        this.bannerLayers = mc.getStringList("BannerLayers");
        this.speed = mc.getDouble("Options.MovementSpeed", 0.0);
        this.damage = mc.getDouble("Options.Damage", -1.0);
        this.health = mc.getDouble("Options.Health", 0.0);
        this.range = mc.getDouble("Options.FollowRange", 0.0);
        this.knock = mc.getDouble("Options.KnockbackResistance", 0.0);
        this.color = mc.getString("Options.Color");
        this.player = mc.getString("Options.Player");
        this.skinURL = mc.getString("Options.SkinURL");
        this.skinTexture = mc.getString("Options.SkinTexture");
        if (this.skinTexture != null) {
            this.skinUUID = MythicUtil.getUUIDFromString(this.skinTexture);
        } else if (this.skinURL != null) {
            this.skinUUID = MythicUtil.getUUIDFromString(this.skinURL);
        }
        this.unbreakable = mc.getBoolean("Options.Indestructable", false);
        this.unbreakable = mc.getBoolean("Options.Unbreakable", this.unbreakable);
        this.hideFlags = mc.getBoolean("Options.HideFlags", false);
        if (this.unbreakable) {
            this.itemOptions.put("Unbreakable", (byte)1);
        }
        if (this.hideFlags) {
            this.itemOptions.put("HideFlags", 63);
        }
        if ((repairCost = mc.getInt("Options.RepairCost", -1)) >= 0) {
            this.itemOptions.put("RepairCost", repairCost);
        }
        if (!(repairable = mc.getBoolean("Options.Repairable", true))) {
            this.itemOptions.put("RepairCost", Integer.MAX_VALUE);
        }
        if ((hideOptions = mc.getStringList("Hide")) != null) {
            for (String hide : hideOptions) {
                String f = "HIDE_" + hide.toUpperCase();
                this.hideOptions.add(f);
            }
        }
        if (mc.isSet("Attributes")) {
            try {
                for (String key : mc.getKeys("Attributes")) {
                    HashMap<String, Object> attr = new HashMap<String, Object>();
                    for (String key2 : mc.getKeys("Attributes." + key)) {
                        String value = mc.getString("Attributes." + key + "." + key2);
                        String attri = MythicMobs.inst().getItemManager().getItemAttribute(key2);
                        try {
                            double d = Double.valueOf(value);
                            attr.put(attri, d);
                        }
                        catch (Exception ex) {
                            attr.put(attri, value);
                        }
                    }
                    this.itemAttributes.put(key.toLowerCase(), attr);
                }
            }
            catch (Exception ex) {
                MythicMobs.error("Attributes for MythicItem " + this.internalName + " are configured incorrectly. Please see the manual for syntax.");
            }
        }
    }

    public ItemStack generateItemStack(int amount) {
        return this.generateItemStack(amount, null, null);
    }

    public ItemStack generateItemStack(int amount, LivingEntity d, LivingEntity k) {
        ItemStack stack = this.useiid ? new ItemStack(Material.getMaterial((int)this.iid), amount, (short)this.data) : new ItemStack(Material.getMaterial((String)this.id.toUpperCase()), amount, (short)this.data);
        ItemMeta im = stack.getItemMeta();
        ArrayList<String> parsedLore = new ArrayList<String>();
        for (String str : this.lore) {
            str = SkillString.parseMessageSpecialChars(str);
            if (d == null) {
                str = str.replace("$boss", "Unknown");
                str = str.replace("$mobname", "Unknown");
            } else if (d instanceof Player) {
                str = str.replace("$boss", ((Player)d).getDisplayName());
                str = str.replace("$mobname", ((Player)d).getDisplayName());
            } else if (d.getCustomName() != null) {
                str = str.replace("$boss", d.getCustomName());
                str = str.replace("$mobname", d.getCustomName());
            } else {
                str = str.replace("$boss", "Unknown");
                str = str.replace("$mobname", "Unknown");
            }
            str = k == null ? str.replace("$player", "Unknown") : (k instanceof Player ? str.replace("$player", ((Player)k).getName()) : str.replace("$player", d.getCustomName()));
            if (str.contains("{")) {
                MythicMobs.debug(3, "Found number range in item lore, parsing...");
                Matcher pMatcher = Patterns.LoreRanges.matcher(str);
                while (pMatcher.find()) {
                    int min = Integer.parseInt(pMatcher.group(1));
                    int max = Integer.parseInt(pMatcher.group(2));
                    int num = MythicMobs.r.nextInt(max - min) + min;
                    str = str.replace(pMatcher.group(0), "" + num);
                    MythicMobs.debug(3, "-- Replacing number range " + pMatcher.group(0) + " with " + num);
                }
            }
            parsedLore.add(str);
        }
        try {
            Class.forName("org.bukkit.inventory.meta.BannerMeta");
            if (im instanceof BannerMeta) {
                im = this.buildBanner(im);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (stack.getType().equals((Object)Material.SHIELD)) {
                im = this.buildShield(im);
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        if (stack.getType() == Material.POTION) {
            im = this.buildPotion(im);
        } else if (MythicMobs.inst().getMinecraftVersion() > 8 && (stack.getType() == Material.SPLASH_POTION || stack.getType() == Material.TIPPED_ARROW)) {
            im = this.buildPotion(im);
        }
        if (stack.getType().equals((Object)Material.SKULL) || stack.getType().equals((Object)Material.SKULL_ITEM)) {
            im = MythicItem.buildSkull((SkullMeta)im, this);
        }
        if (this.displayName != null) {
            im = MythicItem.setDisplay(im, this.displayName);
        }
        if (this.lore != null) {
            im = MythicItem.setLore(im, parsedLore);
        }
        if (this.hideOptions != null) {
            for (String hide : this.hideOptions) {
                ItemFlag flag = ItemFlag.valueOf((String)hide);
                im.addItemFlags(new ItemFlag[]{flag});
            }
        }
        stack.setItemMeta(im);
        if (CompatibilityManager.EnchantsPlus != null) {
            CompatibilityManager.EnchantsPlus.setEnchants(stack, this.Enchants);
        }
        if (this.Enchants != null) {
            stack = MythicItem.setEnchants(stack, this.Enchants);
        }
        if (this.color != null) {
            stack = MythicItem.setLeatherColor(stack, this);
        }
        if (MythicMobs.inst().getMinecraftVersion() >= 9) {
            stack = MythicMobs.inst().getVolatileCodeHandler().setItemAttributes(stack, this.internalName, this.itemOptions, this.itemAttributes);
        } else {
            if (this.health != 0.0) {
                stack = AttributeHandler.addHealth(this.internalName, stack, this.health);
            }
            if (this.damage > -1.0) {
                stack = AttributeHandler.addDamage(this.internalName, stack, this.damage);
            }
            if (this.speed != 0.0) {
                stack = AttributeHandler.addSpeed(this.internalName, stack, this.speed);
            }
            if (this.knock != 0.0) {
                stack = AttributeHandler.addKnockBackRes(this.internalName, stack, this.knock);
            }
            if (this.range != 0.0) {
                stack = AttributeHandler.addFollowRange(this.internalName, stack, this.range);
            }
            if (this.unbreakable) {
                stack = MythicMobs.plugin.getVolatileCodeHandler().setItemUnbreakable(stack);
            }
            if (this.hideFlags) {
                stack = MythicMobs.plugin.getVolatileCodeHandler().setItemHideFlags(stack);
            }
        }
        if (this.data != 0) {
            stack.setDurability((short)this.data);
        }
        return stack;
    }

    public static ItemStack setEnchants(ItemStack stack, List<String> enchants) {
        if (enchants == null) {
            return stack;
        }
        for (String s : enchants) {
            if (!s.contains(":")) continue;
            String[] part = s.split(":");
            if (part[0].matches("[0-9]*")) {
                if (stack.getType() != Material.ENCHANTED_BOOK) {
                    stack.addUnsafeEnchantment(Enchantment.getById((int)Integer.parseInt(part[0])), Integer.parseInt(part[1]));
                    continue;
                }
                EnchantmentStorageMeta esm = (EnchantmentStorageMeta)stack.getItemMeta();
                esm.addStoredEnchant(Enchantment.getById((int)Integer.parseInt(part[0])), Integer.parseInt(part[1]), true);
                stack.setItemMeta((ItemMeta)esm);
                continue;
            }
            Enchantment en = Enchantment.getByName((String)part[0]);
            if (en == null) continue;
            if (stack.getType() != Material.ENCHANTED_BOOK) {
                stack.addUnsafeEnchantment(en, Integer.parseInt(part[1]));
                continue;
            }
            EnchantmentStorageMeta esm = (EnchantmentStorageMeta)stack.getItemMeta();
            esm.addStoredEnchant(en, Integer.parseInt(part[1]), true);
            stack.setItemMeta((ItemMeta)esm);
        }
        return stack;
    }

    public static ItemMeta setLore(ItemMeta im, List<String> lore) {
        if (lore.size() == 0) {
            return im;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String s : lore) {
            s = ChatColor.translateAlternateColorCodes((char)'&', (String)s);
            list.add(s);
        }
        if (list != null) {
            im.setLore(list);
        }
        return im;
    }

    public ItemMeta buildPotion(ItemMeta im) {
        ((PotionMeta)im).clearCustomEffects();
        for (String s : this.potionEffects) {
            try {
                String[] sp = s.split(" ");
                if (sp.length < 3) {
                    MythicMobs.error("A potion effect for MythicItem " + this.internalName + " is configured incorrectly. Format is 'EFFECT DURATION LEVEL'. Line=" + s);
                    continue;
                }
                PotionEffectType pet = PotionEffectType.getByName((String)sp[0].toUpperCase());
                int duration = Integer.parseInt(sp[1]);
                int level = Integer.parseInt(sp[2]);
                PotionEffect p = new PotionEffect(pet, duration, level - 1, true);
                ((PotionMeta)im).addCustomEffect(p, false);
            }
            catch (Exception ex) {
                MythicMobs.error("A potion effect for MythicItem " + this.internalName + " is configured incorrectly. Format is 'EFFECT DURATION LEVEL'. Line=" + s);
            }
        }
        return im;
    }

    public ItemMeta buildBanner(ItemMeta im) {
        try {
            ((BannerMeta)im).setBaseColor(DyeColor.valueOf((String)this.color));
        }
        catch (Exception ex) {
            MythicMobs.error("The banner color for MythicItem " + this.internalName + " is configured incorrectly, must use a color from the Bukkit DyeColor ENUM.");
        }
        for (String s : this.bannerLayers) {
            try {
                String[] sp = s.split(" ");
                if (sp.length < 2) {
                    MythicMobs.error("A banner layer for MythicItem " + this.internalName + " is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s);
                    continue;
                }
                DyeColor dc = DyeColor.valueOf((String)sp[0].toUpperCase());
                PatternType pt = PatternType.valueOf((String)sp[1]);
                Pattern p = new Pattern(dc, pt);
                ((BannerMeta)im).addPattern(p);
            }
            catch (Exception ex) {
                MythicMobs.error("A banner layer for MythicItem " + this.internalName + " is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s);
            }
        }
        return im;
    }

    public ItemMeta buildShield(ItemMeta im) {
        BlockStateMeta meta = (BlockStateMeta)im;
        Banner banner = (Banner)meta.getBlockState();
        try {
            banner.setBaseColor(DyeColor.valueOf((String)this.color));
        }
        catch (Exception ex) {
            MythicMobs.error("The shield color for MythicItem " + this.internalName + " is configured incorrectly, must use a color from the Bukkit DyeColor ENUM.");
        }
        for (String s : this.bannerLayers) {
            try {
                String[] sp = s.split(" ");
                if (sp.length < 2) {
                    MythicMobs.error("A shield banner layer for MythicItem " + this.internalName + " is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s);
                    continue;
                }
                DyeColor dc = DyeColor.valueOf((String)sp[0].toUpperCase());
                PatternType pt = PatternType.valueOf((String)sp[1]);
                Pattern p = new Pattern(dc, pt);
                banner.addPattern(p);
            }
            catch (Exception ex) {
                MythicMobs.error("A shield banner layer for MythicItem " + this.internalName + " is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s);
            }
        }
        banner.update();
        meta.setBlockState((BlockState)banner);
        return meta;
    }

    public static ItemMeta setDisplay(ItemMeta im, String s) {
        s = ChatColor.translateAlternateColorCodes((char)'&', (String)s);
        im.setDisplayName(s);
        return im;
    }

    public static ItemStack setLeatherColor(ItemStack item, MythicItem mi) {
        if (item.getType().equals((Object)Material.LEATHER_CHESTPLATE) || item.getType().equals((Object)Material.LEATHER_BOOTS) || item.getType().equals((Object)Material.LEATHER_LEGGINGS) || item.getType().equals((Object)Material.LEATHER_HELMET)) {
            String[] rgb = mi.color.split(",");
            int r = Integer.parseInt(rgb[0]);
            int g = Integer.parseInt(rgb[1]);
            int b = Integer.parseInt(rgb[2]);
            ItemMeta im = item.getItemMeta();
            LeatherArmorMeta la = (LeatherArmorMeta)im;
            la.setColor(Color.fromRGB((int)r, (int)g, (int)b));
            item.setItemMeta((ItemMeta)la);
        }
        return item;
    }

    public static ItemMeta buildSkull(SkullMeta meta, MythicItem mi) {
        if (mi.player != null) {
            meta.setOwner(mi.player);
        } else if (mi.skinTexture != null) {
            GameProfile profile = new GameProfile(mi.skinUUID, null);
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", mi.skinTexture));
            Field profileField = null;
            try {
                profileField = meta.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            profileField.setAccessible(true);
            try {
                profileField.set(meta, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        } else if (mi.skinURL != null) {
            GameProfile profile = new GameProfile(UUID.randomUUID(), null);
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", Base64Coder.encodeString((String)("{textures:{SKIN:{url:\"" + mi.skinURL + "\"}}}"))));
            Field profileField = null;
            try {
                profileField = meta.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            profileField.setAccessible(true);
            try {
                profileField.set(meta, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return meta;
    }

    public static MythicItem getMythicItem(String s) {
        for (MythicItem mi : MythicMobs.plugin.listItems) {
            if (!mi.internalName.equals(s)) continue;
            return mi;
        }
        return null;
    }

    public static ItemStack getMythicItemStack(String s) {
        for (MythicItem mi : MythicMobs.plugin.listItems) {
            if (!mi.internalName.equals(s)) continue;
            return mi.generateItemStack(1);
        }
        Material m = Material.getMaterial((String)s.toUpperCase());
        if (m == null) {
            return null;
        }
        return new ItemStack(m, 1);
    }
}

