/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Drops;

import java.util.ArrayList;
import java.util.List;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Compatibility.CompatibilityManager;
import net.elseland.xikage.MythicMobs.Drops.DropHandler;
import net.elseland.xikage.MythicMobs.Drops.MythicEquipable;
import net.elseland.xikage.MythicMobs.IO.Load.Configuration;
import net.elseland.xikage.MythicMobs.Items.MythicItem;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.SConditions.SCondition;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class MythicDropTable {
    public String dtName;
    public String file;
    public List<String> conditions = new ArrayList<String>();
    public List<String> strDropItems = new ArrayList<String>();
    public List<String> strDropNonItems = new ArrayList<String>();
    private int minItems;
    private int maxItems;
    private boolean hasConditions = false;
    public int exp = 0;
    public int championsexp = 0;
    public int heroesexp = 0;
    public int skillapiexp = 0;
    public int mcmmoexp = 0;
    double money = 0.0;
    MythicDropTable perLevelTable;
    public List<ItemStack> dropsList = new ArrayList<ItemStack>();
    public List<MythicEquipable> equipablesList = new ArrayList<MythicEquipable>();
    protected boolean modExp = false;

    public MythicDropTable(List<String> strDrops, List<String> strDropsPerLevel, String name, String file, List<String> conditions) {
        this(strDrops, strDropsPerLevel, name, file, conditions, -1, -1);
    }

    public MythicDropTable(List<String> strDrops, List<String> strDropsPerLevel, String name, String file, List<String> conditions, int minItems, int maxItems) {
        this.dtName = name;
        this.dtName = name;
        this.file = file;
        if (maxItems < 0) {
            maxItems = -1;
        }
        if (minItems < 0) {
            minItems = -1;
        }
        if (minItems > maxItems) {
            minItems = maxItems;
        }
        this.minItems = minItems;
        this.maxItems = maxItems;
        this.conditions = conditions;
        if (conditions != null) {
            this.hasConditions = true;
        }
        if (strDropsPerLevel != null) {
            this.perLevelTable = new MythicDropTable(strDropsPerLevel, null, name + "PERLEVEL", null, null);
        }
        for (String s : strDrops) {
            String c = s.toLowerCase();
            if (c.startsWith("exp ") || c.startsWith("championsexp ") || c.startsWith("champions-exp ") || c.startsWith("skillapiexp ") || c.startsWith("skillapi-exp ") || c.startsWith("heroesexp ") || c.startsWith("heroes-exp ") || c.startsWith("mcmmoexp") || c.startsWith("mcmmo-exp ") || c.startsWith("money ") || c.startsWith("currency ")) {
                this.strDropNonItems.add(s);
                continue;
            }
            this.strDropItems.add(s);
        }
    }

    public void parseTable() {
        this.parseTable(null, null);
    }

    public void parseTable(ActiveMob dropper) {
        this.parseTable(dropper, null);
    }

    public MythicDropTable add(ActiveMob am, MythicDropTable dt) {
        dt.parseTable(am);
        this.dropsList.addAll(dt.getDrops());
        this.money += dt.getMoney();
        this.exp += dt.getExp();
        this.championsexp += dt.getChampionsExp();
        this.heroesexp += dt.getHeroesExp();
        this.skillapiexp += dt.getSkillAPIExp();
        this.mcmmoexp += dt.getMcMMOExp();
        return this;
    }

    public void parseTable(ActiveMob dropper, AbstractEntity killer) {
        String[] split;
        this.dropsList.clear();
        this.equipablesList.clear();
        this.money = 0.0;
        this.exp = 0;
        this.championsexp = 0;
        this.heroesexp = 0;
        this.skillapiexp = 0;
        this.mcmmoexp = 0;
        this.modExp = false;
        int items = this.maxItems > this.minItems ? this.minItems + MythicMobs.r.nextInt(this.maxItems - this.minItems) : this.minItems;
        if (dropper.getLevel() > 1 && this.perLevelTable != null) {
            for (int i = 1; i < dropper.getLevel(); ++i) {
                this.add(dropper, this.perLevelTable);
            }
        }
        if (this.hasConditions) {
            for (String strCondition : this.conditions) {
                split = strCondition.split(" ");
                String conditionData = null;
                if (split.length > 1) {
                    conditionData = split[1];
                }
                if (SCondition.getSpawningConditionByName(split[0]).check(BukkitAdapter.adapt(dropper.getLocation()), (LivingEntity)BukkitAdapter.adapt(dropper.getEntity()), conditionData)) continue;
                return;
            }
        }
        for (String s : this.strDropNonItems) {
            MythicMobs.debug(2, "Parsing Drop Table entry: " + s);
            try {
                if (s.contains("champions-exp")) {
                    MythicMobs.debug(2, "-- Found Champions Experience!");
                    split = s.split(" ");
                    this.championsexp = (int)((double)this.championsexp + DropHandler.parseAmount(split[1]));
                    continue;
                }
                if (s.contains("skillapi-exp")) {
                    MythicMobs.debug(2, "-- Found SkillAPI Experience!");
                    split = s.split(" ");
                    this.skillapiexp = (int)((double)this.skillapiexp + DropHandler.parseAmount(split[1]));
                    continue;
                }
                if (s.contains("heroesexp") || s.contains("heroes-exp")) {
                    MythicMobs.debug(2, "-- Found Heroes Experience!");
                    split = s.split(" ");
                    this.heroesexp = (int)((double)this.heroesexp + DropHandler.parseAmount(split[1]));
                    continue;
                }
                if (s.contains("mcmmo-exp")) {
                    MythicMobs.debug(2, "-- Found mcMMO Experience!");
                    split = s.split(" ");
                    this.mcmmoexp = (int)((double)this.mcmmoexp + DropHandler.parseAmount(split[1]));
                    continue;
                }
                if (s.contains("exp")) {
                    MythicMobs.debug(2, "-- Found Experience!");
                    split = s.split(" ");
                    this.exp = (int)((double)this.exp + DropHandler.parseAmount(split[1]));
                    continue;
                }
                if (!s.contains("money")) continue;
                MythicMobs.debug(2, "-- Found Money!");
                split = s.split(" ");
                this.money += DropHandler.parseAmount(split[1]);
            }
            catch (Exception e) {
                MythicMobs.error("An error occured while parsing a drop table. Enable debugging for a stack trace.");
                MythicMobs.debug(1, "== Error occured during parsing of following drop table string: " + s);
                if (Configuration.debugLevel <= 0) continue;
                e.printStackTrace();
            }
        }
        int ia = 0;
        block7: do {
            for (String s : this.strDropItems) {
                MythicMobs.debug(2, "Parsing Drop Table entry: " + s);
                if (items >= 0 && ia >= items) {
                    MythicMobs.debug(2, "-- Reached item budget, stopping parsing (items=" + items + ")");
                    continue block7;
                }
                try {
                    ItemStack is;
                    int amount;
                    String[] split2;
                    if (s.contains("phatloot")) {
                        MythicMobs.debug(2, "-- Found PhatLoot!");
                        split2 = s.split(" ");
                        amount = 1;
                        float chance = 1.0f;
                        if (split2.length > 2) {
                            amount = (int)DropHandler.parseAmount(split2[2]);
                        }
                        if (split2.length > 3) {
                            chance = Float.parseFloat(split2[3]);
                            if (MythicMobs.r.nextFloat() < chance) continue;
                        }
                        ++ia;
                        if (CompatibilityManager.PhatLoots == null) continue;
                        for (int i = 0; i < amount; ++i) {
                            if (!CompatibilityManager.PhatLoots.generateBundle(split2[1])) continue;
                            this.dropsList.addAll(CompatibilityManager.PhatLoots.getLootBundleItems());
                            this.exp += CompatibilityManager.PhatLoots.getLootBundleXP();
                            this.money += CompatibilityManager.PhatLoots.getLootBundleMoney();
                        }
                        continue;
                    }
                    if (s.contains("mythicdrop")) {
                        MythicMobs.debug(2, "-- Found MythicDrop!");
                        split2 = s.split(" ");
                        amount = 1;
                        double chance = 1.0;
                        if (split2.length > 2) {
                            amount = (int)DropHandler.parseAmount(split2[2]);
                        }
                        if (split2.length > 3) {
                            chance = Double.parseDouble(split2[3]);
                            if (MythicMobs.r.nextDouble() < chance) continue;
                        }
                        ++ia;
                        if (CompatibilityManager.MythicDrops != null) {
                            for (int i = 0; i < amount; ++i) {
                                ItemStack md;
                                if (split2.length > 1) {
                                    md = CompatibilityManager.MythicDrops.getTierLoot(split2[1]);
                                    if (md == null) continue;
                                    this.dropsList.add(md);
                                    continue;
                                }
                                md = CompatibilityManager.MythicDrops.getLoot();
                                if (md == null) continue;
                                this.dropsList.add(md);
                            }
                        }
                        if (CompatibilityManager.PhatLoots == null || !CompatibilityManager.PhatLoots.generateBundle(split2[1])) continue;
                        this.dropsList.addAll(CompatibilityManager.PhatLoots.getLootBundleItems());
                        this.exp += CompatibilityManager.PhatLoots.getLootBundleXP();
                        this.money += CompatibilityManager.PhatLoots.getLootBundleMoney();
                        continue;
                    }
                    MythicMobs.debug(2, "-- Nothing special found, checking for Mythic things...");
                    String[] part = s.split(" ");
                    amount = 1;
                    float chance = 1.0f;
                    if (part.length > 1) {
                        if (part[1].contains("-")) {
                            String[] range = part[1].split("-");
                            int min = Integer.parseInt(range[0]);
                            int max = Integer.parseInt(range[1]);
                            amount = MythicMobs.r.nextInt(max - min) + min;
                        } else if (part[1].matches("[0-9]*")) {
                            amount = Integer.parseInt(part[1]);
                        }
                    }
                    if (part.length > 2 && part[2].matches("[0-9]*[.]?[0-9]+")) {
                        chance = Float.parseFloat(part[2]);
                    }
                    if (MythicMobs.r.nextFloat() > chance) {
                        MythicMobs.debug(2, "-- Chance failed! Skipping item.");
                        continue;
                    }
                    ++ia;
                    MythicDropTable dt = DropHandler.getMythicDropTable(s);
                    if (dt != null) {
                        MythicMobs.debug(1, "Found MythicDropTable " + s + "!");
                        this.add(dropper, dt);
                        continue;
                    }
                    String[] split3 = part[0].split(":");
                    short data = 0;
                    if (split3.length > 1 && split3[1].matches("\\d+")) {
                        data = Short.parseShort(split3[1]);
                    }
                    short slot = data;
                    MythicItem mi = MythicItem.getMythicItem(split3[0]);
                    if (mi != null) {
                        MythicMobs.debug(1, "Found MythicItem " + split3[0] + ", equipping to slot" + slot);
                        ItemStack is2 = mi.generateItemStack(amount, (LivingEntity)BukkitAdapter.adapt(dropper.getEntity()), (LivingEntity)BukkitAdapter.adapt(killer));
                        this.dropsList.add(is2);
                        this.equipablesList.add(new MythicEquipable(is2, data));
                        continue;
                    }
                    MythicMobs.debug(2, "-- No MythicItem found, parsing as regular Minecraft item...");
                    String id = split3[0];
                    if (split3.length > 2 && split3[2].matches("\\d+")) {
                        slot = Short.parseShort(split3[2]);
                    }
                    if (id.matches("\\d+")) {
                        MythicMobs.debug(3, "---- Matched Minecraft item ID");
                        int iid = Integer.parseInt(id);
                        is = new ItemStack(Material.getMaterial((int)iid), amount, data);
                        this.dropsList.add(is);
                        this.equipablesList.add(new MythicEquipable(is, slot));
                        continue;
                    }
                    MythicMobs.debug(3, "---- Matched Minecraft item name");
                    Material mat = Material.getMaterial((String)id.toUpperCase());
                    if (mat == null) {
                        MythicMobs.error("Error in DropTable '" + this.dtName + "': Item " + id + " is not a valid material type!");
                        continue;
                    }
                    is = new ItemStack(Material.getMaterial((String)id.toUpperCase()), amount, data);
                    this.dropsList.add(is);
                    this.equipablesList.add(new MythicEquipable(is, slot));
                }
                catch (Exception e) {
                    ++ia;
                    MythicMobs.error("An error occured while parsing a drop table. Enable debugging for a stack trace.");
                    MythicMobs.debug(1, "== Error occured during parsing of following drop table string: " + s);
                    if (Configuration.debugLevel <= 0) continue;
                    e.printStackTrace();
                }
            }
        } while (ia < items && items >= 0);
    }

    public List<ItemStack> getDrops() {
        return this.dropsList;
    }

    public int getExp() {
        return this.exp;
    }

    public void setExp(int exp) {
        this.exp = exp;
    }

    public int getChampionsExp() {
        return this.championsexp;
    }

    public void setChampionsExp(int exp) {
        this.championsexp = exp;
    }

    public boolean modifiesExperience() {
        return this.exp > 0;
    }

    public int getHeroesExp() {
        return this.heroesexp;
    }

    public void setHeroesExp(int exp) {
        this.heroesexp = exp;
    }

    public int getSkillAPIExp() {
        return this.skillapiexp;
    }

    public void setSkillAPIExp(int exp) {
        this.skillapiexp = exp;
    }

    public double getMoney() {
        return this.money;
    }

    public void setMoney(double money) {
        this.money = money;
    }

    public int getMcMMOExp() {
        return this.mcmmoexp;
    }

    public void setMcMMOExp(int exp) {
        this.mcmmoexp = exp;
    }

    public boolean hasConditions() {
        return this.hasConditions;
    }
}

