/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Compatibility;

import me.xhawk87.LanguageAPI.ISOCode;
import me.xhawk87.LanguageAPI.PluginLanguageLibrary;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class LanguageAPISupport {
    private Plugin plugin;
    private Object langObj;

    public LanguageAPISupport(Plugin plugin, String code) {
        this.plugin = plugin;
        if (Bukkit.getPluginManager().getPlugin("LanguageAPI") != null) {
            this.langObj = new PluginLanguageLibrary(this.plugin, ISOCode.findMatch((String)code));
        }
    }

    public String get(CommandSender forWhom, String key, String template, Object ... params) {
        if (this.langObj != null) {
            PluginLanguageLibrary language = (PluginLanguageLibrary)this.langObj;
            return language.get(forWhom, key, template, params);
        }
        return LanguageAPISupport.compile(template, params);
    }

    public String get(ISOCode preferredLocale, String key, String template, Object ... params) {
        if (this.langObj != null) {
            PluginLanguageLibrary language = (PluginLanguageLibrary)this.langObj;
            return language.get(preferredLocale, key, template, params);
        }
        return LanguageAPISupport.compile(template, params);
    }

    private static String compile(String template, Object[] params) throws IllegalArgumentException {
        if (params.length == 0) {
            return template;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            if (c == '{') {
                try {
                    int endIndex = template.indexOf(125, i);
                    if (endIndex != -1) {
                        int param = Integer.parseInt(template.substring(i + 1, endIndex));
                        if (param >= params.length) {
                            throw new IllegalArgumentException();
                        }
                        sb.append(params[param].toString());
                        i = endIndex;
                        continue;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

