/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events;

import java.util.Collection;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.Mobs.Entities.MythicCreeper;
import net.elseland.xikage.MythicMobs.Mobs.Entities.MythicTNT;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.QueuedMobSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillTrigger;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.potion.PotionEffect;

public class MobExplodeListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityExplode(EntityExplodeEvent e) {
        MythicMobs.debug(3, "EntityExplodeEvent fired");
        if (e.getEntity() == null) {
            return;
        }
        if (MythicMobs.inst().getMobManager().isActiveMob(e.getEntity().getUniqueId())) {
            MythicMobs.debug(2, "MythicMob exploded!");
            ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt(e.getEntity()));
            if (am.getType().getMythicEntity() instanceof MythicCreeper) {
                MythicMobs.debug(2, "-- Mob type was MythicCreeper");
                LivingEntity l = (LivingEntity)e.getEntity();
                if (((MythicCreeper)am.getType().getMythicEntity()).preventSuicide()) {
                    MythicMobs.debug(2, "-- MythicCreeper has preventSuicide == true, cloning creeper...");
                    LivingEntity ll = (LivingEntity)am.getType().spawn(am.getEntity().getLocation(), am.getLevel());
                    ll.setMaxHealth(l.getMaxHealth());
                    ll.setHealth(l.getHealth());
                    if (l.getPassenger() != null) {
                        ll.setPassenger(l.getPassenger());
                    }
                    if (l.getVehicle() != null) {
                        l.getVehicle().setPassenger((Entity)ll);
                    }
                    Collection pe = l.getActivePotionEffects();
                    for (PotionEffect p : pe) {
                        ll.addPotionEffect(p);
                    }
                    ActiveMob am2 = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)ll));
                    if (am2 == null) {
                        MythicMobs.debug(2, "-- Something prevented Creeper from cloning! PreventSuicide failed :(");
                        return;
                    }
                    am2.setStance(am.getStance());
                    am2.importPlayerKills(am.getPlayerKills());
                    am2.importThreatTable(am.getThreatTable());
                    new QueuedMobSkill(SkillTrigger.EXPLODE, am, null);
                } else {
                    new QueuedMobSkill(SkillTrigger.EXPLODE, am, null);
                }
            } else if (am.getType().getMythicEntity() instanceof MythicTNT) {
                new QueuedMobSkill(SkillTrigger.EXPLODE, am, null);
                am.setDead();
                MythicMobs.inst().getMobManager().unregisterActiveMob(am);
            }
        }
    }
}

