/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Adapters.Bukkit;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.elseland.xikage.MythicMobs.Adapters.AbstractBiome;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.AbstractPlayer;
import net.elseland.xikage.MythicMobs.Adapters.AbstractWorld;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitEntity;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class BukkitWorld
implements AbstractWorld {
    private WeakReference<World> worldRef;
    private final String name;
    private static final Map<Integer, Effect> effects = new HashMap<Integer, Effect>();

    public BukkitWorld(World w) {
        this.worldRef = new WeakReference<World>(w);
        this.name = w.getName();
    }

    public World getBukkitWorld() {
        if (this.worldRef.get() == null) {
            if (Bukkit.getWorld((String)this.name) != null) {
                this.worldRef = new WeakReference<World>(Bukkit.getWorld((String)this.name));
            } else {
                return null;
            }
        }
        return (World)this.worldRef.get();
    }

    @Override
    public List<AbstractEntity> getLivingEntities() {
        ArrayList<AbstractEntity> wl = new ArrayList<AbstractEntity>();
        if (this.getBukkitWorld() == null) {
            return wl;
        }
        for (LivingEntity e : this.getBukkitWorld().getLivingEntities()) {
            wl.add(new BukkitEntity((Entity)e));
        }
        return wl;
    }

    @Override
    public String getName() {
        if (this.getBukkitWorld() == null) {
            return this.name;
        }
        return this.getBukkitWorld().getName();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof BukkitWorld) {
            if (((BukkitWorld)other).getBukkitWorld() == null) {
                return false;
            }
            return ((BukkitWorld)other).getBukkitWorld().equals(this.getBukkitWorld());
        }
        if (other instanceof AbstractWorld) {
            return ((AbstractWorld)other).getName().equals(this.getName());
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        if (this.getBukkitWorld() == null) {
            return -1;
        }
        return this.getBukkitWorld().hashCode();
    }

    public int getMaxY() {
        return this.getBukkitWorld().getMaxHeight() - 1;
    }

    @Override
    public void createExplosion(AbstractLocation l, float f) {
        if (this.getBukkitWorld() == null) {
            return;
        }
        this.getBukkitWorld().createExplosion(BukkitAdapter.adapt(l), f);
    }

    @Override
    public void createExplosion(AbstractLocation l, float yield, boolean fire, boolean blockdamage) {
        if (this.getBukkitWorld() == null) {
            return;
        }
        this.getBukkitWorld().createExplosion(l.getX(), l.getY(), l.getZ(), yield, fire, blockdamage);
    }

    @Override
    public List<AbstractPlayer> getPlayers() {
        ArrayList<AbstractPlayer> pl = new ArrayList<AbstractPlayer>();
        for (Player p : this.getBukkitWorld().getPlayers()) {
            pl.add(BukkitAdapter.adapt(p));
        }
        return pl;
    }

    @Override
    public void setStorm(boolean b) {
        this.getBukkitWorld().setStorm(b);
    }

    @Override
    public void setThundering(boolean b) {
        this.getBukkitWorld().setThundering(b);
    }

    @Override
    public void setWeatherDuration(int duration) {
        this.getBukkitWorld().setWeatherDuration(duration);
    }

    @Override
    public boolean playEffect(AbstractLocation location, int type) {
        return this.playEffect(location, type, 0);
    }

    @Override
    public boolean playEffect(AbstractLocation location, int type, int data) {
        World world = this.getBukkitWorld();
        Effect effect = effects.get(type);
        if (effect == null) {
            return false;
        }
        world.playEffect(BukkitAdapter.adapt(location), effect, data);
        return true;
    }

    @Override
    public int getBlockLightLevel(AbstractLocation l) {
        return this.getBukkitWorld().getBlockAt(l.getBlockX(), l.getBlockY(), l.getBlockZ()).getLightLevel();
    }

    @Override
    public AbstractLocation getSpawnLocation() {
        if (this.getBukkitWorld() == null) {
            return null;
        }
        return BukkitAdapter.adapt(this.getBukkitWorld().getSpawnLocation());
    }

    @Override
    public boolean isLocationLoaded(AbstractLocation abstractLocation) {
        if (this.getBukkitWorld() == null) {
            return false;
        }
        Location loc = BukkitAdapter.adapt(abstractLocation);
        Chunk c = loc.getChunk();
        if (c == null) {
            return false;
        }
        return c.isLoaded();
    }

    @Override
    public List<AbstractPlayer> getPlayersNearLocation(AbstractLocation location, int radius) {
        ArrayList<AbstractPlayer> pl = new ArrayList<AbstractPlayer>();
        Location l = BukkitAdapter.adapt(location);
        for (Player p : this.getBukkitWorld().getPlayers()) {
            if (p.getLocation().distanceSquared(l) <= Math.pow(radius, 2.0)) {
                // empty if block
            }
            pl.add(BukkitAdapter.adapt(p));
        }
        return pl;
    }

    @Override
    public AbstractBiome getLocationBiome(AbstractLocation abstractLocation) {
        Location l = BukkitAdapter.adapt(abstractLocation);
        return BukkitAdapter.adapt(l.getBlock().getBiome());
    }

    static {
        for (Effect effect : Effect.values()) {
            effects.put(effect.getId(), effect);
        }
    }
}

