/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Adapters.Bukkit;

import java.util.UUID;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.AbstractPlayer;
import net.elseland.xikage.MythicMobs.Adapters.AbstractWorld;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitPlayer;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Flying;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.WaterMob;
import org.bukkit.potion.PotionEffect;

public class BukkitEntity
implements AbstractEntity {
    private final Entity entityRef;

    public BukkitEntity(Entity e) {
        this.entityRef = e;
    }

    @Override
    public Entity getBukkitEntity() {
        Entity entity = this.entityRef;
        if (entity != null) {
            return entity;
        }
        return null;
    }

    public LivingEntity getEntityAsLiving() {
        return (LivingEntity)this.getBukkitEntity();
    }

    public Creature getEntityAsCreature() {
        return (Creature)this.getBukkitEntity();
    }

    public Player getEntityAsPlayer() {
        return (Player)this.getBukkitEntity();
    }

    @Override
    public AbstractLocation getLocation() {
        return BukkitAdapter.adapt(this.getBukkitEntity().getLocation());
    }

    @Override
    public AbstractWorld getWorld() {
        return this.getLocation().getWorld();
    }

    @Override
    public boolean isLiving() {
        return this.getBukkitEntity() instanceof LivingEntity;
    }

    @Override
    public boolean isCreature() {
        return this.getBukkitEntity() instanceof Creature;
    }

    @Override
    public boolean isMonster() {
        return this.getBukkitEntity() instanceof Monster;
    }

    @Override
    public boolean isPlayer() {
        return this.getBukkitEntity() instanceof Player;
    }

    @Override
    public UUID getUniqueId() {
        return this.getBukkitEntity().getUniqueId();
    }

    @Override
    public boolean hasLineOfSight(AbstractEntity e) {
        return ((LivingEntity)this.getBukkitEntity()).hasLineOfSight(e.getBukkitEntity());
    }

    @Override
    public void teleport(AbstractLocation l) {
        this.getBukkitEntity().teleport(BukkitAdapter.adapt(l));
    }

    @Override
    public double getHealth() {
        return this.getEntityAsLiving().getHealth();
    }

    @Override
    public boolean isDead() {
        return this.getBukkitEntity().isDead();
    }

    @Override
    public boolean isValid() {
        return this.getBukkitEntity().isValid();
    }

    @Override
    public boolean remove() {
        Entity entity = this.entityRef;
        if (entity != null) {
            entity.remove();
            return entity.isDead();
        }
        return true;
    }

    @Override
    public double getMaxHealth() {
        return this.getEntityAsLiving().getMaxHealth();
    }

    @Override
    public void setFireTicks(int ticks) {
        this.getBukkitEntity().setFireTicks(ticks);
    }

    @Override
    public String getCustomName() {
        return this.getEntityAsLiving().getCustomName();
    }

    @Override
    public void addPotionEffect(PotionEffect effect) {
        this.getEntityAsLiving().addPotionEffect(effect);
    }

    @Override
    public void setPassenger(Entity entity) {
        this.getBukkitEntity().setPassenger(entity);
    }

    @Override
    public Location getEyeLocation() {
        if (this.isLiving()) {
            return this.getEntityAsLiving().getEyeLocation();
        }
        return this.getBukkitEntity().getLocation();
    }

    @Override
    public double getEyeHeight() {
        if (this.isLiving()) {
            return this.getEntityAsLiving().getEyeHeight();
        }
        return 0.0;
    }

    @Override
    public AbstractEntity getTarget() {
        if (this.isCreature()) {
            return BukkitAdapter.adapt((Entity)this.getEntityAsCreature().getTarget());
        }
        if (this.getBukkitEntity().getLastDamageCause() != null) {
            return BukkitAdapter.adapt(this.getBukkitEntity().getLastDamageCause().getEntity());
        }
        return null;
    }

    @Override
    public AbstractEntity getVehicle() {
        Entity e = this.getBukkitEntity().getVehicle();
        if (e != null) {
            return BukkitAdapter.adapt(e);
        }
        return null;
    }

    @Override
    public void eject() {
        this.getBukkitEntity().eject();
    }

    @Override
    public void setHealth(double d) {
        Entity e = this.getBukkitEntity();
        if (e instanceof LivingEntity) {
            ((LivingEntity)e).setHealth(d);
        }
    }

    public void setDamage(double d) {
        this.getEntityAsLiving().getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(d);
    }

    @Override
    public String getName() {
        if (this.isPlayer()) {
            return this.getEntityAsPlayer().getName();
        }
        return this.getBukkitEntity().getCustomName();
    }

    @Override
    public void setMaxHealth(double health) {
        this.getEntityAsLiving().setMaxHealth(health);
    }

    @Override
    public void damage(float damage) {
        this.getEntityAsLiving().damage((double)damage);
    }

    @Override
    public void setPassenger(AbstractEntity entity) {
        this.getBukkitEntity().setPassenger(BukkitAdapter.adapt(entity));
    }

    @Override
    public AbstractPlayer asPlayer() {
        if (this.getBukkitEntity() instanceof Player) {
            return new BukkitPlayer(this.getEntityAsPlayer());
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof BukkitEntity) {
            return this.getUniqueId().equals(((BukkitEntity)o).getUniqueId());
        }
        return super.equals(o);
    }

    public int hashCode() {
        return this.getBukkitEntity().getUniqueId().hashCode();
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        if (this.isLiving()) {
            ((LivingEntity)this.getBukkitEntity()).setNoDamageTicks(ticks);
        }
    }

    @Override
    public boolean isCitizensNPC() {
        return this.getBukkitEntity().hasMetadata("NPC");
    }

    @Override
    public boolean isAnimal() {
        return this.getBukkitEntity() instanceof Animals;
    }

    @Override
    public boolean isWaterMob() {
        return this.getBukkitEntity() instanceof WaterMob;
    }

    @Override
    public boolean isFlyingMob() {
        return this.getBukkitEntity() instanceof Flying;
    }
}

