/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Adapters.Bukkit;

import java.util.HashMap;
import net.elseland.xikage.MythicMobs.Adapters.AbstractBiome;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.AbstractPlayer;
import net.elseland.xikage.MythicMobs.Adapters.AbstractWorld;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitEntity;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitPlayer;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitWorld;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public final class BukkitAdapter {
    HashMap<Entity, AbstractEntity> cachedEntities = new HashMap();

    public static AbstractEntity adapt(Entity e) {
        if (e == null) {
            return null;
        }
        return new BukkitEntity(e);
    }

    public static Entity adapt(AbstractEntity e) {
        if (e == null) {
            return null;
        }
        return e.getBukkitEntity();
    }

    public static AbstractPlayer adapt(Player p) {
        if (p == null) {
            return null;
        }
        return new BukkitPlayer(p);
    }

    public static AbstractWorld adapt(World w) {
        return new BukkitWorld(w);
    }

    public static World adapt(AbstractWorld world) {
        if (world instanceof BukkitWorld) {
            return ((BukkitWorld)world).getBukkitWorld();
        }
        World match = Bukkit.getServer().getWorld(world.getName());
        if (match != null) {
            return match;
        }
        throw new IllegalArgumentException("Can't find a Bukkit world for " + world);
    }

    public static AbstractLocation adapt(Location l) {
        if (l == null) {
            return null;
        }
        return new AbstractLocation(BukkitAdapter.adapt(l.getWorld()), l.getX(), l.getY(), l.getZ(), l.getYaw(), l.getPitch());
    }

    public static Location adapt(AbstractLocation location) {
        return new Location(BukkitAdapter.adapt(location.getWorld()), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static AbstractBiome adapt(Biome b) {
        if (b == null) {
            return null;
        }
        return new AbstractBiome(b.toString());
    }
}

