/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.util;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class MythicUtil {
    public static final float DEGTORAD = (float)Math.PI / 180;
    public static final float RADTODEG = 57.29578f;

    public static boolean matchNumber(String s, double i) {
        if (s == null) {
            return false;
        }
        try {
            s = s.replace(" ", "");
            if (s.contains("=")) {
                double d = Double.parseDouble(s.substring(1));
                if (i == d) {
                    return true;
                }
            } else if (s.contains(">")) {
                double d = Double.parseDouble(s.substring(1));
                if (i > d) {
                    return true;
                }
            } else if (s.contains("<")) {
                double d = Double.parseDouble(s.substring(1));
                if (i < d) {
                    return true;
                }
            } else if (s.contains("-")) {
                String[] split = s.split("-");
                double d1 = Double.parseDouble(split[0]);
                double d2 = Double.parseDouble(split[1]);
                if (i >= d1 && i <= d2) {
                    return true;
                }
            } else {
                double d = Double.parseDouble(s);
                if (i == d) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Object getPrivateField(String fieldName, Class clazz, Object object) {
        Object o = null;
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            o = field.get(object);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return o;
    }

    public static void setPrivateField(String fieldName, Class clazz, Object object, Object value) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static LivingEntity getTargetedEntity(Player player) {
        BlockIterator bi;
        int range = 32;
        List ne = player.getNearbyEntities((double)range, (double)range, (double)range);
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        for (Entity en : ne) {
            if (!(en instanceof LivingEntity)) continue;
            entities.add((LivingEntity)en);
        }
        LivingEntity target = null;
        try {
            bi = new BlockIterator((LivingEntity)player, range);
        }
        catch (IllegalStateException e) {
            return null;
        }
        while (bi.hasNext()) {
            Block b = bi.next();
            int bx = b.getX();
            int by = b.getY();
            int bz = b.getZ();
            if (!b.getType().isTransparent()) break;
            for (LivingEntity e : entities) {
                Location l = e.getLocation();
                double ex = l.getX();
                double ey = l.getY();
                double ez = l.getZ();
                if (!((double)bx - 0.75 <= ex) || !(ex <= (double)bx + 1.75) || !((double)bz - 0.75 <= ez) || !(ez <= (double)bz + 1.75) || !((double)(by - 1) <= ey) || !(ey <= (double)by + 2.5)) continue;
                target = e;
                if (target != null && target instanceof Player && ((Player)target).getGameMode() == GameMode.CREATIVE) {
                    target = null;
                    continue;
                }
                return target;
            }
        }
        return null;
    }

    public static void sendFakeBlockChange(Player player, Block block, Material mat) {
    }

    public static void restoreFakeBlockChange(Player player, Block block) {
    }

    public static void rotateVector(Vector v, float degrees) {
        double rad = Math.toRadians(degrees);
        double sin = Math.sin(rad);
        double cos = Math.cos(rad);
        double x = v.getX() * cos - v.getZ() * sin;
        double z = v.getX() * sin + v.getZ() * cos;
        v.setX(x);
        v.setZ(z);
    }

    public static Double calculateLaunchAngle(Location from, Location to, double v, double elevation, double g) {
        double check;
        Vector vector = from.clone().subtract(to).toVector();
        Double distance = Math.sqrt(Math.pow(vector.getX(), 2.0) + Math.pow(vector.getZ(), 2.0));
        double v2 = Math.pow(v, 2.0);
        double v4 = Math.pow(v, 4.0);
        if (v4 < (check = g * (g * Math.pow(distance, 2.0) + 2.0 * elevation * v2))) {
            return null;
        }
        return Math.atan((v2 - Math.sqrt(v4 - check)) / (g * distance));
    }

    public static double calculateHangtime(double launchAngle, double v, double elev, double g) {
        double a = v * Math.sin(launchAngle);
        double b = -2.0 * g * elev;
        if (Math.pow(a, 2.0) + b < 0.0) {
            return 0.0;
        }
        return (a + Math.sqrt(Math.pow(a, 2.0) + b)) / g;
    }

    public static Vector normalizeVector(Vector victor) {
        double mag = Math.sqrt(Math.pow(victor.getX(), 2.0) + Math.pow(victor.getY(), 2.0) + Math.pow(victor.getZ(), 2.0));
        if (mag != 0.0) {
            return victor.multiply(1.0 / mag);
        }
        return victor.multiply(0);
    }

    public static Location moveBukkit(Location loc, Vector offset) {
        return MythicUtil.moveBukkit(loc, offset.getX(), offset.getY(), offset.getZ());
    }

    public static Location moveBukkit(Location loc, double dx, double dy, double dz) {
        Vector off = MythicUtil.rotateBukkit(loc.getYaw(), loc.getPitch(), dx, dy, dz);
        double x = loc.getX() + off.getX();
        double y = loc.getY() + off.getY();
        double z = loc.getZ() + off.getZ();
        return new Location(loc.getWorld(), x, y, z, loc.getYaw(), loc.getPitch());
    }

    public static Vector rotateBukkit(float yaw, float pitch, Vector value) {
        return MythicUtil.rotateBukkit(yaw, pitch, value.getX(), value.getY(), value.getZ());
    }

    public static Vector rotateBukkit(float yaw, float pitch, double x, double y, double z) {
        float angle = yaw * ((float)Math.PI / 180);
        double sinyaw = Math.sin(angle);
        double cosyaw = Math.cos(angle);
        angle = pitch * ((float)Math.PI / 180);
        double sinpitch = Math.sin(angle);
        double cospitch = Math.cos(angle);
        double newx = 0.0;
        double newy = 0.0;
        double newz = 0.0;
        newz -= x * cosyaw;
        newz -= y * sinyaw * sinpitch;
        newx += x * sinyaw;
        newx -= y * cosyaw * sinpitch;
        newy += y * cospitch;
        return new Vector(newx -= z * cosyaw * cospitch, newy -= z * sinpitch, newz -= z * sinyaw * cospitch);
    }

    public static AbstractLocation move(AbstractLocation loc, AbstractVector offset) {
        return MythicUtil.move(loc, offset.getX(), offset.getY(), offset.getZ());
    }

    public static AbstractLocation move(AbstractLocation loc, double dx, double dy, double dz) {
        AbstractVector off = MythicUtil.rotate(loc.getYaw(), loc.getPitch(), dx, dy, dz);
        double x = loc.getX() + off.getX();
        double y = loc.getY() + off.getY();
        double z = loc.getZ() + off.getZ();
        return new AbstractLocation(loc.getWorld(), x, y, z, loc.getYaw(), loc.getPitch());
    }

    public static AbstractVector rotate(float yaw, float pitch, AbstractVector value) {
        return MythicUtil.rotate(yaw, pitch, value.getX(), value.getY(), value.getZ());
    }

    public static AbstractVector rotate(float yaw, float pitch, double x, double y, double z) {
        float angle = yaw * ((float)Math.PI / 180);
        double sinyaw = Math.sin(angle);
        double cosyaw = Math.cos(angle);
        angle = pitch * ((float)Math.PI / 180);
        double sinpitch = Math.sin(angle);
        double cospitch = Math.cos(angle);
        double newx = 0.0;
        double newy = 0.0;
        double newz = 0.0;
        newz -= x * cosyaw;
        newz -= y * sinyaw * sinpitch;
        newx += x * sinyaw;
        newx -= y * cosyaw * sinpitch;
        newy += y * cospitch;
        return new AbstractVector(newx -= z * cosyaw * cospitch, newy -= z * sinpitch, newz -= z * sinyaw * cospitch);
    }

    public static UUID getUUIDFromString(String s) {
        String md5 = MythicUtil.getMD5(s);
        String uuid = md5.substring(0, 8) + "-" + md5.substring(8, 12) + "-" + md5.substring(12, 16) + "-" + md5.substring(16, 20) + "-" + md5.substring(20);
        return UUID.fromString(uuid);
    }

    public static String getMD5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            BigInteger number = new BigInteger(1, messageDigest);
            String hashtext = number.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

