/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.spawning.spawners;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.IOHandler;
import io.lumine.xikage.mythicmobs.io.IOLoader;
import io.lumine.xikage.mythicmobs.legacy.conditions.SCondition;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.spawning.spawners.MythicSpawner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.LivingEntity;

public class SpawnerManager {
    private final MythicMobs core;
    private List<File> spawnerFiles;
    private List<IOLoader<MythicMobs>> spawnerLoaders;
    public List<MythicSpawner> listSpawners = new ArrayList<MythicSpawner>();
    public ConcurrentHashMap<AbstractLocation, MythicSpawner> mmBreakableSpawners = new ConcurrentHashMap();
    public ConcurrentHashMap<String, HashSet<MythicSpawner>> mmChunkSpawnerLookup = new ConcurrentHashMap();
    public ConcurrentHashMap<Integer, MythicSpawner> mmSpawnerHashcodeLookup = new ConcurrentHashMap();
    private List<Runnable> secondPass = new ArrayList<Runnable>();

    public SpawnerManager(MythicMobs core) {
        this.core = core;
    }

    public void loadSpawners() {
        File spawnerFile = new File(MythicMobs.inst().getDataFolder() + System.getProperty("file.separator") + "Spawners");
        if (!spawnerFile.exists()) {
            MythicMobs.log("Spawners folder not found! Creating...");
            spawnerFile.mkdir();
        }
        this.spawnerFiles = IOHandler.getAllFiles(MythicMobs.inst().getDataFolder() + System.getProperty("file.separator") + "Spawners");
        this.spawnerLoaders = IOHandler.getSaveLoad(MythicMobs.inst(), this.spawnerFiles, "Spawners");
        this.listSpawners.clear();
        this.mmSpawnerHashcodeLookup.clear();
        this.mmChunkSpawnerLookup.clear();
        this.mmBreakableSpawners.clear();
        for (IOLoader<MythicMobs> sl : this.spawnerLoaders) {
            for (String s : sl.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                if (sl.getCustomConfig().getStringList(s + ".MobName") == null) continue;
                try {
                    String sName = s;
                    String sGroup = sl.getCustomConfig().getString(s + ".SpawnerGroup");
                    String sMob = sl.getCustomConfig().getString(s + ".MobName");
                    String world = sl.getCustomConfig().getString(s + ".World");
                    int x = sl.getCustomConfig().getInt(s + ".X");
                    int y = sl.getCustomConfig().getInt(s + ".Y");
                    int z = sl.getCustomConfig().getInt(s + ".Z");
                    int radius = sl.getCustomConfig().getInt(s + ".Radius", 0);
                    int radiusY = sl.getCustomConfig().getInt(s + ".RadiusY", 0);
                    boolean usetimer = sl.getCustomConfig().getBoolean(s + ".UseTimer", true);
                    int maxmobs = sl.getCustomConfig().getInt(s + ".MaxMobs", -1);
                    int mps = sl.getCustomConfig().getInt(s + ".MobsPerSpawn", 1);
                    int cooldown = sl.getCustomConfig().getInt(s + ".Cooldown", 0);
                    int cooldownTimer = sl.getCustomConfig().getInt(s + ".CooldownTimer", 0);
                    int warmup = sl.getCustomConfig().getInt(s + ".Warmup", 0);
                    int warmupTimer = sl.getCustomConfig().getInt(s + ".WarmupTimer", 0);
                    int activeRange = sl.getCustomConfig().getInt(s + ".ActivationRange", 40);
                    int leashRange = sl.getCustomConfig().getInt(s + ".LeashRange", 0);
                    boolean leashHeal = sl.getCustomConfig().getBoolean(s + ".HealOnLeash", false);
                    boolean leashResetThreat = sl.getCustomConfig().getBoolean(s + ".ResetThreatOnLeash", false);
                    int mobLevel = sl.getCustomConfig().getInt(s + ".MobLevel", 1);
                    boolean breakable = sl.getCustomConfig().getBoolean(s + ".Breakable", false);
                    boolean checkForPlayers = sl.getCustomConfig().getBoolean(s + ".CheckForPlayers", true);
                    boolean showFlames = sl.getCustomConfig().getBoolean(s + ".ShowFlames", false);
                    List strConditions = sl.getCustomConfig().getStringList(s + ".Conditions");
                    int activeMobs = sl.getCustomConfig().getInt(s + ".ActiveMobs", 0);
                    ArrayList<String> conditions = new ArrayList<String>();
                    for (String c : strConditions) {
                        conditions.add(c);
                    }
                    MythicSpawner ms = new MythicSpawner(sName, sGroup, sMob, world, x, y, z, radius, radiusY, usetimer, maxmobs, mps, mobLevel, cooldown, cooldownTimer, warmup, warmupTimer, activeRange, leashRange, leashHeal, leashResetThreat, showFlames, breakable, activeMobs, checkForPlayers, conditions);
                    this.registerSpawner(ms);
                }
                catch (Exception ex) {
                    MythicMobs.throwSevere("error-spawners-spawnerload", "Error loading MythicSpawner {0}: enable debugging for stacktrace.", s);
                    if (ConfigManager.debugLevel <= 0) continue;
                    ex.printStackTrace();
                }
            }
        }
        this.buildSpawnerChunkLookupTable();
    }

    private void registerSpawner(MythicSpawner spawner) {
        this.listSpawners.add(spawner);
        if (!this.mmSpawnerHashcodeLookup.containsKey(spawner.hashCode())) {
            this.mmSpawnerHashcodeLookup.put(spawner.hashCode(), spawner);
        } else {
            MythicSpawner conflict = this.mmSpawnerHashcodeLookup.get(spawner.hashCode());
            MythicMobs.error("WARNING: HashCode collision detected when loading spawners.");
            MythicMobs.error("Spawner 1 Hash: " + spawner.hashCode() + " Type: " + this.mmSpawnerHashcodeLookup.get(spawner.hashCode()).getInternalName());
            MythicMobs.error("Spawner 2 Hash: " + conflict.hashCode() + " Type: " + conflict.getInternalName());
            MythicMobs.error("We recommend changing one of these spawners' names to avoid issues resolving mob type.");
        }
    }

    public void saveSpawners() {
        this.listSpawners.forEach(ms -> this.saveSpawner((MythicSpawner)ms));
    }

    private boolean saveSpawner(MythicSpawner ms) {
        if (ms.getName().startsWith("Temp#")) {
            return true;
        }
        File spawnerFile = new File(this.core.getDataFolder() + System.getProperty("file.separator") + "Spawners", ms.getName() + ".yml");
        if (!spawnerFile.exists()) {
            spawnerFile.getParentFile().mkdirs();
            try {
                spawnerFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        YamlConfiguration spawner = new YamlConfiguration();
        spawner.set(ms.getName() + ".SpawnerGroup", (Object)ms.getGroup());
        spawner.set(ms.getName() + ".MobName", (Object)ms.getTypeName());
        spawner.set(ms.getName() + ".World", (Object)ms.getWorldName());
        spawner.set(ms.getName() + ".X", (Object)ms.getBlockX());
        spawner.set(ms.getName() + ".Y", (Object)ms.getBlockY());
        spawner.set(ms.getName() + ".Z", (Object)ms.getBlockZ());
        spawner.set(ms.getName() + ".Radius", (Object)ms.getSpawnRadius());
        spawner.set(ms.getName() + ".UseTimer", (Object)ms.getUseTimer());
        spawner.set(ms.getName() + ".MaxMobs", (Object)ms.getMaxMobs());
        spawner.set(ms.getName() + ".MobLevel", (Object)ms.getMobLevel());
        spawner.set(ms.getName() + ".MobsPerSpawn", (Object)ms.getMobsPerSpawn());
        spawner.set(ms.getName() + ".Cooldown", (Object)ms.getCooldownSeconds());
        spawner.set(ms.getName() + ".CooldownTimer", (Object)ms.getRemainingCooldownSeconds());
        spawner.set(ms.getName() + ".Warmup", (Object)ms.getWarmupSeconds());
        spawner.set(ms.getName() + ".WarmupTimer", (Object)ms.getRemainingWarmupSeconds());
        spawner.set(ms.getName() + ".CheckForPlayers", (Object)ms.getCheckForPlayers());
        spawner.set(ms.getName() + ".ActivationRange", (Object)ms.getActivationRange());
        spawner.set(ms.getName() + ".LeashRange", (Object)ms.getLeashRange());
        spawner.set(ms.getName() + ".HealOnLeash", (Object)ms.getHealLeashedMobs());
        spawner.set(ms.getName() + ".ResetThreatOnLeash", (Object)ms.getLeashResetsThreat());
        spawner.set(ms.getName() + ".ShowFlames", (Object)ms.getShowFlames());
        spawner.set(ms.getName() + ".Breakable", (Object)ms.isBreakable());
        spawner.set(ms.getName() + ".Conditions", ms.getConditionList());
        spawner.set(ms.getName() + ".ActiveMobs", (Object)ms.getAssociatedMobs().size());
        try {
            spawner.save(spawnerFile);
        }
        catch (IOException e) {
            MythicMobs.error("Could not save configuration for spawner: " + ms.getName());
            e.printStackTrace();
        }
        return true;
    }

    public Collection<MythicSpawner> getSpawners() {
        return this.listSpawners;
    }

    public void setBreakable(MythicSpawner spawner, boolean bool) {
        if (bool) {
            this.mmBreakableSpawners.put(spawner.getLocation(), spawner);
        } else {
            this.mmBreakableSpawners.remove(spawner.getLocation());
        }
    }

    public void tickSpawnerClocks() {
        this.listSpawners.stream().forEach(spawner -> {
            MythicMobs.inst().getTimingsHandler().markSpawnerNew(spawner.getName());
            spawner.tickSpawnerClock();
            MythicMobs.inst().getTimingsHandler().markSpawnerComplete(spawner.getName());
        });
    }

    public void resetAndSaveAll() {
        for (MythicSpawner ms : this.listSpawners) {
            ms.unloadSpawner();
        }
        this.saveSpawners();
    }

    public ArrayList<MythicSpawner> getSpawnersByString(String string) {
        return this.getSpawnersByString(null, string);
    }

    public ArrayList<MythicSpawner> getSpawnersByString(AbstractLocation abstractLocation, String string) {
        if (string == null) {
            return null;
        }
        ArrayList<MythicSpawner> msl = new ArrayList();
        if (string.startsWith("g:")) {
            String group = string.substring(2);
            msl = this.getSpawnersByGroup(group);
        } else if (string.startsWith("r:")) {
            if (abstractLocation == null) {
                return null;
            }
            String sradius = string.substring(2);
            double radius = 0.0;
            try {
                radius = Double.parseDouble(sradius);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (MythicSpawner ms : MythicMobs.inst().getSpawnerManager().getSpawners()) {
                if (ms.getLocation().getWorld() == null || !ms.getLocation().getWorld().equals(abstractLocation.getWorld()) || !(ms.distanceTo(abstractLocation) <= radius)) continue;
                msl.add(ms);
            }
        } else if (string.equals("*")) {
            for (MythicSpawner ms : MythicMobs.inst().getSpawnerManager().getSpawners()) {
                msl.add(ms);
            }
        } else if (string.contains("*") || string.contains("?")) {
            for (MythicSpawner ms : MythicMobs.inst().getSpawnerManager().getSpawners()) {
                if (!ms.getName().matches(string.replace("?", ".?").replace("*", ".*?"))) continue;
                msl.add(ms);
            }
        } else {
            MythicSpawner ms = this.getSpawnerByName(string);
            if (ms != null) {
                msl.add(ms);
            }
        }
        return msl;
    }

    public MythicSpawner getSpawnerByName(String name) {
        for (MythicSpawner s : this.listSpawners) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public ArrayList<MythicSpawner> getSpawnersByGroup(String group) {
        ArrayList<MythicSpawner> msl = new ArrayList<MythicSpawner>();
        for (MythicSpawner s : this.listSpawners) {
            try {
                if (!s.getGroup().equals(group)) continue;
                msl.add(s);
            }
            catch (Exception e) {}
        }
        return msl;
    }

    public MythicSpawner getSpawnerAtLocation(AbstractLocation location) {
        for (MythicSpawner s : this.listSpawners) {
            if (!s.getLocation().equals(location)) continue;
            return s;
        }
        return null;
    }

    public Optional<MythicSpawner> getSpawnerByHashcode(int hashcode) {
        return Optional.ofNullable(this.mmSpawnerHashcodeLookup.getOrDefault(hashcode, null));
    }

    public Optional<Collection<MythicSpawner>> getSpawnersByChunk(String lookup) {
        return Optional.ofNullable(this.mmChunkSpawnerLookup.getOrDefault(lookup, null));
    }

    public boolean hasBreakableSpawner(AbstractLocation location) {
        return this.mmBreakableSpawners.containsKey(location);
    }

    public MythicSpawner createSpawner(String name, Location location, String mobName) {
        MythicMobs.debug(2, "Creating New Spawner at " + location.getX() + "," + location.getY() + "," + location.getZ());
        if (this.getSpawnerByName(name) != null) {
            MythicMobs.debug(3, "-- Spawner creation failed due to bad name.");
            return null;
        }
        if (MythicMobs.inst().getMobManager().getMythicMob(mobName) == null) {
            MythicMobs.debug(3, "-- Spawner creation failed due to bad mob name.");
            return null;
        }
        MythicSpawner newspawner = new MythicSpawner(name, BukkitAdapter.adapt(location), mobName);
        this.listSpawners.add(newspawner);
        this.saveSpawner(newspawner);
        MythicMobs.debug(2, "New spawner created successfully!");
        return newspawner;
    }

    public boolean copySpawner(String name, String nameNew, AbstractLocation location) {
        MythicSpawner msNew;
        MythicMobs.debug(2, "Creating Copy of Spawner at " + location.getX() + "," + location.getY() + "," + location.getZ());
        MythicSpawner ms = this.getSpawnerByName(name);
        try {
            msNew = ms.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return false;
        }
        msNew.setName(nameNew);
        msNew.setLocation(location);
        msNew.setWorld(location.getWorld().getName());
        msNew.setBlockX(location.getBlockX());
        msNew.setBlockY(location.getBlockY());
        msNew.setBlockZ(location.getBlockZ());
        msNew.setAssociatedMobs(new ArrayList<UUID>());
        msNew.getAssociatedMobs().clear();
        msNew.setBreakable(false);
        msNew.setBreakable(ms.isBreakable());
        this.addSpawnerToChunkLookupTable(msNew);
        this.listSpawners.add(msNew);
        this.saveSpawner(msNew);
        MythicMobs.debug(2, "New spawner cloned successfully!");
        return true;
    }

    public boolean moveSpawner(String name, AbstractLocation location) {
        MythicMobs.debug(2, "Moving spawner to " + location.getX() + "," + location.getY() + "," + location.getZ());
        MythicSpawner ms = this.getSpawnerByName(name);
        if (ms == null) {
            return false;
        }
        return this.moveSpawner(ms, location);
    }

    public boolean moveSpawner(MythicSpawner ms, AbstractLocation location) {
        MythicMobs.debug(2, "Moving spawner to " + location.getX() + "," + location.getY() + "," + location.getZ());
        this.removeSpawnerFromChunkLookupTable(ms);
        ms.setLocation(location);
        ms.setWorld(location.getWorld().getName());
        ms.setBlockX(location.getBlockX());
        ms.setBlockY(location.getBlockY());
        ms.setBlockZ(location.getBlockZ());
        this.addSpawnerToChunkLookupTable(ms);
        this.saveSpawner(ms);
        MythicMobs.debug(2, "Spawner moved successfully!");
        return true;
    }

    public static synchronized boolean mobIsValid(Location location, UUID u) {
        if (location.getWorld() == null) {
            return true;
        }
        for (LivingEntity l : location.getWorld().getLivingEntities()) {
            if (!l.getUniqueId().equals(u)) continue;
            return true;
        }
        return false;
    }

    public static boolean playerWithinSpawnerRange(int range, AbstractLocation location) {
        int rangeSquared = (int)Math.pow(range, 2.0);
        for (AbstractPlayer player : MythicMobs.inst().getEntityManager().getPlayers(location.getWorld())) {
            if (!location.getWorld().equals(player.getWorld()) || !(location.distanceSquared(player.getLocation()) <= (double)rangeSquared)) continue;
            return true;
        }
        return false;
    }

    public static void RemoveMobFromSpawners(ActiveMob am) {
        if (am.getSpawner() != null) {
            am.getSpawner().markMobDead(am);
        }
    }

    public boolean setSpawnerAttribute(MythicSpawner ms, String attr, String value) {
        try {
            switch (attr.toLowerCase()) {
                case "group": {
                    ms.setGroup(value);
                    break;
                }
                case "radius": 
                case "r": {
                    ms.setSpawnRadius(Integer.parseInt(value));
                    break;
                }
                case "radiusy": 
                case "ry": {
                    ms.setSpawnRadiusY(Integer.parseInt(value));
                    break;
                }
                case "cooldown": 
                case "cd": {
                    ms.setCooldownSeconds(Integer.parseInt(value));
                    break;
                }
                case "warmup": 
                case "wu": {
                    ms.setWarmupSeconds(Integer.parseInt(value));
                    break;
                }
                case "maxmobs": {
                    ms.setMaxMobs(Integer.parseInt(value));
                    break;
                }
                case "moblevel": 
                case "level": 
                case "moblvl": {
                    ms.setMobLevel(Integer.parseInt(value));
                    break;
                }
                case "mobsperspawn": 
                case "mps": {
                    ms.setMobsPerSpawn(Integer.parseInt(value));
                    break;
                }
                case "usetimer": 
                case "timer": {
                    ms.setUseTimer(Boolean.parseBoolean(value));
                    break;
                }
                case "showflames": 
                case "flames": {
                    ms.setShowFlames(Boolean.parseBoolean(value));
                    break;
                }
                case "activation": 
                case "activationrange": 
                case "ar": {
                    ms.setActivationRange(Integer.parseInt(value));
                    break;
                }
                case "leash": 
                case "leashrange": {
                    ms.setLeashRange(Integer.parseInt(value));
                    break;
                }
                case "healonleash": 
                case "leashheal": {
                    ms.setHealLeashedMobs(Boolean.parseBoolean(value));
                    break;
                }
                case "resetthreatonleash": 
                case "leashresetthreat": {
                    ms.setLeashResetsThreat(Boolean.parseBoolean(value));
                    break;
                }
                case "mobtype": {
                    if (MythicMobs.inst().getMobManager().getMythicMob(value) != null) {
                        ms.setType(value);
                    }
                    break;
                }
                case "breakable": {
                    ms.setBreakable(Boolean.parseBoolean(value));
                    break;
                }
                case "checkforplayers": {
                    ms.setCheckForPlayers(Boolean.parseBoolean(value));
                    break;
                }
                default: {
                    MythicMobs.debug(1, "The attribute " + attr + " does not exist!");
                    return false;
                }
            }
        }
        catch (Exception e) {
            MythicMobs.debug(1, "The value " + value + " is invalid for attribute " + attr);
            return false;
        }
        this.saveSpawner(ms);
        return true;
    }

    public boolean addSpawnerCondition(MythicSpawner ms, String condition, String value) {
        if (SCondition.getSpawningConditionByName(condition) == null) {
            MythicMobs.debug(1, "The condition " + condition + " does not exist!");
            return false;
        }
        ms.getConditionList().add(condition + " " + value);
        this.saveSpawner(ms);
        return true;
    }

    public boolean removeSpawnerCondition(MythicSpawner ms, String condition) {
        for (String s : ms.getConditionList()) {
            if (!s.contains(condition)) continue;
            ms.getConditionList().remove(s);
            this.saveSpawner(ms);
            return true;
        }
        return false;
    }

    public boolean removeSpawner(MythicSpawner ms) {
        if (ms.isBreakable()) {
            this.mmBreakableSpawners.remove(ms.getLocation());
        }
        this.listSpawners.remove(ms);
        File spawnerFile = new File(MythicMobs.inst().getDataFolder() + System.getProperty("file.separator") + "Spawners", ms.getName() + ".yml");
        spawnerFile.delete();
        return true;
    }

    public Location findSpawningLocation(Location location, int radius) {
        for (int tries = 0; tries < 64; ++tries) {
            Location spawnLoc = SpawnerManager.randomizeSpawnLocation(location, radius);
            if (!this.areaIsEmpty(spawnLoc)) continue;
            return spawnLoc;
        }
        return null;
    }

    public static Location randomizeSpawnLocation(Location location, int r) {
        double z;
        double y;
        double x;
        double sX = location.getX();
        double sY = location.getY();
        double sZ = location.getZ();
        do {
            x = SpawnerManager.randomRange(sX - (double)r, sX + (double)r);
            y = SpawnerManager.randomRange(sY - (double)r, sY + (double)r);
            z = SpawnerManager.randomRange(sZ - (double)r, sZ + (double)r);
        } while (location.distance(new Location(location.getWorld(), x, y, z)) > (double)r);
        return new Location(location.getWorld(), x, y, z);
    }

    public static double randomRange(double arg0, double arg1) {
        double range;
        double d = range = arg0 < arg1 ? arg1 - arg0 : arg0 - arg1;
        if (range < 1.0) {
            return Math.floor(arg0) + 0.5;
        }
        double min = arg0 < arg1 ? arg0 : arg1;
        return Math.floor(min + Math.random() * range) + 0.5;
    }

    public boolean areaIsEmpty(Location loc) {
        return true;
    }

    public void addSpawnerToChunkLookupTable(MythicSpawner ms) {
        String cS = ms.getChunkString();
        if (this.mmChunkSpawnerLookup.contains(cS)) {
            this.mmChunkSpawnerLookup.get(cS).add(ms);
        } else {
            HashSet<MythicSpawner> hs = new HashSet<MythicSpawner>();
            hs.add(ms);
            this.mmChunkSpawnerLookup.put(cS, hs);
        }
    }

    public void removeSpawnerFromChunkLookupTable(MythicSpawner ms) {
        String cS = ms.getChunkString();
        if (this.mmChunkSpawnerLookup.contains(cS)) {
            this.mmChunkSpawnerLookup.get(cS).remove(ms);
        }
    }

    public void buildSpawnerChunkLookupTable() {
        this.mmChunkSpawnerLookup.clear();
        for (MythicSpawner ms : this.listSpawners) {
            this.addSpawnerToChunkLookupTable(ms);
        }
    }
}

