/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.IEntitySelector;
import java.util.HashSet;

public class LivingEntitiesInLineTargeter
extends IEntitySelector {
    protected float radius = 1.0f;
    protected float radiusSq;
    protected boolean fromOrigin = false;

    public LivingEntitiesInLineTargeter(MythicLineConfig mlc) {
        super(mlc);
        this.radius = mlc.getFloat(new String[]{"radius", "r"}, this.radius);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.radiusSq = this.radius * this.radius;
    }

    @Override
    public HashSet<AbstractEntity> getEntities(SkillMetadata data) {
        double d;
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        AbstractLocation sl = this.fromOrigin ? data.getOrigin().clone() : data.getCaster().getLocation();
        double range = 1.0;
        if (data.getLocationTargets() != null && data.getLocationTargets().size() > 0) {
            for (AbstractLocation abstractLocation : data.getLocationTargets()) {
                d = abstractLocation.distanceSquared(sl);
                if (!(d > range)) continue;
                range = d;
            }
        } else if (data.getEntityTargets() != null && data.getEntityTargets().size() > 0) {
            for (AbstractEntity abstractEntity : data.getEntityTargets()) {
                d = abstractEntity.getLocation().distanceSquared(sl);
                if (!(d > range)) continue;
                range = d;
            }
        } else {
            return targets;
        }
        SkillCaster am = data.getCaster();
        HashSet<AbstractEntity> hashSet = new HashSet<AbstractEntity>();
        for (AbstractEntity p : MythicMobs.inst().getEntityManager().getLivingEntities(am.getEntity().getWorld())) {
            if (!am.getLocation().getWorld().equals(p.getWorld()) || p.getUniqueId().equals(am.getEntity().getUniqueId()) || !(am.getEntity().getLocation().distanceSquared(p.getLocation()) <= range)) continue;
            hashSet.add(p);
        }
        if (data.getLocationTargets() != null && data.getLocationTargets().size() > 0) {
            data.getLocationTargets().forEach(l -> {
                MythicMobs.log("A");
                int c = (int)Math.ceil(sl.distance((AbstractLocation)l) / (double)this.radius) - 1;
                if (c <= 0) {
                    return;
                }
                AbstractVector v = l.toVector().subtract(sl.toVector()).normalize().multiply(this.radius);
                AbstractLocation l2 = sl.clone();
                for (int i = 0; i < c; ++i) {
                    l2.add(v);
                    for (AbstractEntity e : possible) {
                        if (!(e.getLocation().distanceSquared(l2) <= (double)this.radiusSq)) continue;
                        targets.add(e);
                    }
                }
            });
        } else if (data.getEntityTargets() != null && data.getEntityTargets().size() > 0) {
            data.getEntityTargets().forEach(ee -> {
                AbstractLocation l = ee.getLocation();
                int c = (int)Math.ceil(sl.distance(l) / (double)this.radius) - 1;
                if (c <= 0) {
                    return;
                }
                AbstractVector v = l.toVector().subtract(sl.toVector()).normalize().multiply(this.radius);
                AbstractLocation l2 = sl.clone();
                for (int i = 0; i < c; ++i) {
                    l2.add(v);
                    for (AbstractEntity e : possible) {
                        if (!(e.getLocation().distanceSquared(l2) <= (double)this.radiusSq)) continue;
                        targets.add(e);
                    }
                }
            });
        }
        return targets;
    }
}

