/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MobManager;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;

public class TeleportSkill
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected double spreadH;
    protected double spreadV;

    public TeleportSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.spreadH = mlc.getDouble("spreadh", 0.0);
        this.spreadH = mlc.getDouble("sh", this.spreadH);
        this.spreadV = mlc.getDouble("spreadv", 0.0);
        this.spreadV = mlc.getDouble("sv", this.spreadV);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (data.getCaster() instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)data.getCaster();
            AbstractEntity abstractEntity = am.getEntity();
            MythicMobs.inst().getMobManager();
            abstractEntity.teleport(MobManager.findSafeSpawnLocation(target.getLocation(), (int)this.spreadH, (int)this.spreadV, am.getType().getMythicEntity().getHeight() + 1));
        } else {
            AbstractEntity abstractEntity = data.getCaster().getEntity();
            MythicMobs.inst().getMobManager();
            abstractEntity.teleport(MobManager.findSafeSpawnLocation(target.getLocation(), (int)this.spreadH, (int)this.spreadV, 2));
        }
        return true;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        if (this.spreadH > 0.0 || this.spreadV > 0.0) {
            if (data.getCaster() instanceof ActiveMob) {
                ActiveMob am = (ActiveMob)data.getCaster();
                MythicMobs.inst().getMobManager();
                target = MobManager.findSafeSpawnLocation(target, (int)this.spreadH, (int)this.spreadV, am.getType().getMythicEntity().getHeight() + 1);
            } else {
                MythicMobs.inst().getMobManager();
                target = MobManager.findSafeSpawnLocation(target, (int)this.spreadH, (int)this.spreadV, 2);
            }
        }
        data.getCaster().getEntity().teleport(target);
        return true;
    }
}

