/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.TaskManager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class SpringSkill
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private int tickDuration;
    private Material type;

    public SpringSkill(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.tickDuration = mlc.getInteger(new String[]{"duration", "d"}, 40);
        String strType = mlc.getString(new String[]{"type", "t"}, "water", new String[0]);
        this.type = strType.equalsIgnoreCase("lava") ? Material.LAVA : (strType.equalsIgnoreCase("water") ? Material.WATER : Material.WATER);
        if (this.tickDuration <= 0) {
            this.tickDuration = 10;
        }
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(data.getCaster(), target);
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(data.getCaster(), target.getLocation());
        return true;
    }

    protected void playEffect(SkillCaster am, AbstractLocation target) {
        Block block = BukkitAdapter.adapt(target).getBlock();
        if (block.getType() == Material.AIR) {
            block.setType(this.type, true);
            new Animator(target);
        }
    }

    private class Animator
    implements Runnable {
        private AbstractLocation location;

        public Animator(AbstractLocation location) {
            this.location = location;
            TaskManager.get().runLater(this, SpringSkill.this.tickDuration);
        }

        @Override
        public void run() {
            block2: {
                try {
                    BukkitAdapter.adapt(this.location).getBlock().setType(Material.AIR, true);
                }
                catch (Exception ex) {
                    if (ConfigManager.debugLevel <= 0) break block2;
                    ex.printStackTrace();
                }
            }
        }
    }
}

