/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.IMetaSkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import java.util.Optional;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SkillSkill
extends SkillMechanic
implements IMetaSkill {
    protected String skillName;
    protected Optional<Skill> metaskill;

    public SkillSkill(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.target_creative = true;
        this.skillName = mlc.getString(new String[]{"skill", "s", "meta", "s"});
        MythicMobs.inst().getSkillManager().queueSecondPass(() -> {
            MythicMobs.debug(3, "-- Loading SkillSkill pointing at " + this.skillName);
            this.metaskill = MythicMobs.inst().getSkillManager().getSkill(this.skillName);
            if (!this.metaskill.isPresent()) {
                MythicMobs.error("Could not find AbstractSkill " + this.skillName);
            } else {
                MythicMobs.debug(3, "---- Loaded SkillSkill successfully");
            }
        });
    }

    public Skill getSkill() {
        return this.metaskill.get();
    }

    @Override
    public boolean cast(final SkillMetadata data) {
        if (this.metaskill.isPresent()) {
            final Skill ms = this.metaskill.get();
            if (ms.isUsable(data)) {
                MythicMobs.debug(3, "------ Executing Skill " + this.skillName);
                if (this.forceSync && data.getIsAsync()) {
                    data.setIsAsync(false);
                    new BukkitRunnable(){

                        public void run() {
                            data.setIsAsync(false);
                            ms.execute(data);
                        }
                    }.runTask((Plugin)MythicMobs.inst());
                } else {
                    ms.execute(data);
                }
            } else {
                MythicMobs.debug(3, "------ Skill is not usable at this time! Cancelling.");
                return false;
            }
        }
        return true;
    }
}

