/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;

public class SetLevelSkill
extends SkillMechanic
implements INoTargetSkill {
    protected SetLevelAction action;
    protected int level;

    public SetLevelSkill(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        String strAction = mlc.getString(new String[]{"action", "a"}, "SET", new String[0]);
        try {
            this.action = SetLevelAction.valueOf(strAction.toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.level = mlc.getInteger(new String[]{"level", "l"}, 1);
    }

    @Override
    public boolean cast(SkillMetadata data) {
        if (!(data.getCaster() instanceof ActiveMob)) {
            return false;
        }
        ActiveMob am = (ActiveMob)data.getCaster();
        if (this.action == SetLevelAction.SET) {
            am.setLevel(this.level);
        } else if (this.action == SetLevelAction.ADD) {
            am.setLevel(am.getLevel() + this.level);
        } else if (this.action == SetLevelAction.SUBTRACT) {
            am.setLevel(am.getLevel() - this.level);
        } else if (this.action == SetLevelAction.MULTIPLY) {
            am.setLevel(am.getLevel() * this.level);
        } else if (this.action == SetLevelAction.DIVIDE) {
            am.setLevel(am.getLevel() / this.level);
        }
        return true;
    }

    protected static enum SetLevelAction {
        SET,
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE;

    }
}

