/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import java.util.ArrayList;
import java.util.List;

public class RandomMessageSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected List<String> messages = new ArrayList<String>();

    public RandomMessageSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.target_creative = true;
        try {
            String m = mlc.getString(new String[]{"messages", "message", "msg", "msgs", "m"});
            for (String s : m.split(",")) {
                this.messages.add(s.substring(1, s.length() - 1));
                MythicMobs.debug(2, "-- Loaded RandomMessage " + s.substring(1, s.length() - 1));
            }
        }
        catch (Exception ex) {
            MythicMobs.skillConfigError("RANDOMMESSAGE", line, "The 'messages' attribute is required.");
            this.messages.add("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.");
            MythicMobs.inst().handleException(ex);
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        String message = this.messages.get(MythicMobs.r.nextInt(this.messages.size()));
        MythicMobs.debug(2, "Executing RandomMessage skill with message: " + message);
        String m = SkillString.parseMobVariables(message, data.getCaster(), target, data.getTrigger());
        if (target.isPlayer()) {
            target.asPlayer().sendMessage(m);
            return true;
        }
        return false;
    }
}

